/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.integration.ae2;

import appeng.api.AEApi;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import com.mordenkainen.equivalentenergistics.core.config.ConfigManager;
import com.mordenkainen.equivalentenergistics.integration.Integration;
import com.mordenkainen.equivalentenergistics.items.ItemEMCCrystal;
import com.mordenkainen.equivalentenergistics.items.ItemEnum;
import com.mordenkainen.equivalentenergistics.items.ItemPattern;
import java.util.ArrayList;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public final class EMCCraftingPattern
implements ICraftingPatternDetails {
    private IAEItemStack[] ingredients;
    private final IAEItemStack[] result = new IAEItemStack[1];
    public double outputEMC;
    public double inputEMC;
    public boolean valid = true;

    public EMCCraftingPattern(ItemStack craftingResult) {
        this.buildPattern(craftingResult);
    }

    public ItemStack getPattern() {
        return ItemPattern.getItemForPattern(this.result[0].getItemStack());
    }

    public boolean isValidItemForSlot(int slotIndex, ItemStack itemStack, World world) {
        return false;
    }

    public boolean isCraftable() {
        return false;
    }

    public IAEItemStack[] getInputs() {
        return (IAEItemStack[])this.ingredients.clone();
    }

    public IAEItemStack[] getCondensedInputs() {
        return this.getInputs();
    }

    public ItemStack getOutput(InventoryCrafting craftingInv, World world) {
        return null;
    }

    public IAEItemStack[] getOutputs() {
        return (IAEItemStack[])this.result.clone();
    }

    public IAEItemStack[] getCondensedOutputs() {
        return this.getOutputs();
    }

    public boolean canSubstitute() {
        return false;
    }

    public int getPriority() {
        return -1;
    }

    public void setPriority(int priority) {
    }

    private void buildPattern(ItemStack craftingResult) {
        if (craftingResult.func_77973_b() == ItemEnum.EMCCRYSTAL.getItem()) {
            this.createCrystalPattern(craftingResult.func_77960_j());
        } else {
            this.createItemPattern(craftingResult);
        }
    }

    public void rebuildPattern() {
        this.buildPattern(this.result[0].getItemStack());
    }

    private void createCrystalPattern(int tier) {
        this.valid = true;
        this.outputEMC = this.inputEMC = ItemEMCCrystal.CRYSTAL_VALUES[tier + 1];
        this.result[0] = AEApi.instance().storage().createItemStack(ItemEnum.EMCCRYSTAL.getStack(64, tier));
        this.ingredients = new IAEItemStack[]{AEApi.instance().storage().createItemStack(ItemEnum.EMCCRYSTAL.getDamagedStack(tier + 1))};
    }

    private void createItemPattern(ItemStack craftingResult) {
        int stackSize = 1;
        double singleItemValue = Integration.emcHandler.getSingleEnergyValue(craftingResult);
        if (singleItemValue <= ConfigManager.maxStackEMC) {
            stackSize = (int)Math.min(64.0, ConfigManager.maxStackEMC / singleItemValue);
        }
        this.result[0] = (IAEItemStack)AEApi.instance().storage().createItemStack(craftingResult).setStackSize((long)stackSize);
        double remainingEMC = this.outputEMC = singleItemValue * (double)stackSize;
        this.inputEMC = 0.0;
        this.valid = false;
        ArrayList<Object> crystals = new ArrayList<Object>();
        for (int x = 4; x >= 0 && remainingEMC > 0.0; --x) {
            double crystalEMC = ItemEMCCrystal.CRYSTAL_VALUES[x];
            int numCrystals = (int)(remainingEMC / crystalEMC);
            while (numCrystals > 0) {
                crystals.add(AEApi.instance().storage().createItemStack(ItemEnum.EMCCRYSTAL.getDamagedStack(x)).setStackSize((long)numCrystals));
                double totalEMC = crystalEMC * (double)numCrystals;
                this.inputEMC += totalEMC;
                numCrystals = (int)((remainingEMC -= totalEMC) / crystalEMC);
            }
        }
        if (remainingEMC > 0.0) {
            if (!crystals.isEmpty() && ((IAEItemStack)crystals.get(crystals.size() - 1)).getItemDamage() == 0) {
                ((IAEItemStack)crystals.get(crystals.size() - 1)).setStackSize(((IAEItemStack)crystals.get(crystals.size() - 1)).getStackSize() + 1L);
            } else {
                crystals.add(AEApi.instance().storage().createItemStack(ItemEnum.EMCCRYSTAL.getDamagedStack(0)));
            }
            this.inputEMC += 1.0;
        }
        this.ingredients = crystals.toArray(new IAEItemStack[crystals.size()]);
        if (crystals.size() <= 9) {
            this.valid = true;
        }
    }
}

