/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.core.textures;

import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;

public enum TextureEnum {
    EMCCONDENSER(TextureType.BLOCK, "EMCCondenser", "EMCCondenserAdv", "EMCCondenserExt", "EMCCondenserUlt"),
    EMCCONDENSEROVL(TextureType.BLOCK, "EMCCondenserInput", "EMCCondenserOutput", "EMCCondenserLights", "EMCCondenserError"),
    EMCBOOK(TextureType.ITEM, "EMCBook"),
    EMCCRYSTAL(TextureType.ITEM, "EMCNugget", "EMCShard", "EMCCrystal", "DenseEMCCrystal", "SuperDenseEMCCrystal"),
    EMCCRYSTALOLD(TextureType.ITEM, "EMCCrystal"),
    EMCCELL(TextureType.ITEM, "EMCCellTier0", "EMCCellTier1", "EMCCellTier2", "EMCCellTier3", "EMCCellTier4", "EMCCellTier5", "EMCCellTier6", "EMCCellTier7"),
    EMCCELLCREATIVE(TextureType.ITEM, "EMCCellCreative"),
    MISCITEM(TextureType.ITEM, "EMCCellHousing", "EMCTotal"),
    EMCSTORAGECOMPONENT(TextureType.ITEM, "EMCStorageComponent0", "EMCStorageComponent1", "EMCStorageComponent2", "EMCStorageComponent3", "EMCStorageComponent4", "EMCStorageComponent5", "EMCStorageComponent6", "EMCStorageComponent7"),
    EMCASSEMBLER(TextureType.BLOCK, "EMCAssemblerLights", "EMCAssemblerError");

    private TextureType textureType;
    private String[] textureNames;
    private IIcon[] textures;

    private TextureEnum(TextureType type, String ... names) {
        this.textureType = type;
        this.textureNames = names;
        this.textures = new IIcon[this.textureNames.length];
    }

    public IIcon getTexture() {
        return this.textures[0];
    }

    public IIcon getTexture(int id) {
        return this.textures[id];
    }

    public IIcon[] getTextures() {
        return (IIcon[])this.textures.clone();
    }

    public static void registerTextures(TextureMap textureMap) {
        for (TextureEnum currentTexture : TextureEnum.values()) {
            if (textureMap.func_130086_a() != currentTexture.textureType.getTextureType()) continue;
            String header = "equivalentenergistics:";
            if (currentTexture.textureType == TextureType.PART) {
                header = header + "part/";
            }
            for (int i = 0; i < currentTexture.textureNames.length; ++i) {
                currentTexture.textures[i] = textureMap.func_94245_a(header + currentTexture.textureNames[i]);
            }
        }
    }

    private static enum TextureType {
        ITEM(1),
        BLOCK(0),
        PART(0);

        private int textureType;

        private TextureType(int textureType) {
            this.textureType = textureType;
        }

        public int getTextureType() {
            return this.textureType;
        }
    }
}

