/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.blocks.crafter.tiles;

import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import com.mordenkainen.equivalentenergistics.blocks.BlockEnum;
import com.mordenkainen.equivalentenergistics.blocks.crafter.BlockEMCCrafter;
import com.mordenkainen.equivalentenergistics.blocks.crafter.tiles.CraftingManager;
import com.mordenkainen.equivalentenergistics.blocks.crafter.tiles.ICraftingMonitor;
import com.mordenkainen.equivalentenergistics.integration.Integration;
import com.mordenkainen.equivalentenergistics.integration.ae2.EMCCraftingPattern;
import com.mordenkainen.equivalentenergistics.integration.ae2.cache.crafting.ITransProvider;
import com.mordenkainen.equivalentenergistics.integration.ae2.grid.GridUtils;
import com.mordenkainen.equivalentenergistics.integration.ae2.tiles.TileAEBase;
import com.mordenkainen.equivalentenergistics.integration.waila.IWailaNBTProvider;
import com.mordenkainen.equivalentenergistics.util.IDropItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class TileEMCCrafterBase
extends TileAEBase
implements ICraftingProvider,
IGridTickable,
IWailaNBTProvider,
IDropItems,
ICraftingMonitor,
ITransProvider {
    private static final String TOME_TAG = "Tome";
    private static final String OWNER_TAG = "Owner";
    private static final String EMC_TAG = "CurrentEMC";
    private static final String CRAFTING_TAG = "Crafting";
    private static final String DISPLAY_TAG = "DisplayStacks";
    private static final String STACK_TAG = "Stack";
    private static final String ERROR_TAG = "Errored";
    private ItemStack transmutationItem;
    private double currentEMC;
    private List<ItemStack> displayStacks = new ArrayList<ItemStack>();
    private final CraftingManager manager;
    private boolean crafting;
    private boolean errored;
    private boolean doDrops = true;
    public final int maxJobs;

    public TileEMCCrafterBase(int jobs, double time, int meta) {
        super(new ItemStack(Item.func_150898_a((Block)BlockEnum.EMCCRAFTER.getBlock()), 1, meta));
        this.gridProxy.setIdlePowerUsage(BlockEMCCrafter.idlePower);
        this.gridProxy.setFlags(GridFlags.REQUIRE_CHANNEL);
        this.maxJobs = jobs;
        this.manager = new CraftingManager(time, this.maxJobs, this, this.getProxy(), this.mySource);
    }

    @Override
    public NBTTagCompound getWailaTag(NBTTagCompound tag) {
        if (this.currentEMC > 0.0) {
            tag.func_74780_a(EMC_TAG, this.currentEMC);
        }
        if (this.transmutationItem != null) {
            tag.func_74778_a(OWNER_TAG, Integration.emcHandler.getTomeOwner(this.transmutationItem));
        }
        return tag;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 20, false, true);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLast) {
        if (this.refreshNetworkState()) {
            this.markForUpdate();
        }
        if (!this.isActive()) {
            return TickRateModulation.IDLE;
        }
        this.injectEMC();
        if (this.manager.isCrafting()) {
            boolean newState;
            boolean bl = newState = !this.manager.craftingTick();
            if (newState != this.errored) {
                this.errored = newState;
                this.markForUpdate();
            }
            return TickRateModulation.URGENT;
        }
        return TickRateModulation.IDLE;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.currentEMC = data.func_74769_h(EMC_TAG);
        this.transmutationItem = data.func_74764_b(TOME_TAG) ? ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)data.func_74781_a(TOME_TAG))) : null;
        this.manager.readFromNBT(data);
        this.displayStacks = this.manager.getCurrentJobs();
        this.markForUpdate();
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        if (this.currentEMC > 0.0) {
            data.func_74780_a(EMC_TAG, this.currentEMC);
        }
        if (this.transmutationItem != null) {
            data.func_74782_a(TOME_TAG, (NBTBase)this.transmutationItem.func_77955_b(new NBTTagCompound()));
        }
        this.manager.writeToNBT(data);
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        if (this.isActive() && patternDetails instanceof EMCCraftingPattern && this.manager.addJob(patternDetails.getOutputs()[0].getItemStack(), ((EMCCraftingPattern)patternDetails).outputEMC, BlockEMCCrafter.powerPerEMC)) {
            this.currentEMC += ((EMCCraftingPattern)patternDetails).inputEMC - ((EMCCraftingPattern)patternDetails).outputEMC;
            this.displayStacks = this.manager.getCurrentJobs();
            this.markForUpdate();
            return true;
        }
        return false;
    }

    public boolean isBusy() {
        return this.manager.isBusy();
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        GridUtils.addPatterns(this.getProxy(), (ICraftingMedium)this, craftingTracker);
    }

    public ItemStack getCurrentTome() {
        return this.transmutationItem;
    }

    public void setCurrentTome(ItemStack heldItem) {
        this.transmutationItem = heldItem;
        GridUtils.updatePatterns(this.getProxy());
        this.markForUpdate();
    }

    public boolean canPlayerInteract(EntityPlayer player) {
        return this.checkPermissions(player) && !this.manager.isCrafting();
    }

    private void injectEMC() {
        this.currentEMC -= GridUtils.injectEMC(this.getProxy(), this.currentEMC, Actionable.MODULATE);
    }

    @Override
    public void getDrops(World world, int x, int y, int z, List<ItemStack> drops) {
        if (this.doDrops && this.transmutationItem != null) {
            drops.add(this.transmutationItem);
        }
    }

    @Override
    public void disableDrops() {
        this.doDrops = false;
    }

    @Override
    protected void getPacketData(NBTTagCompound nbttagcompound) {
        super.getPacketData(nbttagcompound);
        nbttagcompound.func_74757_a(CRAFTING_TAG, this.manager.isCrafting());
        nbttagcompound.func_74757_a(ERROR_TAG, this.errored);
        if (this.manager.isCrafting()) {
            NBTTagCompound displayTags = new NBTTagCompound();
            for (int i = 0; i < this.displayStacks.size(); ++i) {
                if (this.displayStacks.get(i) == null) continue;
                displayTags.func_74782_a(STACK_TAG + i, (NBTBase)this.displayStacks.get(i).func_77955_b(new NBTTagCompound()));
            }
            nbttagcompound.func_74782_a(DISPLAY_TAG, (NBTBase)displayTags);
        }
        if (this.transmutationItem != null) {
            nbttagcompound.func_74782_a(TOME_TAG, (NBTBase)this.transmutationItem.func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    protected boolean readPacketData(NBTTagCompound nbttagcompound) {
        this.crafting = nbttagcompound.func_74767_n(CRAFTING_TAG);
        this.errored = nbttagcompound.func_74767_n(ERROR_TAG);
        this.displayStacks = new ArrayList<ItemStack>();
        if (nbttagcompound.func_74764_b(DISPLAY_TAG)) {
            NBTTagCompound invList = nbttagcompound.func_74775_l(DISPLAY_TAG);
            for (int i = 0; i < this.maxJobs; ++i) {
                if (invList.func_74764_b(STACK_TAG + i)) {
                    this.displayStacks.add(ItemStack.func_77949_a((NBTTagCompound)invList.func_74775_l(STACK_TAG + i)));
                    continue;
                }
                this.displayStacks.add(null);
            }
        }
        this.transmutationItem = nbttagcompound.func_74764_b(TOME_TAG) ? ItemStack.func_77949_a((NBTTagCompound)nbttagcompound.func_74775_l(TOME_TAG)) : null;
        return super.readPacketData(nbttagcompound);
    }

    @Override
    public String getPlayerUUID() {
        return this.transmutationItem == null ? null : Integration.emcHandler.getTomeUUID(this.transmutationItem).toString();
    }

    @Override
    public List<ItemStack> getTransmutations() {
        return this.transmutationItem == null ? new ArrayList() : Integration.emcHandler.getTransmutations(this);
    }

    @Override
    public void craftingFinished(ItemStack outputStack) {
        this.displayStacks = this.manager.getCurrentJobs();
        this.markForUpdate();
    }

    public List<ItemStack> getDisplayStacks() {
        return this.displayStacks;
    }

    public boolean isCrafting() {
        return this.crafting;
    }

    public boolean isErrored() {
        return this.errored;
    }
}

