/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.blocks.condenser.tiles;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import com.mordenkainen.equivalentenergistics.blocks.condenser.BlockEMCCondenser;
import com.mordenkainen.equivalentenergistics.blocks.condenser.CondenserState;
import com.mordenkainen.equivalentenergistics.integration.Integration;
import com.mordenkainen.equivalentenergistics.integration.ae2.cache.storage.IEMCStorageGrid;
import com.mordenkainen.equivalentenergistics.integration.ae2.grid.GridAccessException;
import com.mordenkainen.equivalentenergistics.integration.ae2.grid.GridUtils;
import com.mordenkainen.equivalentenergistics.integration.ae2.tiles.TileAEInv;
import com.mordenkainen.equivalentenergistics.items.ItemEnum;
import com.mordenkainen.equivalentenergistics.util.CommonUtils;
import com.mordenkainen.equivalentenergistics.util.inventory.InternalInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileEMCCondenserBase
extends TileAEInv
implements IGridTickable {
    private static final String STATE_TAG = "state";
    protected CondenserState state = CondenserState.IDLE;

    public TileEMCCondenserBase(ItemStack repItem) {
        super(repItem);
        this.internalInventory = new CondenserInventory();
        this.gridProxy.setFlags(GridFlags.REQUIRE_CHANNEL);
        this.gridProxy.setIdlePowerUsage(BlockEMCCondenser.idlePower);
    }

    @Override
    protected void getPacketData(NBTTagCompound nbttagcompound) {
        super.getPacketData(nbttagcompound);
        nbttagcompound.func_74768_a(STATE_TAG, this.state.ordinal());
    }

    @Override
    protected boolean readPacketData(NBTTagCompound nbttagcompound) {
        boolean flag = super.readPacketData(nbttagcompound);
        CondenserState newState = CondenserState.values()[nbttagcompound.func_74762_e(STATE_TAG)];
        if (newState != this.state) {
            this.state = newState;
            flag = true;
        }
        return flag;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 20, false, true);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLast) {
        if (this.refreshNetworkState()) {
            this.markForUpdate();
        }
        CondenserState newState = this.state;
        if (!this.isActive() || ((InternalInventory)this.getInventory()).isEmpty()) {
            this.updateState(CondenserState.IDLE);
        } else {
            newState = this.processInv();
            this.updateState(newState);
        }
        return this.state.getTickRate();
    }

    protected abstract double getEMCPerTick();

    public CondenserState getState() {
        return this.state;
    }

    protected int getMaxItemsForPower(int stackSize, double emcValue) {
        double powerPerItem = emcValue * BlockEMCCondenser.activePower;
        double powerRequired = (double)stackSize * powerPerItem;
        double powerAvail = GridUtils.extractAEPower(this.getProxy(), powerRequired, Actionable.SIMULATE, PowerMultiplier.CONFIG);
        return (int)(powerAvail / powerPerItem);
    }

    protected double processItems(int slot, double remainingEMC, boolean usePower) {
        ItemStack stack = ((InternalInventory)this.getInventory()).func_70301_a(slot);
        double itemEMC = Integration.emcHandler.getSingleEnergyValue(stack);
        try {
            IEMCStorageGrid emcGrid = GridUtils.getEMCStorage(this.getProxy());
            double availEMC = emcGrid.getAvail();
            if (itemEMC > availEMC) {
                return -1.0;
            }
            if (itemEMC > remainingEMC) {
                return remainingEMC;
            }
            int maxToDo = Math.min(stack.field_77994_a, Math.min((int)(availEMC / itemEMC), (int)(remainingEMC / itemEMC)));
            if (usePower) {
                maxToDo = Math.min(this.getMaxItemsForPower(maxToDo, itemEMC), maxToDo);
            }
            if (maxToDo <= 0) {
                return -3.0;
            }
            double toStore = itemEMC * (double)maxToDo;
            if (usePower) {
                GridUtils.extractAEPower(this.getProxy(), toStore * BlockEMCCondenser.activePower, Actionable.MODULATE, PowerMultiplier.CONFIG);
            }
            emcGrid.addEMC(toStore, Actionable.MODULATE);
            stack.field_77994_a -= maxToDo;
            ((InternalInventory)this.getInventory()).func_70299_a(slot, CommonUtils.filterForEmpty(stack));
            return remainingEMC - toStore;
        }
        catch (GridAccessException e) {
            CommonUtils.debugLog("processItems: Error accessing grid:", e);
            return -1.0;
        }
    }

    protected double processStorage(int slot, double remainingEMC) {
        ItemStack stack = ((InternalInventory)this.getInventory()).func_70301_a(slot);
        double itemEMC = Integration.emcHandler.getStoredEMC(stack);
        double toStore = 0.0;
        try {
            if (itemEMC > 0.0) {
                IEMCStorageGrid emcGrid = GridUtils.getEMCStorage(this.getProxy());
                toStore = Math.min(Math.min(remainingEMC, itemEMC), emcGrid.getAvail());
                if (toStore <= 0.0) {
                    return -1.0;
                }
                emcGrid.addEMC(toStore, Actionable.MODULATE);
                Integration.emcHandler.extractEMC(stack, toStore);
                ((InternalInventory)this.getInventory()).func_70299_a(slot, stack);
            }
            if (Integration.emcHandler.getStoredEMC(stack) <= 0.0) {
                ((InternalInventory)this.getInventory()).func_70299_a(slot, this.ejectItem(stack));
                if (((InternalInventory)this.getInventory()).func_70301_a(slot) != null) {
                    return -2.0;
                }
            }
            return remainingEMC - toStore;
        }
        catch (GridAccessException e) {
            CommonUtils.debugLog("processStorage: Error accessing grid:", e);
            return -1.0;
        }
    }

    protected CondenserState processInv() {
        double remainingEMC = this.getEMCPerTick();
        for (int slot = 0; slot < 4 && remainingEMC > 0.0; ++slot) {
            ItemStack stack = ((InternalInventory)this.getInventory()).func_70301_a(slot);
            if (stack == null) continue;
            if (Integration.emcHandler.isEMCStorage(stack)) {
                remainingEMC = this.processStorage(slot, remainingEMC);
                continue;
            }
            if (Integration.emcHandler.hasEMC(stack)) {
                remainingEMC = this.processItems(slot, remainingEMC, !ItemEnum.isCrystal(stack));
                continue;
            }
            ((InternalInventory)this.getInventory()).func_70299_a(slot, this.ejectItem(stack));
            if (((InternalInventory)this.getInventory()).func_70301_a(slot) == null) continue;
            remainingEMC = -2.0;
        }
        switch ((int)remainingEMC) {
            case -1: {
                return CondenserState.NOEMCSTORAGE;
            }
            case -2: {
                return CondenserState.NOITEMSTORAGE;
            }
            case -3: {
                return CondenserState.NOPOWER;
            }
        }
        return CondenserState.ACTIVE;
    }

    protected boolean updateState(CondenserState newState) {
        if (this.state != newState) {
            this.state = newState;
            this.markForUpdate();
            return true;
        }
        return false;
    }

    protected ItemStack ejectItem(ItemStack stack) {
        return GridUtils.injectItemsForPower(this.getProxy(), stack, this.mySource);
    }

    protected class CondenserInventory
    extends InternalInventory {
        CondenserInventory() {
            super("EMCCondenserInventory", 4, 64);
        }

        @Override
        public boolean func_94041_b(int slotId, ItemStack itemStack) {
            return Integration.emcHandler.isEMCStorage(itemStack) || Integration.emcHandler.hasEMC(itemStack) && Integration.emcHandler.getSingleEnergyValue(itemStack) <= TileEMCCondenserBase.this.getEMCPerTick();
        }
    }
}

