/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.blocks.condenser.tiles;

import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.TickRateModulation;
import com.mordenkainen.equivalentenergistics.blocks.BlockEnum;
import com.mordenkainen.equivalentenergistics.blocks.condenser.BlockEMCCondenser;
import com.mordenkainen.equivalentenergistics.blocks.condenser.CondenserState;
import com.mordenkainen.equivalentenergistics.blocks.condenser.tiles.TileEMCCondenserBase;
import com.mordenkainen.equivalentenergistics.integration.ae2.grid.GridUtils;
import com.mordenkainen.equivalentenergistics.integration.waila.IWailaNBTProvider;
import com.mordenkainen.equivalentenergistics.util.inventory.InternalInventory;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEMCCondenser
extends TileEMCCondenserBase
implements IWailaNBTProvider {
    private static final String EMC_TAG = "CurrentEMC";
    protected double currentEMC;

    public TileEMCCondenser() {
        super(new ItemStack(Item.func_150898_a((Block)BlockEnum.EMCCONDENSER.getBlock())));
    }

    @Override
    public NBTTagCompound getWailaTag(NBTTagCompound tag) {
        if (this.currentEMC > 0.0) {
            tag.func_74780_a(EMC_TAG, this.currentEMC);
        }
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (data.func_74764_b(EMC_TAG)) {
            this.currentEMC = data.func_74769_h(EMC_TAG);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        if (this.currentEMC > 0.0) {
            data.func_74780_a(EMC_TAG, this.currentEMC);
        }
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLast) {
        if (this.refreshNetworkState()) {
            this.markForUpdate();
        }
        if (this.isActive()) {
            CondenserState newState = this.state;
            if (this.currentEMC > 0.0 && this.updateState(newState = this.injectExcessEMC())) {
                return TickRateModulation.IDLE;
            }
            if (((InternalInventory)this.getInventory()).isEmpty()) {
                this.updateState(CondenserState.IDLE);
            } else {
                newState = this.processInv();
                this.updateState(newState);
            }
        } else {
            this.updateState(CondenserState.IDLE);
        }
        return this.state.getTickRate();
    }

    private CondenserState injectExcessEMC() {
        this.currentEMC -= GridUtils.injectEMC(this.getProxy(), this.currentEMC, Actionable.MODULATE);
        return this.currentEMC > 0.0 ? CondenserState.NOEMCSTORAGE : this.state;
    }

    @Override
    protected double getEMCPerTick() {
        return BlockEMCCondenser.emcPerTick;
    }
}

