/*
 * Decompiled with CFR 0.152.
 */
package openeye.notes.entries;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import java.io.File;
import net.minecraft.util.IChatComponent;
import openeye.notes.NoteCategory;

public abstract class NoteEntry {
    private static final File DUMMY_FILE = new File("invalid");
    public final NoteCategory category;
    public final int level;
    public final File file;

    protected NoteEntry(File file, NoteCategory category, int level) {
        this.file = (File)Objects.firstNonNull((Object)file, (Object)DUMMY_FILE);
        this.category = category;
        this.level = level;
    }

    protected NoteEntry(NoteCategory category, int level) {
        this(DUMMY_FILE, category, level);
    }

    public abstract String url();

    public abstract IChatComponent title();

    public abstract IChatComponent content();

    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        result.addProperty("filename", this.file.getName());
        result.addProperty("path", this.file.getPath());
        result.addProperty("category", this.category.toString());
        result.addProperty("level", (Number)this.level);
        result.addProperty("title", this.title().func_150260_c());
        result.addProperty("content", this.content().func_150260_c());
        String url = this.url();
        if (!Strings.isNullOrEmpty((String)url)) {
            result.addProperty("url", url);
        }
        return result;
    }
}

