/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.animation.transformation;

import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Transformation;

public class Rotation
extends Transformation<Rotation, ITransformable.Rotate> {
    protected float fromAngle;
    protected float toAngle;
    protected float axisX;
    protected float axisY;
    protected float axisZ;
    protected float offsetX;
    protected float offsetY;
    protected float offsetZ;

    public Rotation(float angle) {
        this.to(angle);
    }

    public Rotation(float fromAngle, float toAngle) {
        this.from(fromAngle);
        this.to(toAngle);
    }

    public Rotation(float angle, float axisX, float axisY, float axisZ) {
        this.to(angle);
        this.aroundAxis(axisX, axisY, axisZ);
    }

    public Rotation(float angle, float axisX, float axisY, float axisZ, float offsetX, float offsetY, float offsetZ) {
        this.to(angle);
        this.aroundAxis(axisX, axisY, axisZ);
        this.offset(offsetX, offsetY, offsetZ);
    }

    public Rotation from(float angle) {
        this.fromAngle = angle;
        return this;
    }

    public Rotation to(float angle) {
        this.toAngle = angle;
        return this;
    }

    public Rotation aroundAxis(float x, float y, float z) {
        this.axisX = x;
        this.axisY = y;
        this.axisZ = z;
        return this;
    }

    public Rotation offset(float x, float y, float z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
        return this;
    }

    @Override
    protected void doTransform(ITransformable.Rotate transformable, float comp) {
        float from = this.reversed ? this.toAngle : this.fromAngle;
        float to = this.reversed ? this.fromAngle : this.toAngle;
        transformable.rotate(from + (to - from) * comp, this.axisX, this.axisY, this.axisZ, this.offsetX, this.offsetY, this.offsetZ);
    }
}

