/*
 * Decompiled with CFR 0.152.
 */
package exter.fodc.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.google.common.collect.ImmutableList;
import exter.fodc.gui.GuiOreConverter;
import exter.fodc.registry.OreNameRegistry;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class ODCRecipeHandler
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return "Ore Converter";
    }

    public String getGuiTexture() {
        return "fodc:textures/gui/oc_gui.png";
    }

    public void loadAllRecipes() {
        ArrayList items = new ArrayList();
        for (String name : OreNameRegistry.GetOreNames()) {
            items.addAll(OreDictionary.getOres((String)name));
        }
        for (ItemStack stack : items) {
            CachedODCUsageRecipe recipe = new CachedODCUsageRecipe(stack);
            if (recipe.input == null) continue;
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(String outputId, Object ... results) {
        if (outputId.equals("fodc.converter")) {
            this.loadAllRecipes();
        }
        if (outputId.equals("item")) {
            CachedODCUsageRecipe recipe = new CachedODCUsageRecipe((ItemStack)results[0]);
            if (recipe.input != null) {
                this.arecipes.add(recipe);
            }
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("fodc.converter")) {
            this.loadAllRecipes();
        }
        if (outputId.equals("item")) {
            CachedODCRecipe recipe = new CachedODCRecipe((ItemStack)results[0]);
            if (recipe.output != null) {
                this.arecipes.add(recipe);
            }
        }
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(62, 33, 25, 15), "fodc.converter", new Object[0]));
    }

    public List<Class<? extends GuiContainer>> getRecipeTransferRectGuis() {
        return ImmutableList.of(GuiOreConverter.class);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)86);
    }

    public class CachedODCUsageRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        List<PositionedStack> output;

        public CachedODCUsageRecipe(ItemStack in) {
            super((TemplateRecipeHandler)ODCRecipeHandler.this);
            in = in.func_77946_l();
            in.field_77994_a = 1;
            this.input = new PositionedStack((Object)in, 7, 14);
            ArrayList<ItemStack> results = new ArrayList<ItemStack>();
            Set<String> names = OreNameRegistry.FindAllOreNames(in);
            if (names.isEmpty()) {
                this.input = null;
                return;
            }
            block0: for (String n : names) {
                for (ItemStack stack : OreDictionary.getOres((String)n)) {
                    if (!names.containsAll(OreNameRegistry.FindAllOreNames(stack))) continue;
                    int j = results.size();
                    ItemStack res = stack.func_77946_l();
                    res.field_77994_a = 1;
                    results.add(res);
                    if (j != 15) continue;
                    break block0;
                }
            }
            this.output = new ArrayList<PositionedStack>();
            for (int i = 0; i < results.size() && i != 16; ++i) {
                ItemStack res = (ItemStack)results.get(i);
                this.output.add(new PositionedStack((Object)res, 18 * (i % 4) + 94 - 5, 18 * (i / 4) + 16 - 11));
            }
        }

        public PositionedStack getIngredient() {
            return this.input;
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.output;
        }
    }

    public class CachedODCRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        PositionedStack output;

        public CachedODCRecipe(ItemStack out) {
            super((TemplateRecipeHandler)ODCRecipeHandler.this);
            out = out.func_77946_l();
            out.field_77994_a = 1;
            this.output = new PositionedStack((Object)out, 89, 5);
            Set<String> names = OreNameRegistry.FindAllOreNames(out);
            if (names.isEmpty()) {
                this.output = null;
                return;
            }
            ArrayList<ItemStack> results = new ArrayList<ItemStack>();
            for (String n : names) {
                for (ItemStack stack : OreDictionary.getOres((String)n)) {
                    if (!names.containsAll(OreNameRegistry.FindAllOreNames(stack))) continue;
                    ItemStack res = stack.func_77946_l();
                    res.field_77994_a = 1;
                    results.add(res);
                }
            }
            this.input = new PositionedStack(results, 7, 14);
        }

        public PositionedStack getIngredient() {
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

