/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.util.Config;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModItemDisplay
extends SocketModule {
    public ModItemDisplay(int id) {
        super(id, "eng_toolbox:itemDisplay", "eng_toolbox:itemDisplayStack");
    }

    @Override
    public String getLocalizedName() {
        return "Inventory Interface";
    }

    public void getToolTip(List l) {
        l.add("Displays and allows for manual");
        l.add("interaction with an internal");
        l.add("inventory");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_GREEN() + "Inventory to display");
        l.add(Config.PREF_WHITE() + "Toggle stack mode");
    }

    @Override
    public void addRecipe() {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(emasher.items.Items.module(), 1, this.moduleID), new Object[]{"ggg", "slr", " b ", Character.valueOf('g'), Blocks.field_150410_aZ, Character.valueOf('s'), Items.field_151114_aO, Character.valueOf('l'), "dyeLime", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('b'), emasher.items.Items.blankSide()}));
    }

    @Override
    public boolean hasInventoryIndicator() {
        return true;
    }

    @Override
    public int getCurrentTexture(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        if (config.meta == 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public void onGenericRemoteSignal(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        config.meta = config.meta == 0 ? 1 : 0;
        ts.sendClientSideState(side.ordinal());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getTextToRender(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        if (config.inventory == -1) {
            return null;
        }
        if (ts.getStackInInventorySlot(config.inventory) != null) {
            return ts.getStackInInventorySlot((int)config.inventory).field_77994_a + "";
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack getItemToRender(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        if (config.inventory != -1) {
            return ts.getStackInInventorySlot(config.inventory);
        }
        return null;
    }

    @Override
    public void onInventoryChange(SideConfig config, int index, SocketTileAccess ts, ForgeDirection side, boolean add) {
        if (index == config.inventory) {
            ts.sendClientInventorySlot(index);
        }
    }

    @Override
    public void onSideActivated(SocketTileAccess ts, SideConfig config, ForgeDirection side, EntityPlayer player) {
        ItemStack is = player.func_71045_bC();
        int added = 0;
        boolean flag = false;
        if (config.inventory != -1) {
            ItemStack stack;
            if (is != null) {
                added = ts.addItemInternal(is, true, config.inventory);
                is.field_77994_a -= added;
            }
            if ((stack = ts.getStackInInventorySlot(config.inventory)) != null && is != null) {
                flag = !stack.func_77969_a(is);
            } else {
                boolean bl = flag = stack != null;
            }
            if (added == 0 && stack != null && flag) {
                int xo = ts.field_145851_c + side.offsetX;
                int yo = ts.field_145848_d + side.offsetY;
                int zo = ts.field_145849_e + side.offsetZ;
                int dropped = 0;
                dropped = config.meta == 1 ? Math.min(stack.field_77994_a, stack.func_77976_d()) : 1;
                ItemStack dropStack = stack.func_77946_l();
                dropStack.field_77994_a = dropped;
                this.dropItemsOnSide(ts, config, side, xo, yo, zo, dropStack);
                ts.extractItemInternal(true, config.inventory, dropped);
            }
            ts.sendClientInventorySlot(config.inventory);
        }
    }

    public void dropItemsOnSide(SocketTileAccess ts, SideConfig config, ForgeDirection side, int xo, int yo, int zo, ItemStack stack) {
        if (!ts.func_145831_w().field_72995_K) {
            float f = 0.7f;
            double d0 = (double)(ts.func_145831_w().field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(ts.func_145831_w().field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(ts.func_145831_w().field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(ts.func_145831_w(), (double)xo + d0, (double)yo + d1, (double)zo + d2, stack);
            entityitem.field_145804_b = 1;
            ts.func_145831_w().func_72838_d((Entity)entityitem);
        }
    }

    @Override
    public void indicatorUpdated(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        if (config.inventory != -1) {
            ts.sendClientInventorySlot(config.inventory);
        }
    }

    @Override
    public void updateSide(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        if (config.inventory != -1) {
            ++config.tank;
            if (config.tank >= 60) {
                config.tank = 0;
                ts.sendClientInventorySlot(config.inventory);
            }
        }
    }
}

