/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.fluids.Fluids;
import emasher.tileentities.TileShaleResource;
import emasher.util.Config;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModFracker
extends SocketModule {
    public ModFracker(int id) {
        super(id, "eng_toolbox:fracker");
    }

    @Override
    public String getLocalizedName() {
        return "Fracker";
    }

    public void getToolTip(List l) {
        l.add("Inputs shale resource fluid into its output tank");
        l.add("when water or slickwater is pumped into its input tank");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_BLUE() + "Input tank");
        l.add(Config.PREF_GREEN() + "Output tank");
        l.add("Must be placed on the bottom of a socket");
        l.add("Only works if the socket is directly above");
        l.add("a shale resource block");
        l.add("Slickwater doubles the output");
    }

    @Override
    public void addRecipe() {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(emasher.items.Items.module(), 1, this.moduleID), new Object[]{"hih", "cdu", " b ", Character.valueOf('h'), Blocks.field_150438_bZ, Character.valueOf('u'), Items.field_151133_ar, Character.valueOf('i'), Items.field_151042_j, Character.valueOf('c'), emasher.items.Items.circuit(), Character.valueOf('d'), Items.field_151045_i, Character.valueOf('b'), emasher.items.Items.blankSide()}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(emasher.items.Items.module(), 1, this.moduleID), new Object[]{"hih", "cdu", " b ", Character.valueOf('h'), Blocks.field_150438_bZ, Character.valueOf('u'), Items.field_151133_ar, Character.valueOf('i'), "ingotAluminum", Character.valueOf('c'), emasher.items.Items.circuit(), Character.valueOf('d'), Items.field_151045_i, Character.valueOf('b'), emasher.items.Items.blankSide()}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(emasher.items.Items.module(), 1, this.moduleID), new Object[]{"hih", "cdu", " b ", Character.valueOf('h'), Blocks.field_150438_bZ, Character.valueOf('u'), Items.field_151133_ar, Character.valueOf('i'), "ingotTin", Character.valueOf('c'), emasher.items.Items.circuit(), Character.valueOf('d'), Items.field_151045_i, Character.valueOf('b'), emasher.items.Items.blankSide()}));
    }

    @Override
    public boolean hasTankIndicator() {
        return true;
    }

    @Override
    public boolean hasInventoryIndicator() {
        return true;
    }

    @Override
    public boolean canBeInstalled(SocketTileAccess ts, ForgeDirection side) {
        return side == ForgeDirection.DOWN;
    }

    @Override
    public void updateSide(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        ++config.meta;
        if (config.meta >= 10) {
            config.meta = 0;
            if (config.tank >= 0 && config.tank < 3 && ts.getFluidInTank(config.tank) != null) {
                this.onTankChange(config, config.tank, ts, side, true);
            }
        }
    }

    @Override
    public void onTankChange(SideConfig config, int index, SocketTileAccess ts, ForgeDirection side, boolean add) {
        if (index == config.tank && add && side == ForgeDirection.DOWN && config.inventory >= 0 && config.inventory < 3) {
            FluidStack f = ts.getFluidInTank(index);
            if (f.isFluidEqual(new FluidStack(Fluids.fluidSlickwater(), 1000)) || f.isFluidEqual(new FluidStack(FluidRegistry.WATER, 1000))) {
                TileEntity te;
                int amntToDraw;
                boolean sw = false;
                if (f.isFluidEqual(new FluidStack(Fluids.fluidSlickwater(), 1000))) {
                    amntToDraw = 1000;
                    sw = true;
                } else {
                    amntToDraw = 200;
                }
                if (ts.func_145831_w().func_147439_a(ts.field_145851_c, ts.field_145848_d - 1, ts.field_145849_e) == emasher.blocks.Blocks.shaleResource() && ts.func_145831_w().func_72805_g(ts.field_145851_c, ts.field_145848_d - 1, ts.field_145849_e) != 2 && (te = ts.func_145831_w().func_147438_o(ts.field_145851_c, ts.field_145848_d - 1, ts.field_145849_e)) != null && te instanceof TileShaleResource) {
                    TileShaleResource tsr = (TileShaleResource)te;
                    FluidStack fs = ts.getFluidInTank(index);
                    if (fs.amount >= 1000 && ts.fillInternal(config.inventory, tsr.drain(amntToDraw, false), false) == amntToDraw) {
                        FluidStack ext;
                        ts.drainInternal(index, 1000, true);
                        if (sw) {
                            ext = tsr.drain(amntToDraw, true);
                        } else {
                            ext = tsr.drain(amntToDraw * 2, true);
                            if (ext != null) {
                                ext.amount = Math.min(ext.amount, 200);
                            }
                        }
                        if (ext != null) {
                            ts.fillInternal(config.inventory, ext, true);
                        }
                    }
                }
            } else if (f.isFluidEqual(new FluidStack(FluidRegistry.LAVA, 1000))) {
                TileEntity te;
                int amntToDraw = 1000;
                if (ts.func_145831_w().func_147439_a(ts.field_145851_c, ts.field_145848_d - 1, ts.field_145849_e) == emasher.blocks.Blocks.shaleResource() && ts.func_145831_w().func_72805_g(ts.field_145851_c, ts.field_145848_d - 1, ts.field_145849_e) == 2 && (te = ts.func_145831_w().func_147438_o(ts.field_145851_c, ts.field_145848_d - 1, ts.field_145849_e)) != null && te instanceof TileShaleResource) {
                    TileShaleResource tsr = (TileShaleResource)te;
                    FluidStack fs = ts.getFluidInTank(index);
                    if (fs.amount >= 1000 && ts.fillInternal(config.inventory, tsr.drain(amntToDraw, false), false) == amntToDraw) {
                        ts.drainInternal(index, 1000, true);
                        FluidStack ext = tsr.drain(amntToDraw, true);
                        if (ext != null) {
                            ts.fillInternal(config.inventory, ext, true);
                        }
                    }
                }
            }
        }
    }
}

