/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier2;

import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.helper.ItemStackHelper;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.part.IGuiButtonSensitive;
import com.bluepowermod.part.tube.TubeStack;
import com.bluepowermod.tile.TileMachineBase;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileSortingMachine
extends TileMachineBase
implements ISidedInventory,
IGuiButtonSensitive {
    private ItemStack[] inventory = new ItemStack[40];
    public int curColumn = 0;
    public PullMode pullMode = PullMode.SINGLE_STEP;
    public SortMode sortMode = SortMode.ANYSTACK_SEQUENTIAL;
    private boolean sweepTriggered;
    private int savedPulses;
    public final IPneumaticTube.TubeColor[] colors = new IPneumaticTube.TubeColor[9];
    public int[] fuzzySettings = new int[8];
    private ItemStack nonAcceptedStack;

    public TileSortingMachine() {
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = IPneumaticTube.TubeColor.NONE;
        }
    }

    @Override
    public void func_145845_h() {
        this.nonAcceptedStack = null;
        super.func_145845_h();
        if (!this.sweepTriggered && this.savedPulses > 0) {
            --this.savedPulses;
            this.sweepTriggered = true;
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_72820_D() % 10L == 0L && (this.pullMode == PullMode.SINGLE_SWEEP && this.sweepTriggered || this.pullMode == PullMode.AUTOMATIC)) {
            this.triggerSorting();
        }
    }

    @Override
    protected void redstoneChanged(boolean newValue) {
        super.redstoneChanged(newValue);
        if (newValue) {
            if (this.pullMode == PullMode.SINGLE_STEP) {
                this.triggerSorting();
            }
            if (this.pullMode == PullMode.SINGLE_SWEEP) {
                ++this.savedPulses;
            }
        }
    }

    private void triggerSorting() {
        block8: {
            int[] accessibleSlots;
            IInventory inputInv;
            block10: {
                block9: {
                    ForgeDirection dir;
                    TileEntity inputTE;
                    if (!this.isBufferEmpty() || !((inputTE = this.getTileCache(dir = this.getOutputDirection().getOpposite())) instanceof IInventory)) break block8;
                    inputInv = (IInventory)inputTE;
                    if (inputInv instanceof ISidedInventory) {
                        accessibleSlots = ((ISidedInventory)inputInv).func_94128_d(dir.getOpposite().ordinal());
                    } else {
                        accessibleSlots = new int[inputInv.func_70302_i_()];
                        for (int i = 0; i < accessibleSlots.length; ++i) {
                            accessibleSlots[i] = i;
                        }
                    }
                    for (int slot : accessibleSlots) {
                        ItemStack stack = inputInv.func_70301_a(slot);
                        if (stack == null || !IOHelper.canExtractItemFromInventory(inputInv, stack, slot, dir.getOpposite().ordinal()) || !this.tryProcessItem(stack, false)) continue;
                        if (stack.field_77994_a == 0) {
                            inputInv.func_70299_a(slot, null);
                        }
                        return;
                    }
                    if (this.sortMode != SortMode.ANYSTACK_SEQUENTIAL) break block9;
                    for (int i = this.curColumn; i < this.inventory.length; i += 8) {
                        ItemStack extractedStack;
                        ItemStack filterStack = this.inventory[i];
                        if (filterStack == null || (extractedStack = IOHelper.extract(inputTE, dir.getOpposite(), filterStack, true, false)) == null) continue;
                        this.addItemToOutputBuffer(extractedStack.func_77946_l(), this.colors[this.curColumn]);
                        this.gotoNextNonEmptyColumn();
                        break block8;
                    }
                    break block8;
                }
                if (this.sortMode != SortMode.ALLSTACK_SEQUENTIAL) break block10;
                if (!this.matchAndProcessColumn(inputInv, accessibleSlots, this.curColumn)) break block8;
                this.gotoNextNonEmptyColumn();
                break block8;
            }
            if (this.sortMode == SortMode.RANDOM_ALLSTACKS) {
                for (int i = 0; i < 8 && !this.matchAndProcessColumn(inputInv, accessibleSlots, i); ++i) {
                }
            }
        }
    }

    private boolean matchAndProcessColumn(IInventory inputInventory, int[] accessibleSlots, int column) {
        ArrayList<ItemStack> requirements = new ArrayList<ItemStack>();
        for (int i = 0; i < 5; ++i) {
            ItemStack filterStack = this.inventory[column + 8 * i];
            if (filterStack == null) continue;
            boolean duplicate = false;
            for (ItemStack requirement : requirements) {
                if (!ItemStackHelper.areStacksEqual(requirement, filterStack, this.fuzzySettings[column])) continue;
                requirement.field_77994_a += filterStack.field_77994_a;
                duplicate = true;
                break;
            }
            if (duplicate) continue;
            requirements.add(filterStack.func_77946_l());
        }
        if (requirements.size() == 0) {
            return false;
        }
        ItemStack[] copy = new ItemStack[requirements.size()];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = ((ItemStack)requirements.get(i)).func_77946_l();
        }
        Iterator iterator = requirements.iterator();
        block3: while (iterator.hasNext()) {
            ItemStack stack = (ItemStack)iterator.next();
            for (Object slot : (Object)accessibleSlots) {
                ItemStack invStack = inputInventory.func_70301_a((int)slot);
                if (invStack == null || !ItemStackHelper.areStacksEqual(invStack, stack, this.fuzzySettings[column])) continue;
                stack.field_77994_a -= invStack.field_77994_a;
                if (stack.field_77994_a > 0) continue;
                iterator.remove();
                continue block3;
            }
        }
        if (requirements.isEmpty()) {
            for (ItemStack stack : copy) {
                for (int slot : accessibleSlots) {
                    ItemStack invStack;
                    if (stack.field_77994_a <= 0 || (invStack = inputInventory.func_70301_a(slot)) == null || !ItemStackHelper.areStacksEqual(invStack, stack, this.fuzzySettings[column])) continue;
                    int substracted = Math.min(stack.field_77994_a, invStack.field_77994_a);
                    stack.field_77994_a -= substracted;
                    invStack.field_77994_a -= substracted;
                    if (invStack.field_77994_a <= 0) {
                        inputInventory.func_70299_a(slot, null);
                    }
                    ItemStack bufferStack = invStack.func_77946_l();
                    bufferStack.field_77994_a = substracted;
                    this.addItemToOutputBuffer(bufferStack, this.colors[column]);
                }
            }
            inputInventory.func_70296_d();
            return true;
        }
        return false;
    }

    private boolean tryProcessItem(ItemStack stack, boolean simulate) {
        switch (this.sortMode) {
            case ANYSTACK_SEQUENTIAL: {
                break;
            }
            case ALLSTACK_SEQUENTIAL: {
                break;
            }
            case RANDOM_ALLSTACKS: {
                break;
            }
            case ANY_ITEM: 
            case ANY_ITEM_DEFAULT: {
                for (int i = 0; i < this.inventory.length; ++i) {
                    ItemStack filter = this.inventory[i];
                    if (filter == null || !ItemStackHelper.areStacksEqual(filter, stack, this.fuzzySettings[i % 8]) || stack.field_77994_a < filter.field_77994_a) continue;
                    if (!simulate) {
                        this.addItemToOutputBuffer(filter.func_77946_l(), this.colors[i % 8]);
                    }
                    stack.field_77994_a -= filter.field_77994_a;
                    return true;
                }
                if (this.sortMode != SortMode.ANY_ITEM_DEFAULT) break;
                if (!simulate) {
                    this.addItemToOutputBuffer(stack.func_77946_l(), this.colors[8]);
                }
                stack.field_77994_a = 0;
                return true;
            }
            case ANY_STACK: 
            case ANY_STACK_DEFAULT: {
                for (int i = 0; i < this.inventory.length; ++i) {
                    ItemStack filter = this.inventory[i];
                    if (filter == null || !ItemStackHelper.areStacksEqual(filter, stack, this.fuzzySettings[i % 8])) continue;
                    if (!simulate) {
                        this.addItemToOutputBuffer(stack.func_77946_l(), this.colors[i % 8]);
                    }
                    stack.field_77994_a = 0;
                    return true;
                }
                if (this.sortMode != SortMode.ANY_STACK_DEFAULT) break;
                if (!simulate) {
                    this.addItemToOutputBuffer(stack.func_77946_l(), this.colors[8]);
                }
                stack.field_77994_a = 0;
                return true;
            }
        }
        return false;
    }

    private void gotoNextNonEmptyColumn() {
        int oldColumn = this.curColumn++;
        if (this.curColumn > 7) {
            this.curColumn = 0;
            this.sweepTriggered = false;
        }
        while (oldColumn != this.curColumn) {
            for (int i = this.curColumn; i < this.inventory.length; i += 8) {
                if (this.inventory[i] == null) continue;
                return;
            }
            if (++this.curColumn <= 7) continue;
            this.curColumn = 0;
            this.sweepTriggered = false;
        }
        this.curColumn = 0;
    }

    @Override
    public void onButtonPress(EntityPlayer player, int messageId, int value) {
        if (messageId < 0) {
            return;
        }
        if (messageId < 9) {
            this.colors[messageId] = IPneumaticTube.TubeColor.values()[value];
        } else if (messageId == 9) {
            this.pullMode = PullMode.values()[value];
        } else if (messageId == 10) {
            this.sortMode = SortMode.values()[value];
        } else {
            this.fuzzySettings[messageId - 11] = value;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74774_a("pullMode", (byte)this.pullMode.ordinal());
        tag.func_74774_a("sortMode", (byte)this.sortMode.ordinal());
        tag.func_74768_a("savedPulses", this.savedPulses);
        int[] colorArray = new int[this.colors.length];
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray[i] = this.colors[i].ordinal();
        }
        tag.func_74783_a("colors", colorArray);
        tag.func_74783_a("fuzzySettings", this.fuzzySettings);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("Items", (NBTBase)tagList);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.pullMode = PullMode.values()[tag.func_74771_c("pullMode")];
        this.sortMode = SortMode.values()[tag.func_74771_c("sortMode")];
        this.savedPulses = tag.func_74762_e("savedPulses");
        int[] colorArray = tag.func_74759_k("colors");
        for (int i = 0; i < colorArray.length; ++i) {
            this.colors[i] = IPneumaticTube.TubeColor.values()[colorArray[i]];
        }
        if (tag.func_74764_b("fuzzySettings")) {
            this.fuzzySettings = tag.func_74759_k("fuzzySettings");
        }
        NBTTagList tagList = tag.func_150295_c("Items", 10);
        this.inventory = new ItemStack[40];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
    }

    public int func_70302_i_() {
        return this.inventory.length + 1;
    }

    public ItemStack func_70301_a(int slot) {
        return slot < this.inventory.length ? this.inventory[slot] : null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            this.func_70299_a(slot, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        if (slot < this.inventory.length) {
            this.inventory[slot] = itemStack;
            if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
                itemStack.field_77994_a = this.func_70297_j_();
            }
        } else if (itemStack != null) {
            this.tryProcessItem(itemStack, false);
        }
    }

    @Override
    public TubeStack acceptItemFromTube(TubeStack stack, ForgeDirection from, boolean simulate) {
        boolean success;
        if (from == this.getOutputDirection()) {
            return super.acceptItemFromTube(stack, from, simulate);
        }
        if (!this.isBufferEmpty() && !this.ejectionScheduled) {
            return stack;
        }
        boolean bl = success = !ItemStack.func_77989_b((ItemStack)stack.stack, (ItemStack)this.nonAcceptedStack) && this.tryProcessItem(stack.stack, simulate);
        if (success) {
            this.nonAcceptedStack = stack.stack;
            if (stack.stack.field_77994_a <= 0) {
                return null;
            }
            return stack;
        }
        return stack;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return var1 < this.inventory.length ? true : this.isBufferEmpty() && var2 != null && this.tryProcessItem(var2, true);
    }

    public int[] func_94128_d(int var1) {
        return new int[]{this.inventory.length};
    }

    public boolean func_102007_a(int var1, ItemStack var2, int var3) {
        return this.getOutputDirection().getOpposite().ordinal() == var3 && this.func_94041_b(var1, var2);
    }

    public boolean func_102008_b(int var1, ItemStack var2, int var3) {
        return false;
    }

    public String func_145825_b() {
        return BPBlocks.sorting_machine.func_149739_a();
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    public static enum SortMode {
        ANYSTACK_SEQUENTIAL("any_stack_sequential"),
        ALLSTACK_SEQUENTIAL("all_stacks_sequential"),
        RANDOM_ALLSTACKS("all_stacks_random"),
        ANY_ITEM("any_item"),
        ANY_ITEM_DEFAULT("any_item_default"),
        ANY_STACK("any_stack"),
        ANY_STACK_DEFAULT("any_stack_default");

        private final String name;

        private SortMode(String name) {
            this.name = name;
        }

        public String toString() {
            return "gui.bluepower:sortingMachine.sortMode." + this.name;
        }
    }

    public static enum PullMode {
        SINGLE_STEP("single_step"),
        AUTOMATIC("automatic"),
        SINGLE_SWEEP("single_sweep");

        private final String name;

        private PullMode(String name) {
            this.name = name;
        }

        public String toString() {
            return "gui.bluepower:sortingMachine.pullMode." + this.name;
        }
    }
}

