/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.redstone;

import com.bluepowermod.api.connect.ConnectionType;
import com.bluepowermod.api.connect.IConnection;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import net.minecraftforge.common.util.ForgeDirection;

public class RedstoneConnection
implements IConnection<IRedstoneDevice> {
    private IRedstoneDevice a;
    private IRedstoneDevice b;
    private ForgeDirection sideA;
    private ForgeDirection sideB;
    private ConnectionType type;
    private IConnection<IRedstoneDevice> complementary;

    public RedstoneConnection(IRedstoneDevice a, IRedstoneDevice b, ForgeDirection sideA, ForgeDirection sideB, ConnectionType type) {
        this.a = a;
        this.b = b;
        this.sideA = sideA;
        this.sideB = sideB;
        this.type = type;
    }

    public RedstoneConnection(IRedstoneDevice a, IRedstoneDevice b, ForgeDirection sideA, ForgeDirection sideB, ConnectionType type, IConnection<IRedstoneDevice> complementary) {
        this(a, b, sideA, sideB, type);
        this.complementary = complementary;
    }

    @Override
    public IRedstoneDevice getA() {
        return this.a;
    }

    @Override
    public IRedstoneDevice getB() {
        return this.b;
    }

    @Override
    public ForgeDirection getSideA() {
        return this.sideA;
    }

    @Override
    public ForgeDirection getSideB() {
        return this.sideB;
    }

    @Override
    public ConnectionType getType() {
        return this.type;
    }

    @Override
    public IConnection<IRedstoneDevice> getComplementaryConnection() {
        RedstoneConnection c;
        if (this.complementary != null) {
            return this.complementary;
        }
        this.complementary = c = new RedstoneConnection(this.getB(), this.getA(), this.getSideB(), this.getSideA(), this.getType());
        c.complementary = this;
        return c;
    }

    @Override
    public void setComplementaryConnection(IConnection<IRedstoneDevice> con) {
        this.complementary = con;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedstoneConnection)) {
            return false;
        }
        RedstoneConnection c = (RedstoneConnection)obj;
        return this.getA().equals(c.getA()) && this.getB().equals(c.getB()) && this.getSideA() == c.getSideA() && this.getSideB() == c.getSideB() && this.getType() == c.getType();
    }
}

