/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.digital;

import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.client.gui.gate.GuiGateCounter;
import com.bluepowermod.part.IGuiButtonSensitive;
import com.bluepowermod.part.gate.component.GateComponentBorder;
import com.bluepowermod.part.gate.component.GateComponentBorderDark;
import com.bluepowermod.part.gate.component.GateComponentPointer;
import com.bluepowermod.part.gate.component.GateComponentTorch;
import com.bluepowermod.part.gate.component.GateComponentWire;
import com.bluepowermod.part.gate.connection.GateConnectionBase;
import com.bluepowermod.part.gate.connection.GateConnectionDigital;
import com.bluepowermod.part.gate.digital.GateSimpleDigital;
import com.bluepowermod.util.Color;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class GateCounter
extends GateSimpleDigital
implements IGuiButtonSensitive {
    private int count = 0;
    private int max = 10;
    private int increment = 1;
    private int decrement = 1;
    private boolean wasOnLeft = false;
    private boolean wasOnRight = false;
    private GateComponentTorch t1;
    private GateComponentTorch t2;
    private GateComponentPointer p;

    @Override
    public void initializeConnections() {
        ((GateConnectionDigital)this.front()).enable().setOutputOnly();
        ((GateConnectionDigital)this.left()).enable();
        ((GateConnectionDigital)this.back()).enable().setOutputOnly();
        ((GateConnectionDigital)this.right()).enable();
    }

    @Override
    public void initComponents() {
        this.t1 = new GateComponentTorch(this, 255, 0.25, true).setState(false);
        this.addComponent(this.t1);
        this.t2 = new GateComponentTorch(this, 49407, 0.25, true).setState(true);
        this.addComponent(this.t2);
        this.p = new GateComponentPointer(this, 11673809, 0.4375, true).setAngle(-0.6075);
        this.addComponent(this.p.setState(true));
        this.addComponent(new GateComponentWire(this, 0xFFF600, RedwireType.BLUESTONE).bind((GateConnectionBase)this.right()));
        this.addComponent(new GateComponentWire(this, 0xFF0000, RedwireType.BLUESTONE).bind((GateConnectionBase)this.left()));
        this.addComponent(new GateComponentBorder(this, 0x7D7D7D));
        this.addComponent(new GateComponentBorderDark(this, 0x4D4D4D));
    }

    @Override
    public String getGateType() {
        return "counter";
    }

    @Override
    public void doLogic() {
        if (((GateConnectionDigital)this.left()).getInput() && !this.wasOnLeft) {
            this.wasOnLeft = true;
            this.count -= this.decrement;
            this.playTickSound();
        }
        if (!((GateConnectionDigital)this.left()).getInput()) {
            this.wasOnLeft = false;
        }
        if (((GateConnectionDigital)this.right()).getInput() && !this.wasOnRight) {
            this.wasOnRight = true;
            this.count += this.increment;
            this.playTickSound();
        }
        if (!((GateConnectionDigital)this.right()).getInput()) {
            this.wasOnRight = false;
        }
        this.count = Math.max(Math.min(this.count, this.max), 0);
        this.increment = Math.max(Math.min(this.increment, this.max), 0);
        this.decrement = Math.max(Math.min(this.decrement, this.max), 0);
        double min = 0.1075;
        double max = 0.3925;
        double tot = max - min;
        ((GateConnectionDigital)this.front()).setOutput(this.count == this.max);
        ((GateConnectionDigital)this.back()).setOutput(this.count == 0);
        this.t1.setState(this.count == this.max);
        this.t2.setState(this.count == 0);
        this.p.setAngle(max - tot * ((double)this.count / (double)this.max));
    }

    @Override
    public void tick() {
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("count", this.count);
        tag.func_74768_a("decrement", this.decrement);
        tag.func_74768_a("increment", this.increment);
        tag.func_74768_a("max", this.max);
        tag.func_74757_a("wasOnLeft", this.wasOnLeft);
        tag.func_74757_a("wasOnRight", this.wasOnRight);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.count = tag.func_74762_e("count");
        this.decrement = tag.func_74762_e("decrement");
        this.increment = tag.func_74762_e("increment");
        this.max = tag.func_74762_e("max");
        this.wasOnLeft = tag.func_74767_n("wasOnLeft");
        this.wasOnRight = tag.func_74767_n("wasOnRight");
    }

    @Override
    public void writeUpdateData(DataOutput buffer) throws IOException {
        super.writeUpdateData(buffer);
        buffer.writeInt(this.count);
        buffer.writeInt(this.decrement);
        buffer.writeInt(this.increment);
        buffer.writeInt(this.max);
        buffer.writeBoolean(this.wasOnLeft);
        buffer.writeBoolean(this.wasOnRight);
    }

    @Override
    public void readUpdateData(DataInput buffer) throws IOException {
        super.readUpdateData(buffer);
        this.count = buffer.readInt();
        this.decrement = buffer.readInt();
        this.increment = buffer.readInt();
        this.max = buffer.readInt();
        this.wasOnLeft = buffer.readBoolean();
        this.wasOnRight = buffer.readBoolean();
    }

    @Override
    public void onButtonPress(EntityPlayer player, int messageId, int value) {
        System.out.println("Hey!");
        switch (messageId) {
            case 0: {
                this.max = value;
                break;
            }
            case 1: {
                this.increment = value;
                break;
            }
            case 2: {
                this.decrement = value;
            }
        }
        this.count = Math.max(Math.min(this.count, this.max), 0);
        this.increment = Math.max(Math.min(this.increment, this.max), 0);
        this.decrement = Math.max(Math.min(this.decrement, this.max), 0);
        this.sendUpdatePacket();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected GuiScreen getGui(EntityPlayer player) {
        return new GuiGateCounter(this){

            @Override
            protected int getCurrentMax() {
                return GateCounter.this.max;
            }

            @Override
            protected int getCurrentIncrement() {
                return GateCounter.this.increment;
            }

            @Override
            protected int getCurrentDecrement() {
                return GateCounter.this.decrement;
            }
        };
    }

    @Override
    protected boolean hasGUI() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addWAILABody(List<String> info) {
        info.add(I18n.func_135052_a((String)"gui.bluepower:counter.max", (Object[])new Object[0]) + ": " + (Object)((Object)Color.YELLOW) + this.max);
        info.add(I18n.func_135052_a((String)"gui.bluepower:counter.count", (Object[])new Object[0]) + ": " + (Object)((Object)Color.YELLOW) + this.count);
        info.add(I18n.func_135052_a((String)"gui.bluepower:counter.increment", (Object[])new Object[0]) + ": " + (Object)((Object)Color.WHITE) + this.increment);
        info.add(I18n.func_135052_a((String)"gui.bluepower:counter.decrement", (Object[])new Object[0]) + ": " + (Object)((Object)Color.WHITE) + this.decrement);
    }
}

