/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.component;

import com.bluepowermod.client.render.RenderHelper;
import com.bluepowermod.part.gate.GateBase;
import com.bluepowermod.part.gate.component.GateComponentTorch;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import uk.co.qmunity.lib.vec.Vec3d;

public class GateComponentPointer
extends GateComponentTorch {
    private double angle = 0.0;
    private double increment = 0.0;
    private boolean sync = true;

    public GateComponentPointer(GateBase<?, ?, ?, ?, ?, ?> gate, int color, double height, boolean digital) {
        super(gate, color, height, digital);
    }

    public GateComponentPointer(GateBase<?, ?, ?, ?, ?, ?> gate, double x, double z, double height, boolean digital) {
        super(gate, x, z, height, digital);
    }

    @Override
    public void renderDynamic(Vec3d translation, double delta, int pass) {
        RenderHelper.renderPointer(1.0 - this.x - 0.5625, this.height - 0.125, 1.0 - (this.z + 0.0625) - 0.5, this.angle + (this.getState() ? delta * this.increment : 0.0));
    }

    public GateComponentPointer setAngle(double angle) {
        if (this.angle != angle) {
            this.setNeedsSyncing(this.shouldSync());
        }
        this.angle = angle;
        return this;
    }

    public GateComponentPointer setIncrement(double increment) {
        if (this.increment != increment) {
            this.setNeedsSyncing(this.shouldSync());
        }
        this.increment = increment;
        return this;
    }

    public double getAngle() {
        return this.angle;
    }

    public double getIncrement() {
        return this.increment;
    }

    public GateComponentPointer setShouldSync(boolean sync) {
        this.sync = sync;
        return this;
    }

    public boolean shouldSync() {
        return this.sync;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getState()) {
            this.angle += this.increment;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74780_a("angle", this.angle);
        tag.func_74780_a("increment", this.increment);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.angle = tag.func_74769_h("angle");
        this.increment = tag.func_74769_h("increment");
    }

    @Override
    public void writeData(DataOutput buffer) throws IOException {
        super.writeData(buffer);
        if (this.shouldSync()) {
            buffer.writeDouble(this.angle);
            buffer.writeDouble(this.increment);
        }
    }

    @Override
    public void readData(DataInput buffer) throws IOException {
        super.readData(buffer);
        if (this.shouldSync()) {
            this.angle = buffer.readDouble();
            this.increment = buffer.readDouble();
        }
    }
}

