/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate;

import com.bluepowermod.BluePower;
import com.bluepowermod.api.block.IAdvancedSilkyRemovable;
import com.bluepowermod.api.block.ISilkyRemovable;
import com.bluepowermod.api.connect.ConnectionType;
import com.bluepowermod.api.connect.IConnection;
import com.bluepowermod.api.connect.IConnectionListener;
import com.bluepowermod.api.gate.IGate;
import com.bluepowermod.api.gate.IGateComponent;
import com.bluepowermod.api.gate.IGateLogic;
import com.bluepowermod.api.gate.IIntegratedCircuitPart;
import com.bluepowermod.api.misc.IScrewdriver;
import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.wire.redstone.IBundledDevice;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import com.bluepowermod.helper.VectorHelper;
import com.bluepowermod.init.BPCreativeTabs;
import com.bluepowermod.init.Config;
import com.bluepowermod.part.BPPart;
import com.bluepowermod.part.BPPartFaceRotate;
import com.bluepowermod.part.PartManager;
import com.bluepowermod.part.gate.connection.GateConnectionBase;
import com.bluepowermod.redstone.BundledConnectionCache;
import com.bluepowermod.redstone.RedstoneApi;
import com.bluepowermod.redstone.RedstoneConnectionCache;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import uk.co.qmunity.lib.client.render.RenderHelper;
import uk.co.qmunity.lib.helper.MathHelper;
import uk.co.qmunity.lib.part.IPartRedstone;
import uk.co.qmunity.lib.part.IPartRenderPlacement;
import uk.co.qmunity.lib.part.IPartTicking;
import uk.co.qmunity.lib.raytrace.QMovingObjectPosition;
import uk.co.qmunity.lib.texture.Layout;
import uk.co.qmunity.lib.transform.Rotation;
import uk.co.qmunity.lib.transform.Transformation;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

public abstract class GateBase<C_BOTTOM extends GateConnectionBase, C_TOP extends GateConnectionBase, C_LEFT extends GateConnectionBase, C_RIGHT extends GateConnectionBase, C_FRONT extends GateConnectionBase, C_BACK extends GateConnectionBase>
extends BPPartFaceRotate
implements IGate<C_BOTTOM, C_TOP, C_LEFT, C_RIGHT, C_FRONT, C_BACK>,
IPartRedstone,
IConnectionListener,
IRedstoneDevice,
IBundledDevice,
IPartTicking,
IPartRenderPlacement,
IIntegratedCircuitPart {
    private static Vec3dCube BOX = new Vec3dCube(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    private List<IGateComponent> components = new ArrayList<IGateComponent>();
    private C_BOTTOM connectionBottom = null;
    private C_TOP connectionTop = null;
    private C_LEFT connectionLeft = null;
    private C_RIGHT connectionRight = null;
    private C_FRONT connectionFront = null;
    private C_BACK connectionBack = null;
    private Layout layout = null;
    private RedstoneConnectionCache redstoneConnections = RedstoneApi.getInstance().createRedstoneConnectionCache(this);
    private BundledConnectionCache bundledConnections = RedstoneApi.getInstance().createBundledConnectionCache(this);
    @SideOnly(value=Side.CLIENT)
    private static IIcon icon;
    @SideOnly(value=Side.CLIENT)
    private static IIcon iconSide;
    @SideOnly(value=Side.CLIENT)
    private static IIcon iconDark;

    protected abstract String getGateType();

    protected abstract void initConnections();

    protected abstract void initComponents();

    public GateBase() {
        BundledConnectionCache c2;
        if (this.getLayout() == null) {
            this.loadLayout();
        }
        this.initConnections();
        this.initComponents();
        RedstoneConnectionCache c1 = this.getRedstoneConnectionCache();
        if (c1 != null) {
            c1.listen();
        }
        if ((c2 = this.getBundledConnectionCache()) != null) {
            c2.listen();
        }
    }

    public String getType() {
        return this.getGateType();
    }

    @Override
    public String getUnlocalizedName() {
        return "gate." + this.getGateType();
    }

    public List<IGateComponent> getComponents() {
        return this.components;
    }

    @Override
    public void addComponent(IGateComponent component) {
        if (component == null) {
            return;
        }
        if (this.components.contains(component)) {
            return;
        }
        this.components.add(component);
    }

    @Override
    public C_BOTTOM bottom() {
        return this.connectionBottom;
    }

    @Override
    public C_TOP top() {
        return this.connectionTop;
    }

    @Override
    public C_LEFT left() {
        return this.connectionLeft;
    }

    @Override
    public C_RIGHT right() {
        return this.connectionRight;
    }

    @Override
    public C_FRONT front() {
        return this.connectionFront;
    }

    @Override
    public C_BACK back() {
        return this.connectionBack;
    }

    public C_BOTTOM bottom(C_BOTTOM connection) {
        this.connectionBottom = connection;
        return this.connectionBottom;
    }

    public C_TOP top(C_TOP connection) {
        this.connectionTop = connection;
        return this.connectionTop;
    }

    public C_LEFT left(C_LEFT connection) {
        this.connectionLeft = connection;
        return this.connectionLeft;
    }

    public C_RIGHT right(C_RIGHT connection) {
        this.connectionRight = connection;
        return this.connectionRight;
    }

    public C_FRONT front(C_FRONT connection) {
        this.connectionFront = connection;
        return this.connectionFront;
    }

    public C_BACK back(C_BACK connection) {
        this.connectionBack = connection;
        return this.connectionBack;
    }

    public GateConnectionBase[] getConnections() {
        GateConnectionBase[] connections = new GateConnectionBase[]{this.bottom(), this.top(), this.left(), this.right(), this.front(), this.back()};
        return connections;
    }

    @Override
    public abstract IGateLogic<? extends GateBase<C_BOTTOM, C_TOP, C_LEFT, C_RIGHT, C_FRONT, C_BACK>> logic();

    public Layout getLayout() {
        BPPart part = this;
        try {
            part = PartManager.getExample(this.getType());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (part == this) {
            return this.layout;
        }
        return part.layout;
    }

    public boolean isCraftableInCircuitTable() {
        return true;
    }

    public boolean canBePlacedOnIC() {
        return true;
    }

    @Override
    public CreativeTabs getCreativeTab() {
        return BPCreativeTabs.circuits;
    }

    public final void update() {
        if (this.getLayout() == null && !this.getWorld().field_72995_K) {
            this.loadLayout();
        }
        this.logic().tick();
        for (IGateComponent c : this.getComponents()) {
            c.tick();
        }
        if (!this.getWorld().field_72995_K) {
            for (GateConnectionBase c : this.getConnections()) {
                if (c == null) continue;
                c.notifyUpdateIfNeeded();
            }
            this.sendUpdateIfNeeded();
        }
    }

    @Override
    public void onUpdate() {
        if (this.getLayout() == null && !this.getWorld().field_72995_K) {
            this.loadLayout();
        }
        if (RedstoneApi.getInstance().shouldWiresHandleUpdates()) {
            this.getRedstoneConnectionCache().recalculateConnections();
            this.getBundledConnectionCache().recalculateConnections();
            for (GateConnectionBase c : this.getConnections()) {
                if (c == null) continue;
                c.refresh();
            }
            for (GateConnectionBase c : this.getConnections()) {
                if (c == null || this.getRedstoneConnectionCache().getConnectionOnSide(c.getForgeDirection()) == null) continue;
                RedstoneApi.getInstance().getRedstonePropagator(this, c.getForgeDirection()).propagate();
            }
        }
        this.logic().doLogic();
        this.sendUpdateIfNeeded();
    }

    private void doLogicStuff() {
        if (this.getLayout() == null && !this.getWorld().field_72995_K) {
            this.loadLayout();
        }
        this.logic().doLogic();
        this.sendUpdateIfNeeded();
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        if (!RedstoneApi.getInstance().shouldWiresHandleUpdates()) {
            return;
        }
        super.onRemoved();
        if (this.getWorld().field_72995_K) {
            return;
        }
        this.redstoneConnections.disconnectAll();
        this.bundledConnections.disconnectAll();
    }

    private void sendUpdateIfNeeded() {
        if (this.getLayout() == null && !this.getWorld().field_72995_K) {
            this.loadLayout();
        }
        boolean send = false;
        for (IGateComponent c : this.getComponents()) {
            if (!c.needsSyncing()) continue;
            send = true;
            break;
        }
        if (!send) {
            for (GateConnectionBase c : this.getConnections()) {
                if (c == null || !c.needsSyncing()) continue;
                send = true;
                break;
            }
        }
        if (send) {
            this.sendUpdatePacket();
        }
    }

    @Override
    public boolean onActivated(EntityPlayer player, QMovingObjectPosition mop, ItemStack item) {
        if (this.getLayout() == null && !this.getWorld().field_72995_K) {
            this.loadLayout();
        }
        if (item != null && item.func_77973_b() instanceof IScrewdriver) {
            if (player.func_70093_af()) {
                if (this.logic().changeMode()) {
                    if (!this.getWorld().field_72995_K) {
                        ((IScrewdriver)item.func_77973_b()).damage(item, 1, player, false);
                        this.getRedstoneConnectionCache().recalculateConnections();
                        this.getBundledConnectionCache().recalculateConnections();
                        for (GateConnectionBase c : this.getConnections()) {
                            if (c == null) continue;
                            c.notifyUpdate();
                        }
                        this.sendUpdateIfNeeded();
                    }
                    return true;
                }
                return false;
            }
            this.setRotation((this.getRotation() + 1) % 4);
            ((IScrewdriver)item.func_77973_b()).damage(item, 1, player, false);
            this.getRedstoneConnectionCache().recalculateConnections();
            this.getBundledConnectionCache().recalculateConnections();
            for (GateConnectionBase c : this.getConnections()) {
                if (c == null) continue;
                c.notifyUpdate();
            }
            this.sendUpdateIfNeeded();
            return true;
        }
        if (this.hasGUI()) {
            if (this.getWorld().field_72995_K) {
                FMLCommonHandler.instance().showGuiScreen((Object)this.getGui(player));
            } else {
                this.handleGUIServer(player);
            }
            return true;
        }
        return false;
    }

    public GateConnectionBase getConnection(ForgeDirection side) {
        if (this.bottom() != null && ((GateConnectionBase)this.bottom()).getForgeDirection() == side) {
            return this.bottom();
        }
        if (this.top() != null && ((GateConnectionBase)this.top()).getForgeDirection() == side) {
            return this.top();
        }
        if (this.left() != null && ((GateConnectionBase)this.left()).getForgeDirection() == side) {
            return this.left();
        }
        if (this.right() != null && ((GateConnectionBase)this.right()).getForgeDirection() == side) {
            return this.right();
        }
        if (this.front() != null && ((GateConnectionBase)this.front()).getForgeDirection() == side) {
            return this.front();
        }
        if (this.back() != null && ((GateConnectionBase)this.back()).getForgeDirection() == side) {
            return this.back();
        }
        return null;
    }

    public int getStrongPower(ForgeDirection side) {
        GateConnectionBase con = this.getConnection(side);
        if (con == null) {
            return 0;
        }
        return MathHelper.map((int)(con.getRedstoneOutput() & 0xFF), (int)0, (int)255, (int)0, (int)15);
    }

    public int getWeakPower(ForgeDirection side) {
        GateConnectionBase con = this.getConnection(side);
        if (con == null) {
            return 0;
        }
        return MathHelper.map((int)(con.getRedstoneOutput() & 0xFF), (int)0, (int)255, (int)0, (int)15);
    }

    public boolean canConnectRedstone(ForgeDirection side) {
        GateConnectionBase con = this.getConnection(side);
        if (con == null) {
            return false;
        }
        return con.isEnabled() && con.canConnectRedstone();
    }

    @Override
    public boolean canConnect(ForgeDirection side, IRedstoneDevice device, ConnectionType type) {
        GateConnectionBase con = this.getConnection(side);
        if (con == null) {
            return false;
        }
        if (type == ConnectionType.OPEN_CORNER && device instanceof IGate) {
            return false;
        }
        return con.isEnabled() && con.canConnect(device);
    }

    @Override
    public void onConnect(IConnection<?> connection) {
    }

    @Override
    public void onDisconnect(IConnection<?> connection) {
        if (connection == null) {
            return;
        }
        GateConnectionBase c = this.getConnection(connection.getSideA());
        if (c == null) {
            return;
        }
        c.setRedstonePower((byte)0);
    }

    @Override
    public byte getRedstonePower(ForgeDirection side) {
        GateConnectionBase con = this.getConnection(side);
        if (con == null) {
            return 0;
        }
        return con.getRedstoneOutput();
    }

    @Override
    public void setRedstonePower(ForgeDirection side, byte power) {
        GateConnectionBase con = this.getConnection(side);
        if (con == null) {
            return;
        }
        con.setRedstonePower(power);
    }

    @Override
    public void onRedstoneUpdate() {
        this.doLogicStuff();
    }

    @Override
    public boolean canConnect(ForgeDirection side, IBundledDevice device, ConnectionType type) {
        GateConnectionBase con = this.getConnection(side);
        if (con == null) {
            return false;
        }
        if (type == ConnectionType.OPEN_CORNER && device instanceof IGate) {
            return false;
        }
        return con.isEnabled() && con.canConnect(device);
    }

    @Override
    public byte[] getBundledOutput(ForgeDirection side) {
        return this.getBundledPower(side);
    }

    @Override
    public void setBundledPower(ForgeDirection side, byte[] power) {
        GateConnectionBase con = this.getConnection(side);
        if (con == null) {
            return;
        }
        con.setBundledPower(power);
    }

    @Override
    public byte[] getBundledPower(ForgeDirection side) {
        GateConnectionBase con = this.getConnection(side);
        if (con == null) {
            return new byte[16];
        }
        return con.getBundledOutput();
    }

    @Override
    public void onBundledUpdate() {
        this.doLogicStuff();
    }

    @Override
    public MinecraftColor getBundledColor(ForgeDirection side) {
        return MinecraftColor.NONE;
    }

    public RedstoneConnectionCache getRedstoneConnectionCache() {
        return this.redstoneConnections;
    }

    public BundledConnectionCache getBundledConnectionCache() {
        return this.bundledConnections;
    }

    @Override
    public boolean isNormalFace(ForgeDirection side) {
        return false;
    }

    @Override
    public final void addCollisionBoxesToList(List<Vec3dCube> boxes, Entity entity) {
        ArrayList<Vec3dCube> boxes_ = new ArrayList<Vec3dCube>();
        this.addCollisionBoxes(boxes_, entity);
        VectorHelper.rotateBoxes(boxes_, this.getFace(), this.getRotation());
        for (Vec3dCube c : boxes_) {
            boxes.add(c);
        }
    }

    public void addCollisionBoxes(List<Vec3dCube> boxes, Entity entity) {
        boxes.add(BOX.clone());
    }

    @Override
    public final List<Vec3dCube> getOcclusionBoxes() {
        ArrayList<Vec3dCube> boxes = new ArrayList<Vec3dCube>();
        this.addOcclusionBoxes(boxes);
        VectorHelper.rotateBoxes(boxes, this.getFace(), this.getRotation());
        return boxes;
    }

    public void addOcclusionBoxes(List<Vec3dCube> boxes) {
        boxes.add(new Vec3dCube(0.125, 0.0, 0.0, 0.875, 0.125, 1.0));
        boxes.add(new Vec3dCube(0.0, 0.0, 0.125, 1.0, 0.125, 0.875));
    }

    @Override
    public final List<Vec3dCube> getSelectionBoxes() {
        ArrayList<Vec3dCube> boxes = new ArrayList<Vec3dCube>();
        this.addSelectionBoxes(boxes);
        VectorHelper.rotateBoxes(boxes, this.getFace(), this.getRotation());
        return boxes;
    }

    public void addSelectionBoxes(List<Vec3dCube> boxes) {
        boxes.add(BOX.clone().expand(-0.001));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(Vec3i translation, RenderHelper renderer, RenderBlocks renderBlocks, int pass) {
        int rotation;
        Rotation t = null;
        if (this.getFace() == ForgeDirection.UP) {
            t = new Rotation(180.0, 180.0, 0.0, Vec3d.center);
        }
        if (this.getFace() == ForgeDirection.NORTH) {
            t = new Rotation(90.0, 0.0, 0.0, Vec3d.center);
        }
        if (this.getFace() == ForgeDirection.SOUTH) {
            t = new Rotation(-90.0, 0.0, 0.0, Vec3d.center);
        }
        if (this.getFace() == ForgeDirection.WEST) {
            t = new Rotation(0.0, 0.0, -90.0, Vec3d.center);
        }
        if (this.getFace() == ForgeDirection.EAST) {
            t = new Rotation(0.0, 0.0, 90.0, Vec3d.center);
        }
        if (t != null) {
            renderer.addTransformation((Transformation)t);
        }
        if ((rotation = this.getRotation()) != -1) {
            renderer.addTransformation((Transformation)new Rotation(0.0, (double)(90 * -rotation), 0.0));
        }
        renderer.renderBox(BOX, this.getIcon(ForgeDirection.DOWN), this.getIcon(ForgeDirection.UP), this.getIcon(ForgeDirection.WEST), this.getIcon(ForgeDirection.EAST), this.getIcon(ForgeDirection.NORTH), this.getIcon(ForgeDirection.SOUTH));
        for (IGateComponent c : this.getComponents()) {
            c.renderStatic(translation, renderer, pass);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vec3d translation, double delta, int pass) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)translation.getX(), (double)translation.getY(), (double)translation.getZ());
        GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
        switch (this.getFace()) {
            case DOWN: {
                break;
            }
            case UP: {
                GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
                break;
            }
            case NORTH: {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                break;
            }
            case SOUTH: {
                GL11.glRotated((double)90.0, (double)-1.0, (double)0.0, (double)0.0);
                break;
            }
            case WEST: {
                GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)-1.0);
                break;
            }
            case EAST: {
                GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
        }
        int rotation = this.getRotation();
        GL11.glRotated((double)(90 * (rotation == 0 || rotation == 2 ? (rotation + 2) % 4 : rotation)), (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
        for (IGateComponent c : this.getComponents()) {
            GL11.glPushMatrix();
            c.renderDynamic(translation, delta, pass);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GuiScreen gui;
        if (this instanceof ISilkyRemovable) {
            if (this instanceof IAdvancedSilkyRemovable) {
                ((IAdvancedSilkyRemovable)((Object)this)).readSilkyData(null, 0, 0, 0, item.func_77942_o() ? item.func_77978_p().func_74775_l("tileData") : new NBTTagCompound());
            } else {
                this.readFromNBT(item.func_77942_o() ? item.func_77978_p().func_74775_l("tileData") : new NBTTagCompound());
            }
        }
        GL11.glPushMatrix();
        RenderHelper rh = RenderHelper.instance;
        rh.reset();
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glTranslated((double)-0.25, (double)0.75, (double)0.25);
        }
        if (type == IItemRenderer.ItemRenderType.ENTITY && item.func_82836_z() != null) {
            GL11.glTranslated((double)0.59375, (double)0.5, (double)1.0);
            GL11.glRotated((double)-90.0, (double)0.0, (double)0.0, (double)1.0);
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        }
        if (type == IItemRenderer.ItemRenderType.INVENTORY && BluePower.proxy.isSneakingInGui() && (gui = Minecraft.func_71410_x().field_71462_r) != null && gui instanceof GuiContainer) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScaled((double)1.5, (double)1.5, (double)1.5);
            GL11.glTranslated((double)-0.5, (double)0.0, (double)0.0);
            GL11.glTranslated((double)0.0, (double)-0.5, (double)0.0);
            GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
            GL11.glTranslated((double)0.0, (double)0.5, (double)0.0);
        }
        Tessellator.field_78398_a.func_78382_b();
        if (this.shouldRenderOnPass(0)) {
            this.renderStatic(new Vec3i(0, 0, 0), rh, RenderBlocks.getInstance(), 0);
        }
        rh.reset();
        if (this.shouldRenderOnPass(1)) {
            this.renderStatic(new Vec3i(0, 0, 0), rh, RenderBlocks.getInstance(), 1);
        }
        rh.reset();
        Tessellator.field_78398_a.func_78381_a();
        if (this.shouldRenderOnPass(0)) {
            this.renderDynamic(new Vec3d(0.0, 0.0, 0.0), 0.0, 0);
        }
        if (this.shouldRenderOnPass(1)) {
            this.renderDynamic(new Vec3d(0.0, 0.0, 0.0), 0.0, 1);
        }
        GL11.glPopMatrix();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister reg) {
        icon = reg.func_94245_a("bluepower:gates/gate");
        iconSide = reg.func_94245_a("bluepower:gates/side");
        iconDark = reg.func_94245_a("bluepower:gates/gate_dark");
        if (this.getLayout() == null) {
            this.loadLayout();
        } else {
            this.layout.reload();
        }
        this.components.clear();
        this.initComponents();
    }

    protected void loadLayout() {
        if (this.layout == null) {
            this.layout = new Layout("/assets/bluepower/textures/blocks/gates/" + this.getGateType());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ForgeDirection face) {
        if (face == ForgeDirection.DOWN) {
            return icon;
        }
        if (face == ForgeDirection.UP) {
            return icon;
        }
        return iconSide;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getDarkTop() {
        return iconDark;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        NBTTagCompound data;
        super.writeToNBT(tag);
        NBTTagCompound connections = new NBTTagCompound();
        for (GateConnectionBase gateConnectionBase : this.getConnections()) {
            if (gateConnectionBase == null) continue;
            data = new NBTTagCompound();
            gateConnectionBase.writeToNBT(data);
            connections.func_74782_a(gateConnectionBase.getDirection().name(), (NBTBase)data);
        }
        tag.func_74782_a("connections", (NBTBase)connections);
        NBTTagCompound t = new NBTTagCompound();
        int i = 0;
        for (IGateComponent iGateComponent : this.getComponents()) {
            data = new NBTTagCompound();
            iGateComponent.writeToNBT(data);
            t.func_74782_a(i + "", (NBTBase)data);
            ++i;
        }
        tag.func_74782_a("components", (NBTBase)t);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        NBTTagCompound connections = tag.func_74775_l("connections");
        for (GateConnectionBase gateConnectionBase : this.getConnections()) {
            if (gateConnectionBase == null) continue;
            gateConnectionBase.readFromNBT(connections.func_74775_l(gateConnectionBase.getDirection().name()));
        }
        NBTTagCompound components = tag.func_74775_l("components");
        int i = 0;
        for (IGateComponent iGateComponent : this.getComponents()) {
            iGateComponent.readFromNBT(components.func_74775_l(i + ""));
            ++i;
        }
    }

    @Override
    public void writeUpdateData(DataOutput buffer) throws IOException {
        super.writeUpdateData(buffer);
        for (IGateComponent c : this.getComponents()) {
            c.writeData(buffer);
        }
        for (GateConnectionBase c : this.getConnections()) {
            if (c == null) continue;
            c.writeData(buffer);
        }
    }

    @Override
    public void readUpdateData(DataInput buffer) throws IOException {
        super.readUpdateData(buffer);
        for (IGateComponent c : this.getComponents()) {
            c.readData(buffer);
        }
        for (GateConnectionBase c : this.getConnections()) {
            if (c == null) continue;
            c.readData(buffer);
        }
        if (this.getParent() != null && this.getWorld() != null) {
            this.getWorld().func_147458_c(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ());
        }
    }

    protected void handleGUIServer(EntityPlayer player) {
    }

    @SideOnly(value=Side.CLIENT)
    protected GuiScreen getGui(EntityPlayer player) {
        return null;
    }

    protected boolean hasGUI() {
        return false;
    }

    protected void playTickSound() {
        if (this.getWorld().field_72995_K) {
            this.playTickSound_do();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playTickSound_do() {
        if (Config.enableGateSounds) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(new ResourceLocation("random.click"), 0.3f, 0.5f, (float)this.getX() + 0.5f, (float)this.getY() + 0.5f, (float)this.getZ() + 0.5f));
        }
    }

    @Override
    public boolean canPlaceOnIntegratedCircuit() {
        return true;
    }
}

