/*
 * Decompiled with CFR 0.152.
 */
package techguns.items.armors;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import techguns.damagesystem.TGArmorMaterial;
import techguns.items.armors.GenericArmor;
import techguns.items.armors.ICamoChangeable;
import techguns.util.TextUtil;

public class GenericArmorMultiCamo
extends GenericArmor
implements ICamoChangeable {
    protected static Random rnd = new Random();
    protected String[] textureNames;
    protected String camoNameSuffix = "";

    public GenericArmorMultiCamo(String unlocalizedName, TGArmorMaterial material, String[] textureNames, int type) {
        super(unlocalizedName, material, textureNames[0], type);
        this.textureNames = textureNames;
    }

    public GenericArmorMultiCamo setCamoNameSuffix(String s) {
        this.camoNameSuffix = s + ".";
        return this;
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        NBTTagCompound tags = stack.func_77978_p();
        byte camoID = 0;
        if (tags != null && tags.func_74764_b("camo")) {
            camoID = tags.func_74771_c("camo");
        }
        if (this.hasDoubleTexture()) {
            return "Techguns:textures/armor/" + this.textureNames[camoID] + "_" + (this.field_77881_a == 2 ? "2" : "1") + ".png";
        }
        return "Techguns:textures/armor/" + this.textureNames[camoID] + ".png";
    }

    @Override
    public int switchCamo(ItemStack item) {
        return this.switchCamo(item, false);
    }

    @Override
    public int switchCamo(ItemStack item, boolean back) {
        ICamoChangeable it;
        NBTTagCompound tags = item.func_77978_p();
        if (tags == null) {
            tags = new NBTTagCompound();
            item.func_77982_d(tags);
        }
        byte camoID = 0;
        if (tags.func_74764_b("camo")) {
            camoID = tags.func_74771_c("camo");
        }
        if ((camoID = back ? (byte)(camoID - 1) : (byte)(camoID + 1)) >= (it = (ICamoChangeable)item.func_77973_b()).getCamoCount()) {
            camoID = 0;
        } else if (camoID < 0) {
            camoID = (byte)(it.getCamoCount() - 1);
        }
        tags.func_74774_a("camo", camoID);
        return camoID;
    }

    @Override
    public void func_77624_a(ItemStack item, EntityPlayer player, List list, boolean b) {
        super.func_77624_a(item, player, list, b);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextUtil.trans("techguns.tooltip.currentcamo") + ": " + this.getCurrentCamoName(item));
        }
    }

    @Override
    public int getCamoCount() {
        if (this.textureNames != null) {
            return this.textureNames.length;
        }
        return 0;
    }

    @Override
    public String getCurrentCamoName(ItemStack item) {
        NBTTagCompound tags = item.func_77978_p();
        int camoID = -1;
        if (tags != null && tags.func_74764_b("camo")) {
            camoID = tags.func_74771_c("camo");
        }
        if (camoID >= 0) {
            return TextUtil.trans("techguns.item." + this.textureNames[0] + "." + this.camoNameSuffix + "camoname." + camoID);
        }
        return TextUtil.trans("techguns.item.invalidcamo");
    }

    @Override
    public int getCurrentCamoIndex(ItemStack item) {
        NBTTagCompound tags = item.func_77978_p();
        int camoID = -1;
        if (tags != null && tags.func_74764_b("camo")) {
            camoID = tags.func_74771_c("camo");
        }
        return camoID;
    }

    public static int getRandomCamoIndexFor(GenericArmorMultiCamo type) {
        int count = type.getCamoCount();
        if (count <= 0) {
            return 0;
        }
        return rnd.nextInt(count);
    }

    public static ItemStack getNewWithCamo(Item item, int camo) {
        ItemStack armor = new ItemStack(item);
        NBTTagCompound tags = armor.func_77978_p();
        if (tags == null) {
            tags = new NBTTagCompound();
            armor.func_77982_d(tags);
        }
        tags.func_74774_a("camo", (byte)camo);
        return armor;
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
        NBTTagCompound tags = stack.func_77978_p();
        if (tags == null) {
            tags = new NBTTagCompound();
            stack.func_77982_d(tags);
        }
        tags.func_74774_a("camo", (byte)0);
    }
}

