/*
 * Decompiled with CFR 0.152.
 */
package techguns.gui.playerinventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import techguns.extendedproperties.TechgunsExtendedPlayerProperties;

public class TGPlayerInventory
implements IInventory {
    private static final String name = "TechgunsPlayerInventory";
    public static final int NUMSLOTS = 12;
    public static final int SLOT_FACE = 0;
    public static final int SLOT_BACK = 1;
    public static final int SLOTS_AUTOFOOD_START = 2;
    public static final int SLOTS_AUTOFOOD_END = 4;
    public static final int SLOT_AUTOHEAL = 5;
    public static final int SLOTS_AMMO_START = 6;
    public static final int SLOTS_AMMO_END = 11;
    public ItemStack[] inventory = new ItemStack[12];
    public boolean dirty = false;
    public EntityPlayer player;

    public TGPlayerInventory(EntityPlayer player) {
        this.player = player;
    }

    public void saveNBTData(NBTTagCompound tags) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        tags.func_74782_a(name, (NBTBase)nbttaglist);
    }

    public void loadNBTData(NBTTagCompound tags) {
        NBTTagList nbttaglist = tags.func_150295_c(name, 10);
        this.inventory = new ItemStack[12];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= 12) continue;
            this.inventory[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    public int func_70302_i_() {
        return 12;
    }

    public ItemStack func_70301_a(int slotid) {
        return slotid >= 0 && slotid < this.inventory.length ? this.inventory[slotid] : null;
    }

    public ItemStack func_70298_a(int slotid, int amount) {
        if (this.inventory[slotid] != null) {
            if (this.inventory[slotid].field_77994_a <= amount) {
                ItemStack itemstack = this.inventory[slotid];
                this.inventory[slotid] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.inventory[slotid].func_77979_a(amount);
            if (this.inventory[slotid].field_77994_a == 0) {
                this.inventory[slotid] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slotid) {
        if (this.inventory[slotid] != null) {
            ItemStack itemstack = this.inventory[slotid];
            this.inventory[slotid] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slotid, ItemStack itemstack) {
        this.inventory[slotid] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        if (slotid == 0) {
            this.player.func_70096_w().func_75692_b(TechgunsExtendedPlayerProperties.DATA_WATCHER_ID_FACESLOT, (Object)this.inventory[slotid]);
        } else if (slotid == 1) {
            this.player.func_70096_w().func_75692_b(TechgunsExtendedPlayerProperties.DATA_WATCHER_ID_BACKSLOT, (Object)this.inventory[slotid]);
        }
    }

    public String func_145825_b() {
        return name;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.dirty = true;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slotid, ItemStack itemstack) {
        return true;
    }
}

