/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import techguns.TGPackets;
import techguns.packets.PacketSpawnParticle;
import techguns.util.MathUtil;

public class TeslaBeam
extends Entity
implements IEntityAdditionalSpawnData {
    protected int ticksToLive = 10;
    protected int lifetime = 10;
    protected EntityLivingBase shooter;
    private double targetX;
    private double targetY;
    private double targetZ;
    public long seed;
    public double beamlength;

    public TeslaBeam(World worldObj, EntityLivingBase shooter) {
        this(worldObj, shooter, -1.0);
    }

    protected String getParticleName() {
        return "TeslaFlare";
    }

    protected String getParticleNameStart() {
        return null;
    }

    protected void setInitialPosition(EntityLivingBase shooter, float yaw, float pitch) {
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, yaw, pitch);
    }

    public TeslaBeam(World worldObj, EntityLivingBase shooter, double beamlength) {
        super(worldObj);
        this.shooter = shooter;
        if (this.shooter != null) {
            float yaw = shooter.field_70759_as;
            float pitch = shooter.field_70125_A;
            this.setInitialPosition(shooter, yaw, pitch);
        }
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        this.seed = this.field_70146_Z.nextLong();
        if (beamlength >= 0.0) {
            this.beamlength = beamlength;
        } else {
            Vec3 vec31;
            float f = 1.0f;
            double dx = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
            double dz = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
            double dy = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
            Vec3 vec3 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            MovingObjectPosition movingobjectposition = MathUtil.traceVector(this.field_70170_p, vec3, vec31 = Vec3.func_72443_a((double)dx, (double)dy, (double)dz), 10.0, 10, this, this.shooter);
            if (movingobjectposition != null) {
                switch (movingobjectposition.field_72313_a) {
                    case BLOCK: {
                        this.targetX = movingobjectposition.field_72307_f.field_72450_a;
                        this.targetY = movingobjectposition.field_72307_f.field_72448_b;
                        this.targetZ = movingobjectposition.field_72307_f.field_72449_c;
                        break;
                    }
                    case ENTITY: {
                        this.targetX = movingobjectposition.field_72307_f.field_72450_a;
                        this.targetY = movingobjectposition.field_72307_f.field_72448_b;
                        this.targetZ = movingobjectposition.field_72307_f.field_72449_c;
                        break;
                    }
                    case MISS: {
                        this.targetX = dx;
                        this.targetY = dy;
                        this.targetZ = dz;
                    }
                }
            } else {
                this.targetX = dx;
                this.targetY = dy;
                this.targetZ = dz;
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.getParticleName() != null) {
                    TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticle(this.getParticleName(), this.targetX, this.targetY, this.targetZ), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.targetX, this.targetY, this.targetZ, 50.0));
                }
                if (this.getParticleNameStart() != null) {
                    TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticle(this.getParticleNameStart(), this.field_70165_t, this.field_70163_u, this.field_70161_v), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0));
                }
            }
            Vec3 pos = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            this.beamlength = pos.func_72438_d(Vec3.func_72443_a((double)this.targetX, (double)this.targetY, (double)this.targetZ));
        }
    }

    public TeslaBeam(World worldObj) {
        super(worldObj);
        this.field_70158_ak = true;
    }

    public TeslaBeam(World worldObj, EntityLivingBase shooter, double x, double y, double z, Entity target) {
        this(worldObj, shooter, x, y, z, target, -1.0);
    }

    public TeslaBeam(World worldObj, EntityLivingBase shooter, double x, double y, double z, Entity target, double beamlength) {
        super(worldObj);
        this.shooter = shooter;
        double dX = x - target.field_70165_t;
        double dY = y - target.field_70163_u + (double)(target.field_70131_O / 2.0f);
        double dZ = z - target.field_70161_v;
        double yaw = Math.atan2(dZ, dX) * 57.29577951308232 - 90.0;
        double pitch = Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) * 57.29577951308232 + 90.0;
        this.func_70012_b(x, y, z, (float)yaw, (float)pitch);
        this.seed = this.field_70146_Z.nextLong();
        Vec3 vec3 = Vec3.func_72443_a((double)x, (double)y, (double)z);
        this.beamlength = vec3.func_72438_d(Vec3.func_72443_a((double)target.field_70165_t, (double)(target.field_70163_u + (double)(target.field_70131_O / 2.0f)), (double)target.field_70161_v));
    }

    public void func_70071_h_() {
        if (this.ticksToLive == this.lifetime) {
            // empty if block
        }
        --this.ticksToLive;
        if (this.ticksToLive <= 0) {
            this.func_70106_y();
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeDouble(this.beamlength);
        buffer.writeLong(this.seed);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.beamlength = additionalData.readDouble();
        this.seed = additionalData.readLong();
    }
}

