/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.Techguns;
import techguns.damagesystem.TGDamageSource;
import techguns.entities.projectiles.GenericProjectile;
import techguns.util.EntityDeathUtils;

public class CyberdemonBlasterProjectile
extends GenericProjectile {
    boolean piercing = false;
    boolean ignite;
    float chanceToIgnite = 0.5f;
    int entityIgniteTime = 3;
    float gravity;

    public CyberdemonBlasterProjectile(World par2World, EntityPlayer par3Player, float damage, float speed, int TTL, float spread, int dmgDropStart, int dmgDropEnd, float dmgMin, float penetration, boolean blockdamage) {
        super(par2World, (EntityLivingBase)par3Player, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage);
    }

    public CyberdemonBlasterProjectile(World par1World) {
        super(par1World);
        this.speed = 0.85f;
        this.field_70159_w *= (double)this.speed;
        this.field_70181_x *= (double)this.speed;
        this.field_70179_y *= (double)this.speed;
    }

    public CyberdemonBlasterProjectile(World par2World, EntityLivingBase player, float damage, float speed, int TTL, float gravity, float spread, boolean piercing, boolean ignite, int dmgDropStart, int dmgDropEnd, float dmgMin, float penetration) {
        super(par2World, player, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, ignite);
        this.gravity = gravity;
        this.piercing = piercing;
        this.ignite = ignite;
        float f5 = 0.2f;
        Techguns.proxy.spawnParticle("BlasterFlare", this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w * (double)f5, this.field_70181_x * (double)f5, this.field_70179_y * (double)f5);
    }

    @Override
    protected float getGravityVelocity() {
        return this.gravity;
    }

    @Override
    protected void hitBlock(MovingObjectPosition mop) {
        int x = mop.field_72311_b;
        int y = mop.field_72312_c;
        int z = mop.field_72309_d;
        Techguns.proxy.createFX("NetherBlasterImpactFlare", this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
        Techguns.proxy.createFX("MediumExplosionSmoke", this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
        if (this.blockdamage && Math.random() <= (double)this.chanceToIgnite) {
            switch (mop.field_72310_e) {
                case 0: {
                    if (!this.field_70170_p.func_147437_c(x, y - 1, z)) break;
                    this.field_70170_p.func_147449_b(x, y - 1, z, (Block)Blocks.field_150480_ab);
                    break;
                }
                case 1: {
                    if (!this.field_70170_p.func_147437_c(x, y + 1, z)) break;
                    if (this.field_70170_p.func_147439_a(x, y, z) == Blocks.field_150458_ak) {
                        this.field_70170_p.func_147449_b(x, y, z, Blocks.field_150346_d);
                    }
                    this.field_70170_p.func_147449_b(x, y + 1, z, (Block)Blocks.field_150480_ab);
                    break;
                }
                case 2: {
                    if (!this.field_70170_p.func_147437_c(x, y, z - 1)) break;
                    this.field_70170_p.func_147449_b(x, y, z - 1, (Block)Blocks.field_150480_ab);
                    break;
                }
                case 3: {
                    if (!this.field_70170_p.func_147437_c(x, y, z + 1)) break;
                    this.field_70170_p.func_147449_b(x, y, z + 1, (Block)Blocks.field_150480_ab);
                    break;
                }
                case 4: {
                    if (!this.field_70170_p.func_147437_c(x - 1, y, z)) break;
                    this.field_70170_p.func_147449_b(x - 1, y, z, (Block)Blocks.field_150480_ab);
                    break;
                }
                case 5: {
                    if (!this.field_70170_p.func_147437_c(x + 1, y, z)) break;
                    this.field_70170_p.func_147449_b(x + 1, y, z, (Block)Blocks.field_150480_ab);
                }
            }
            Block b = this.field_70170_p.func_147439_a(x, y, z);
            if (b == TGBlocks.camoNetRoof || b == TGBlocks.camoNetPane) {
                this.field_70170_p.func_72869_a("lava", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
                this.field_70170_p.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
            } else if (this.field_70170_p.func_147439_a(x, y - 1, z) == Blocks.field_150458_ak) {
                this.field_70170_p.func_147449_b(x, y - 1, z, Blocks.field_150346_d);
                this.field_70170_p.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
            }
        }
    }

    @Override
    protected void onHitEffect(EntityLivingBase ent) {
        Techguns.proxy.createFX("NetherBlasterImpactFlare", this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
        Techguns.proxy.createFX("MediumExplosionSmoke", this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
    }

    @Override
    protected void func_70037_a(NBTTagCompound tags) {
        super.func_70037_a(tags);
    }

    @Override
    protected void func_70014_b(NBTTagCompound tags) {
        super.func_70014_b(tags);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70090_H()) {
            for (int l = 0; l < 4; ++l) {
                float f4 = 0.25f;
                this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            this.func_70106_y();
        } else {
            float f = 0.1f;
        }
    }

    @Override
    protected TGDamageSource getProjectileDamageSource() {
        TGDamageSource src = TGDamageSource.causeFireDamage(this, (Entity)this.shooter, EntityDeathUtils.DeathType.DEFAULT);
        src.armorPenetration = this.penetration;
        src.knockbackMultiplier = 1.0f;
        return src;
    }
}

