/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.spectre;

import me.planetguy.remaininmotion.util.position.BlockRecord;
import me.planetguy.remaininmotion.util.transformations.Directions;
import me.planetguy.remaininmotion.util.transformations.Matrices;
import me.planetguy.remaininmotion.util.transformations.Matrix;

public class RemIMRotator {
    public static void rotateOrthogonal(BlockRecord pivot, Directions clockwiseFace, BlockRecord pos) {
        double offset = 0.0;
        double px = (double)pivot.X + offset;
        double py = (double)pivot.Y + offset;
        double pz = (double)pivot.Z + offset;
        Matrix coordsMatrixNew = new Matrix(new double[][]{{(double)pos.X - px}, {(double)pos.Y - py}, {(double)pos.Z - pz}});
        Matrix rotation = Matrices.ccwRotMatrices[clockwiseFace.ordinal()];
        Matrix newCoords = rotation.crossProduct(coordsMatrixNew);
        pos.X = (int)(newCoords.matrix[0][0] + px);
        pos.Y = (int)(newCoords.matrix[1][0] + py);
        pos.Z = (int)(newCoords.matrix[2][0] + pz);
    }

    public static BlockRecord simulateRotateOrthogonal(BlockRecord pivot, Directions clockwiseFace, BlockRecord pos) {
        double offset = 0.0;
        double px = (double)pivot.X + offset;
        double py = (double)pivot.Y + offset;
        double pz = (double)pivot.Z + offset;
        Matrix coordsMatrixNew = new Matrix(new double[][]{{(double)pos.X - px}, {(double)pos.Y - py}, {(double)pos.Z - pz}});
        Matrix rotation = Matrices.ccwRotMatrices[clockwiseFace.ordinal()];
        Matrix newCoords = rotation.crossProduct(coordsMatrixNew);
        BlockRecord newRecord = new BlockRecord((int)(newCoords.matrix[0][0] + px), (int)(newCoords.matrix[1][0] + py), (int)(newCoords.matrix[2][0] + pz));
        newRecord.block = pos.block;
        newRecord.Meta = pos.Meta;
        newRecord.World = pos.World;
        return newRecord;
    }

    public static void rotatePartial(BlockRecord pivot, Directions clockwiseFace, Matrix pos, double partialAngle) {
        double px = pivot.X;
        double py = pivot.Y;
        double pz = pivot.Z;
        Matrix coordsMatrixNew = new Matrix(new double[][]{{pos.matrix[0][0] - px}, {pos.matrix[1][0] - py}, {pos.matrix[2][0] - pz}});
        Matrix rotation = Matrices.fromAxisAndAngle(clockwiseFace.ordinal(), partialAngle);
        Matrix newCoords = rotation.crossProduct(coordsMatrixNew);
        pos.matrix[0][0] = newCoords.matrix[0][0] + px;
        pos.matrix[1][0] = newCoords.matrix[1][0] + py;
        pos.matrix[2][0] = newCoords.matrix[2][0] + pz;
    }

    public static void rotatePartialEntity(BlockRecord pivot, Directions clockwiseFace, Matrix pos, double partialAngle) {
        double px = (double)pivot.X + 0.5;
        double py = (double)pivot.Y + 0.5;
        double pz = (double)pivot.Z + 0.5;
        Matrix coordsMatrixNew = new Matrix(new double[][]{{pos.matrix[0][0] - px}, {pos.matrix[1][0] - py}, {pos.matrix[2][0] - pz}});
        Matrix rotation = Matrices.fromAxisAndAngle(clockwiseFace.ordinal(), partialAngle);
        Matrix newCoords = rotation.crossProduct(coordsMatrixNew);
        pos.matrix[0][0] = newCoords.matrix[0][0] + px;
        pos.matrix[1][0] = newCoords.matrix[1][0] + py;
        pos.matrix[2][0] = newCoords.matrix[2][0] + pz;
    }
}

