/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.core.interop.mod;

import buildcraft.builders.TileQuarry;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.factory.BlockTank;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import me.planetguy.lib.util.transformations.Rotator;
import me.planetguy.remaininmotion.api.event.CancelableOnBlockAddedEvent;
import me.planetguy.remaininmotion.api.event.IBlockPos;
import me.planetguy.remaininmotion.api.event.RotatingTEPreUnpackEvent;
import me.planetguy.remaininmotion.api.event.TEPostPlaceEvent;
import me.planetguy.remaininmotion.api.event.TEPreUnpackEvent;
import me.planetguy.remaininmotion.spectre.TileEntityMotiveSpectre;
import me.planetguy.remaininmotion.util.position.BlockRecord;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;

public class Buildcraft {
    @SubscribeEvent
    public void onBCMoved(TEPreUnpackEvent e) {
        this.performBuildcraftPreInit((BlockRecord)e.location, ((TileEntityMotiveSpectre)e.spectre).getOffset((BlockRecord)e.location));
    }

    @SubscribeEvent
    public void onBCMoved(TEPostPlaceEvent e) {
        this.performBuildcraftPostInit((BlockRecord)e.location, ((TileEntityMotiveSpectre)e.spectre).getOffset((BlockRecord)e.location));
    }

    @SubscribeEvent
    public void onRotated(RotatingTEPreUnpackEvent e) {
        IBlockPos pos = e.location;
        Block b = pos.world().func_147439_a(pos.x(), pos.y(), pos.z());
        if (pos.world().field_72995_K) {
            return;
        }
        if (b instanceof BlockGenericPipe) {
            int i;
            NBTTagCompound tag = e.location.entityTag();
            NBTTagCompound[] foundTags = new NBTTagCompound[6];
            for (i = 0; i < 6; ++i) {
                String tagName = "pluggable[" + i + "]";
                if (!tag.func_74764_b(tagName)) continue;
                NBTTagCompound pluggableForSide = tag.func_74775_l(tagName);
                tag.func_82580_o(tagName);
                foundTags[Rotator.newSide((int)i, (ForgeDirection)e.axis)] = pluggableForSide;
            }
            for (i = 0; i < 6; ++i) {
                if (foundTags[i] == null) continue;
                tag.func_74782_a("pluggable[" + i + "]", (NBTBase)foundTags[i]);
            }
        }
    }

    private void performBuildcraftPreInit(IBlockPos record, int[] offset) {
        NBTTagCompound boxNBT;
        if (record.entityTag().func_74764_b("box") && !(boxNBT = record.entityTag().func_74775_l("box")).func_82582_d()) {
            int xMax = boxNBT.func_74762_e("xMax");
            int xMin = boxNBT.func_74762_e("xMin");
            int yMax = boxNBT.func_74762_e("yMax");
            int yMin = boxNBT.func_74762_e("yMin");
            int zMax = boxNBT.func_74762_e("zMax");
            int zMin = boxNBT.func_74762_e("zMin");
            boxNBT.func_74768_a("xMax", xMax += offset[0]);
            boxNBT.func_74768_a("xMin", xMin += offset[0]);
            boxNBT.func_74768_a("yMax", yMax += offset[1]);
            boxNBT.func_74768_a("yMin", yMin += offset[1]);
            boxNBT.func_74768_a("zMax", zMax += offset[2]);
            boxNBT.func_74768_a("zMin", zMin += offset[2]);
        }
        if (record.entityTag().func_74764_b("done")) {
            record.entityTag().func_74757_a("done", false);
        }
        if (record.entityTag().func_74764_b("digging")) {
            record.entityTag().func_74757_a("digging", true);
        }
        if (record.entityTag().func_74779_i("id").equals("Machine")) {
            record.entityTag().func_74768_a("targetX", 0);
            record.entityTag().func_74768_a("targetY", 0);
            record.entityTag().func_74768_a("targetZ", 0);
            record.entityTag().func_74780_a("headPosX", 0.0);
            record.entityTag().func_74780_a("headPosY", 0.0);
            record.entityTag().func_74780_a("headPosZ", 0.0);
        }
        if (record.entityTag().func_74764_b("travelingEntities")) {
            NBTTagList list = record.entityTag().func_150295_c("travelingEntities", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                if (tag == null || !tag.func_74764_b("x")) continue;
                tag.func_74780_a("x", tag.func_74769_h("x") + (double)offset[0]);
                tag.func_74780_a("y", tag.func_74769_h("y") + (double)offset[1]);
                tag.func_74780_a("z", tag.func_74769_h("z") + (double)offset[2]);
            }
        }
    }

    private void performBuildcraftPostInit(IBlockPos record, int[] offset) {
        try {
            if (record.entity() instanceof TileGenericPipe) {
                TileGenericPipe tile = (TileGenericPipe)record.entity();
                Pipe pipe = tile.pipe;
                if (!tile.initialized) {
                    tile.initialize(pipe);
                }
            } else if (record.entity() instanceof TileBuildCraft) {
                record.entity().func_145843_s();
                ((TileBuildCraft)record.entity()).initialize();
                if (record.entity() instanceof TileQuarry) {
                    ((TileQuarry)record.entity()).createUtilsIfNeeded();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onBlockAdded(CancelableOnBlockAddedEvent e) {
        if (e.worldObj.func_147439_a(e.xCoord, e.yCoord, e.zCoord) instanceof BlockTank) {
            e.setCanceled(true);
        }
    }
}

