/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.carriage;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import me.planetguy.lib.util.Lang;
import me.planetguy.remaininmotion.carriage.TileEntityCarriage;
import me.planetguy.remaininmotion.motion.CarriageMotionException;
import me.planetguy.remaininmotion.motion.CarriagePackage;
import me.planetguy.remaininmotion.util.position.BlockRecord;
import me.planetguy.remaininmotion.util.transformations.Directions;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityStructureCarriage
extends TileEntityCarriage {
    public EdgeTypes EdgeType;
    public CornerTypes CornerType;

    public void CheckSides() {
        block4: {
            ArrayList<Directions> OpenDirections;
            block3: {
                this.EdgeType = null;
                this.CornerType = null;
                OpenDirections = new ArrayList<Directions>();
                for (Directions Direction : Directions.values()) {
                    if (this.SideClosed[Direction.ordinal()]) continue;
                    OpenDirections.add(Direction);
                }
                Collections.sort(OpenDirections);
                if (OpenDirections.size() != 2) break block3;
                Directions Neg = (Directions)((Object)OpenDirections.get(0));
                Directions Pos = (Directions)((Object)OpenDirections.get(1));
                for (EdgeTypes EdgeType : EdgeTypes.values()) {
                    if (EdgeType.Neg != Neg || EdgeType.Pos != Pos) continue;
                    this.EdgeType = EdgeType;
                    return;
                }
                break block4;
            }
            if (OpenDirections.size() < 3) break block4;
            Directions Y = (Directions)((Object)OpenDirections.get(0));
            Directions Z = (Directions)((Object)OpenDirections.get(1));
            Directions X = (Directions)((Object)OpenDirections.get(2));
            for (CornerTypes CornerType : CornerTypes.values()) {
                if (CornerType.ToNextAlongX != X || CornerType.ToNextAlongY != Y || CornerType.ToNextAlongZ != Z) continue;
                this.CornerType = CornerType;
                return;
            }
        }
    }

    @Override
    public void ReadServerRecord(NBTTagCompound TagCompound) {
        this.CheckSides();
    }

    public boolean IsStructureCarriage(BlockRecord Record) {
        Record.Identify(this.field_145850_b);
        return Record.entity instanceof TileEntityStructureCarriage;
    }

    @Override
    public void ToggleSide(int Side2, boolean Sneaking) {
        TileEntityStructureCarriage NextCarriage;
        Directions ActionDirection = Directions.values()[Side2];
        Directions PropagationDirection = ActionDirection.opposite();
        BlockRecord NextRecord = new BlockRecord(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        NextRecord.Shift(PropagationDirection);
        if (!this.IsStructureCarriage(NextRecord)) {
            return;
        }
        BlockRecord NextNextRecord = NextRecord.NextInDirection(PropagationDirection);
        while (true) {
            NextCarriage = (TileEntityStructureCarriage)NextRecord.entity;
            if (!this.IsStructureCarriage(NextNextRecord)) break;
            for (Directions Target2 : Directions.values()) {
                NextCarriage.SideClosed[Target2.ordinal()] = Target2 != PropagationDirection && Target2 != ActionDirection;
            }
            NextCarriage.CheckSides();
            NextCarriage.Propagate();
            NextRecord = NextNextRecord;
            NextNextRecord = NextRecord.NextInDirection(PropagationDirection);
        }
        NextCarriage.SideClosed[ActionDirection.ordinal()] = false;
        NextCarriage.SideClosed[PropagationDirection.ordinal()] = true;
        NextCarriage.CheckSides();
        NextCarriage.Propagate();
        this.SideClosed[ActionDirection.ordinal()] = true;
        this.SideClosed[PropagationDirection.ordinal()] = false;
        this.CheckSides();
        this.Propagate();
    }

    public TileEntityStructureCarriage FollowEdgeToCorner(EdgeTypes EdgeType, TileEntityStructureCarriage Origin, Directions Direction) throws CarriageMotionException {
        BlockRecord Record = new BlockRecord(Origin.field_145851_c, Origin.field_145848_d, Origin.field_145849_e);
        Record.Shift(Direction);
        while (this.IsStructureCarriage(Record)) {
            TileEntityStructureCarriage Carriage2 = (TileEntityStructureCarriage)Record.entity;
            if (Carriage2.CornerType != null) {
                return Carriage2;
            }
            if (Carriage2.EdgeType != EdgeType) {
                throw new CarriageMotionException("expected block at (" + Record.X + "," + Record.Y + "," + Record.Z + ") to be edge type " + EdgeType.name() + " of structure carriage");
            }
            Record = Record.NextInDirection(Direction);
        }
        throw new CarriageMotionException("expected corner of structure carriage at (" + Record.X + "," + Record.Y + "," + Record.Z + ")");
    }

    public TileEntityStructureCarriage FollowEdgeToCorner(EdgeTypes EdgeType, CornerTypes CornerType, TileEntityStructureCarriage Origin, Directions Direction) throws CarriageMotionException {
        TileEntityStructureCarriage Carriage2 = this.FollowEdgeToCorner(EdgeType, Origin, Direction);
        if (Carriage2.CornerType == CornerType) {
            return Carriage2;
        }
        throw new CarriageMotionException("expected " + CornerType.name() + " corner of structure carriage at (" + Carriage2.field_145851_c + "," + Carriage2.field_145848_d + "," + Carriage2.field_145849_e + ")");
    }

    public TileEntityStructureCarriage AssertCoordsMatch(TileEntityStructureCarriage A, TileEntityStructureCarriage B) throws CarriageMotionException {
        if (A.field_145851_c == B.field_145851_c && A.field_145848_d == B.field_145848_d && A.field_145849_e == B.field_145849_e) {
            return A;
        }
        throw new CarriageMotionException(Lang.translate((String)"JAKJ_RedstoneInMotion.badCuboid"));
    }

    public TileEntityStructureCarriage AssertCoordsMatch(TileEntityStructureCarriage A, TileEntityStructureCarriage B, TileEntityStructureCarriage C) throws CarriageMotionException {
        return this.AssertCoordsMatch(this.AssertCoordsMatch(A, B), C);
    }

    @Override
    public void fillPackage(CarriagePackage Package2) throws CarriageMotionException {
        int MaxZ;
        int MinZ;
        int MaxY;
        int MinY;
        int MaxX;
        int MinX;
        if (this.EdgeType != null) {
            this.FollowEdgeToCorner(this.EdgeType, this, this.EdgeType.Neg).fillPackage(Package2);
            return;
        }
        if (this.CornerType == null) {
            throw new CarriageMotionException(Lang.translate((String)"JAKJ_RedstoneInMotion.notEdgeAnchor"));
        }
        TileEntityStructureCarriage NextAlongX = this.FollowEdgeToCorner(EdgeTypes.X, this.CornerType.NextAlongAxisX(), this, this.CornerType.ToNextAlongX);
        TileEntityStructureCarriage NextAlongY = this.FollowEdgeToCorner(EdgeTypes.Y, this.CornerType.NextAlongAxisY(), this, this.CornerType.ToNextAlongY);
        TileEntityStructureCarriage NextAlongZ = this.FollowEdgeToCorner(EdgeTypes.Z, this.CornerType.NextAlongAxisZ(), this, this.CornerType.ToNextAlongZ);
        if (this.CornerType.ToNextAlongX == Directions.PosX) {
            MinX = this.field_145851_c;
            MaxX = NextAlongX.field_145851_c;
        } else {
            MinX = NextAlongX.field_145851_c;
            MaxX = this.field_145851_c;
        }
        if (this.CornerType.ToNextAlongY == Directions.PosY) {
            MinY = this.field_145848_d;
            MaxY = NextAlongY.field_145848_d;
        } else {
            MinY = NextAlongY.field_145848_d;
            MaxY = this.field_145848_d;
        }
        if (this.CornerType.ToNextAlongZ == Directions.PosZ) {
            MinZ = this.field_145849_e;
            MaxZ = NextAlongZ.field_145849_e;
        } else {
            MinZ = NextAlongZ.field_145849_e;
            MaxZ = this.field_145849_e;
        }
        TileEntityStructureCarriage NextAlongXY = this.AssertCoordsMatch(this.FollowEdgeToCorner(EdgeTypes.Y, this.CornerType.NextAlongPlaneXY(), NextAlongX, this.CornerType.ToNextAlongY), this.FollowEdgeToCorner(EdgeTypes.X, this.CornerType.NextAlongPlaneXY(), NextAlongY, this.CornerType.ToNextAlongX));
        TileEntityStructureCarriage NextAlongXZ = this.AssertCoordsMatch(this.FollowEdgeToCorner(EdgeTypes.Z, this.CornerType.NextAlongPlaneXZ(), NextAlongX, this.CornerType.ToNextAlongZ), this.FollowEdgeToCorner(EdgeTypes.X, this.CornerType.NextAlongPlaneXZ(), NextAlongZ, this.CornerType.ToNextAlongX));
        TileEntityStructureCarriage NextAlongYZ = this.AssertCoordsMatch(this.FollowEdgeToCorner(EdgeTypes.Y, this.CornerType.NextAlongPlaneYZ(), NextAlongZ, this.CornerType.ToNextAlongY), this.FollowEdgeToCorner(EdgeTypes.Z, this.CornerType.NextAlongPlaneYZ(), NextAlongY, this.CornerType.ToNextAlongZ));
        TileEntityStructureCarriage Opposite = this.AssertCoordsMatch(this.FollowEdgeToCorner(EdgeTypes.Z, this.CornerType.Opposite(), NextAlongXY, this.CornerType.ToNextAlongZ), this.FollowEdgeToCorner(EdgeTypes.Y, this.CornerType.Opposite(), NextAlongXZ, this.CornerType.ToNextAlongY), this.FollowEdgeToCorner(EdgeTypes.X, this.CornerType.Opposite(), NextAlongYZ, this.CornerType.ToNextAlongX));
        for (int X = MinX; X <= MaxX; ++X) {
            for (int Y = MinY; Y <= MaxY; ++Y) {
                for (int Z = MinZ; Z <= MaxZ; ++Z) {
                    if (this.field_145850_b.func_147437_c(X, Y, Z)) continue;
                    BlockRecord Record = new BlockRecord(X, Y, Z);
                    Record.Identify(this.field_145850_b);
                    Package2.AddBlock(Record);
                    if (!(X == MinX && Package2.MotionDirection == Directions.NegX || X == MaxX && Package2.MotionDirection == Directions.PosX || Y == MinY && Package2.MotionDirection == Directions.NegY || Y == MaxY && Package2.MotionDirection == Directions.PosY || Z == MinZ && Package2.MotionDirection == Directions.NegZ) && (Z != MaxZ || Package2.MotionDirection != Directions.PosZ)) continue;
                    Package2.AddPotentialObstruction(Record.NextInDirection(Package2.MotionDirection));
                }
            }
        }
    }

    public String toString() {
        String str = "StructureCarriage ";
        for (Field f : this.getClass().getFields()) {
            try {
                str = str + f.getName() + "=" + f.get(this) + ", ";
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return str;
    }

    @Override
    public void rotateSpecial(ForgeDirection axis) {
        this.CheckSides();
        this.Propagate();
    }

    public static enum CornerTypes {
        NegX_NegY_NegZ(Directions.PosX, Directions.PosY, Directions.PosZ),
        PosX_NegY_NegZ(Directions.NegX, Directions.PosY, Directions.PosZ),
        NegX_PosY_NegZ(Directions.PosX, Directions.NegY, Directions.PosZ),
        PosX_PosY_NegZ(Directions.NegX, Directions.NegY, Directions.PosZ),
        NegX_NegY_PosZ(Directions.PosX, Directions.PosY, Directions.NegZ),
        PosX_NegY_PosZ(Directions.NegX, Directions.PosY, Directions.NegZ),
        NegX_PosY_PosZ(Directions.PosX, Directions.NegY, Directions.NegZ),
        PosX_PosY_PosZ(Directions.NegX, Directions.NegY, Directions.NegZ);

        public Directions ToNextAlongX;
        public Directions ToNextAlongY;
        public Directions ToNextAlongZ;

        private CornerTypes(Directions ToNextAlongX, Directions ToNextAlongY, Directions ToNextAlongZ) {
            this.ToNextAlongX = ToNextAlongX;
            this.ToNextAlongY = ToNextAlongY;
            this.ToNextAlongZ = ToNextAlongZ;
        }

        public CornerTypes NextAlongAxisX() {
            return CornerTypes.values()[this.ordinal() ^ 1];
        }

        public CornerTypes NextAlongAxisY() {
            return CornerTypes.values()[this.ordinal() ^ 2];
        }

        public CornerTypes NextAlongAxisZ() {
            return CornerTypes.values()[this.ordinal() ^ 4];
        }

        public CornerTypes NextAlongPlaneXY() {
            return CornerTypes.values()[this.ordinal() ^ 3];
        }

        public CornerTypes NextAlongPlaneXZ() {
            return CornerTypes.values()[this.ordinal() ^ 5];
        }

        public CornerTypes NextAlongPlaneYZ() {
            return CornerTypes.values()[this.ordinal() ^ 6];
        }

        public CornerTypes Opposite() {
            return CornerTypes.values()[this.ordinal() ^ 7];
        }
    }

    public static enum EdgeTypes {
        X(Directions.NegX, Directions.PosX),
        Y(Directions.NegY, Directions.PosY),
        Z(Directions.NegZ, Directions.PosZ);

        public Directions Neg;
        public Directions Pos;

        private EdgeTypes(Directions Neg, Directions Pos) {
            this.Neg = Neg;
            this.Pos = Pos;
        }
    }
}

