/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.FTBLib;
import ftb.lib.api.block.IBlockLM;
import ftb.lib.api.item.IItemLM;
import ftb.lib.api.recipes.LMRecipes;
import ftb.lib.api.tile.TileLM;
import ftb.lib.mod.FTBLibMod;
import java.util.ArrayList;
import java.util.List;
import latmod.lib.util.FinalIDObject;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class LMMod
extends FinalIDObject {
    public final String lowerCaseModID;
    private ModContainer modContainer;
    public final List<IItemLM> itemsAndBlocks;
    public LMRecipes recipes;

    public static LMMod create(String s) {
        LMMod mod = new LMMod(s);
        if (FTBLib.DEV_ENV) {
            FTBLib.dev_logger.info("LMMod '" + mod.getID() + "' created");
        }
        return mod;
    }

    public LMMod(String id) {
        super(id);
        this.lowerCaseModID = id.toLowerCase();
        this.itemsAndBlocks = new ArrayList<IItemLM>();
        this.recipes = LMRecipes.defaultInstance;
    }

    public ModContainer getModContainer() {
        if (this.modContainer == null) {
            this.modContainer = (ModContainer)Loader.instance().getModObjectList().inverse().get((Object)this.getID());
        }
        return this.modContainer;
    }

    public void setRecipes(LMRecipes r) {
        this.recipes = r == null ? new LMRecipes() : r;
    }

    public String toFullID() {
        return this.getID() + '-' + "1.7.10" + '-' + this.modContainer.getDisplayVersion();
    }

    public CreativeTabs createTab(String s, final ItemStack icon) {
        CreativeTabs tab = new CreativeTabs(this.lowerCaseModID + '.' + s){

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_151244_d() {
                return icon;
            }

            @SideOnly(value=Side.CLIENT)
            public Item func_78016_d() {
                return this.func_151244_d().func_77973_b();
            }

            @SideOnly(value=Side.CLIENT)
            public void func_78018_a(List l) {
                for (IItemLM i : LMMod.this.itemsAndBlocks) {
                    Item item = i.getItem();
                    if (item.func_77640_w() != this) continue;
                    item.func_150895_a(item, (CreativeTabs)this, l);
                }
            }
        };
        return tab;
    }

    public String getBlockName(String s) {
        return this.lowerCaseModID + ".tile." + s;
    }

    public String getItemName(String s) {
        return this.lowerCaseModID + ".item." + s;
    }

    public String translate(String s, Object ... args) {
        return FTBLibMod.proxy.translate(this.lowerCaseModID + '.' + s, args);
    }

    public void addItem(IItemLM ... ai) {
        for (IItemLM i : ai) {
            if (i instanceof IBlockLM) {
                FTBLib.addBlock((Block)i, ((IBlockLM)i).getItemBlock(), i.getItemID());
            } else {
                FTBLib.addItem(i.getItem(), i.getItemID());
            }
            this.itemsAndBlocks.add(i);
        }
    }

    public void addTile(Class<? extends TileLM> c, String s, String ... alt) {
        FTBLib.addTileEntity(c, this.getID() + '.' + s, alt);
    }

    public void addEntity(Class<? extends Entity> c, String s, int id) {
        FTBLib.addEntity(c, s, id, this.getID());
    }

    public void onPostLoaded() {
        for (IItemLM i : this.itemsAndBlocks) {
            i.onPostLoaded();
        }
    }

    public void loadRecipes() {
        for (IItemLM i : this.itemsAndBlocks) {
            i.loadRecipes();
        }
    }

    public IChatComponent chatComponent(String s, Object ... obj) {
        return new ChatComponentTranslation(this.lowerCaseModID + '.' + s, obj);
    }
}

