/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.world;

import cofh.api.world.IFeatureGenerator;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import shukaro.artifice.ArtificeBlocks;
import shukaro.artifice.ArtificeRegistry;
import shukaro.artifice.block.world.BlockOre;
import shukaro.artifice.util.NameMetaPair;

public class WorldGenLayer
implements IFeatureGenerator {
    private Block block;
    private int meta;
    private Set<NameMetaPair> replaced;
    private int minHeight;
    private int maxHeight;

    public WorldGenLayer(Block block, int meta, int minHeight, int maxHeight) {
        this.block = block;
        this.meta = meta;
        this.replaced = ArtificeRegistry.getStoneTypes();
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
    }

    public String getFeatureName() {
        return "Artifice: " + this.block.func_149739_a() + "@" + this.meta + " Layers";
    }

    public boolean generateFeature(Random rand, int chunkX, int chunkZ, World world, boolean newGen) {
        int dim = world.field_73011_w.field_76574_g;
        if (ArtificeRegistry.getDimensionBlacklist().contains(dim)) {
            return false;
        }
        String worldType = world.field_73011_w.field_76577_b.func_77127_a();
        if (ArtificeRegistry.getWorldTypeBlacklist().contains(worldType)) {
            return false;
        }
        int x = chunkX * 16;
        int z = chunkZ * 16;
        int xMax = x + 16;
        int zMax = z + 16;
        for (int i = x; i < xMax; ++i) {
            for (int j = z; j < zMax; ++j) {
                int min = this.minHeight + (rand.nextInt(3) - rand.nextInt(3));
                int max = this.maxHeight + (rand.nextInt(3) - rand.nextInt(3));
                if (min < 0) {
                    min = 0;
                }
                if (max > 256) {
                    max = 256;
                }
                for (int t = min; t < max; ++t) {
                    NameMetaPair newOre;
                    NameMetaPair pair = new NameMetaPair(world.func_147439_a(i, t, j), world.func_72805_g(i, t, j));
                    if (!this.replaced.contains(pair) && !ArtificeBlocks.oreSet.contains(pair)) continue;
                    NameMetaPair ore = new NameMetaPair(world.func_147439_a(i, t, j), world.func_72805_g(i, t, j));
                    if (this.replaced.contains(ore)) {
                        world.func_147465_d(i, t, j, this.block, this.meta, 0);
                        continue;
                    }
                    if (!ArtificeBlocks.oreSet.contains(ore) || (newOre = BlockOre.getOre(ore, this.block)) == null) continue;
                    world.func_147465_d(i, t, j, newOre.getBlock(), newOre.getMetadata(), 0);
                }
            }
        }
        return true;
    }
}

