/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.compat;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import cpw.mods.fml.common.event.FMLInterModComms;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import shukaro.artifice.ArtificeCore;
import shukaro.artifice.ArtificeRegistry;

public class IMC {
    public static void processIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage m : event.getMessages()) {
            if (m.key.equals("register-marble")) {
                IMC.processMarbleIMC(event, m);
                continue;
            }
            if (m.key.equals("register-basalt")) {
                IMC.processBasaltIMC(event, m);
                continue;
            }
            if (m.key.equals("register-dim-blacklist")) {
                IMC.processDimBlacklistIMC(event, m);
                continue;
            }
            if (m.key.equals("register-stone")) {
                IMC.processStoneIMC(event, m);
                continue;
            }
            if (m.key.equals("register-worldtype-blacklist")) {
                IMC.processWorldTypeIMC(event, m);
                continue;
            }
            ArtificeCore.logger.warn(String.format("Received IMC message with unknown key('%s') from %s!", m.key, m.getSender()));
        }
    }

    private static void processMarbleIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage m) {
        try {
            if (m.isStringMessage()) {
                Splitter splitter = Splitter.on((String)"@").trimResults();
                String[] array = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)m.getStringValue()), String.class);
                if (array.length != 2) {
                    ArtificeCore.logger.info(String.format("Received an invalid marble registration request %s from mod %s", m.getStringValue(), m.getSender()));
                } else {
                    String name = array[0];
                    Integer meta = Ints.tryParse((String)array[1]);
                    Block block = (Block)Block.field_149771_c.func_82594_a(name);
                    if (Strings.isNullOrEmpty((String)name) || meta == null || block == null) {
                        ArtificeCore.logger.info(String.format("Received an invalid marble registration request %s from mod %s", m.getStringValue(), m.getSender()));
                    } else {
                        ArtificeRegistry.registerMarbleType(new ItemStack(block, 1, meta.intValue()));
                    }
                }
            } else if (m.isItemStackMessage()) {
                ItemStack stack = m.getItemStackValue();
                Block block = Block.func_149634_a((Item)stack.func_77973_b());
                if (block == null) {
                    ArtificeCore.logger.info(String.format("Received an invalid marble registration request %s from mod %s", m.getItemStackValue(), m.getSender()));
                } else {
                    ArtificeRegistry.registerMarbleType(stack);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void processBasaltIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage m) {
        try {
            if (m.isStringMessage()) {
                Splitter splitter = Splitter.on((String)"@").trimResults();
                String[] array = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)m.getStringValue()), String.class);
                if (array.length != 2) {
                    ArtificeCore.logger.info(String.format("Received an invalid basalt registration request %s from mod %s", m.getStringValue(), m.getSender()));
                } else {
                    String name = array[0];
                    Integer meta = Ints.tryParse((String)array[1]);
                    Block block = (Block)Block.field_149771_c.func_82594_a(name);
                    if (Strings.isNullOrEmpty((String)name) || meta == null || block == null) {
                        ArtificeCore.logger.info(String.format("Received an invalid basalt registration request %s from mod %s", m.getStringValue(), m.getSender()));
                    } else {
                        ArtificeRegistry.registerBasaltType(new ItemStack(block, 1, meta.intValue()));
                    }
                }
            } else if (m.isItemStackMessage()) {
                ItemStack stack = m.getItemStackValue();
                Block block = Block.func_149634_a((Item)stack.func_77973_b());
                if (block == null) {
                    ArtificeCore.logger.info(String.format("Received an invalid basalt registration request %s from mod %s", m.getItemStackValue(), m.getSender()));
                } else {
                    ArtificeRegistry.registerBasaltType(stack);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void processDimBlacklistIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage m) {
        try {
            if (m.isStringMessage()) {
                Integer id = Ints.tryParse((String)m.getStringValue());
                if (id == null) {
                    ArtificeCore.logger.info(String.format("Received an invalid dimension blacklist registration request %s from mod %s", m.getStringValue(), m.getSender()));
                } else {
                    ArtificeRegistry.registerDimensionBlacklist(id);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void processStoneIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage m) {
        try {
            if (m.isStringMessage()) {
                Splitter splitter = Splitter.on((String)"@").trimResults();
                String[] array = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)m.getStringValue()), String.class);
                if (array.length != 2) {
                    ArtificeCore.logger.info(String.format("Received an invalid stone registration request %s from mod %s", m.getStringValue(), m.getSender()));
                } else {
                    String name = array[0];
                    Integer meta = Ints.tryParse((String)array[1]);
                    if (Strings.isNullOrEmpty((String)name) || meta == null) {
                        ArtificeCore.logger.info(String.format("Received an invalid stone registration request %s from mod %s", m.getStringValue(), m.getSender()));
                    } else {
                        Block block = (Block)Block.field_149771_c.func_82594_a(name);
                        ArtificeRegistry.registerStoneType(block, meta);
                    }
                }
            } else if (m.isItemStackMessage()) {
                Block block = Block.func_149634_a((Item)m.getItemStackValue().func_77973_b());
                if (block == null) {
                    ArtificeCore.logger.info(String.format("Received an invalid stone registration request %s from mod %s", m.getItemStackValue(), m.getSender()));
                } else {
                    ArtificeRegistry.registerStoneType(block, m.getItemStackValue().func_77960_j());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void processWorldTypeIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage m) {
        try {
            if (m.isStringMessage()) {
                ArtificeRegistry.registerWorldTypeBlacklist(m.getStringValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

