/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice;

import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import shukaro.artifice.ArtificeBlocks;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.ArtificeItems;
import shukaro.artifice.ArtificeRegistry;
import shukaro.artifice.recipe.EnumUpgrades;
import shukaro.artifice.util.FormatCodes;
import shukaro.artifice.util.RomanUtil;

public class ArtificeTooltips {
    public static final String commentCode = FormatCodes.DarkGrey.code + FormatCodes.Italic.code;

    public static String localizeTooltip(String name, Boolean flavor) {
        return flavor != false ? commentCode + StatCollector.func_74838_a((String)("tooltip.artifice." + name + ".flavor")) : StatCollector.func_74838_a((String)("tooltip.artifice." + name));
    }

    public static void initTooltips() {
        ArtificeTooltips.initBlockTooltips();
        ArtificeTooltips.initItemTooltips();
    }

    private static void initItemTooltips() {
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemResource, 1, 0), ArtificeTooltips.localizeTooltip("sulfur", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemResource, 1, 1), ArtificeTooltips.localizeTooltip("niter", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemResource, 1, 2), ArtificeTooltips.localizeTooltip("enderdust", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemDye, 1, 0), ArtificeTooltips.localizeTooltip("dye.blue", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemDye, 1, 0), ArtificeTooltips.localizeTooltip("dye.blue", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemDye, 1, 1), ArtificeTooltips.localizeTooltip("dye.black", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemDye, 1, 1), ArtificeTooltips.localizeTooltip("dye.black", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemDye, 1, 2), ArtificeTooltips.localizeTooltip("dye.brown", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemDye, 1, 2), ArtificeTooltips.localizeTooltip("dye.brown", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemDye, 1, 3), ArtificeTooltips.localizeTooltip("dye.white", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemDye, 1, 3), ArtificeTooltips.localizeTooltip("dye.white", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSledgeWood, 1, 0), ArtificeTooltips.localizeTooltip("sledge", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSledgeWood, 1, 0), FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("sledge.loss", false) + FormatCodes.Reset.code + FormatCodes.Aqua.code + " 50%");
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSledgeWood, 1, 0), ArtificeTooltips.localizeTooltip("sledge", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSledgeStone, 1, 0), ArtificeTooltips.localizeTooltip("sledge", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSledgeStone, 1, 0), FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("sledge.loss", false) + FormatCodes.Reset.code + FormatCodes.Aqua.code + " 40%");
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSledgeStone, 1, 0), ArtificeTooltips.localizeTooltip("sledge", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSledgeIron, 1, 0), ArtificeTooltips.localizeTooltip("sledge", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSledgeIron, 1, 0), FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("sledge.loss", false) + FormatCodes.Reset.code + FormatCodes.Aqua.code + " 30%");
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSledgeIron, 1, 0), ArtificeTooltips.localizeTooltip("sledge", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSledgeGold, 1, 0), ArtificeTooltips.localizeTooltip("sledge", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSledgeGold, 1, 0), FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("sledge.loss", false) + FormatCodes.Reset.code + FormatCodes.Aqua.code + " 25%");
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSledgeGold, 1, 0), ArtificeTooltips.localizeTooltip("sledge", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSledgeDiamond, 1, 0), ArtificeTooltips.localizeTooltip("sledge", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSledgeDiamond, 1, 0), FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("sledge.loss", false) + FormatCodes.Reset.code + FormatCodes.Aqua.code + " 20%");
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSledgeDiamond, 1, 0), ArtificeTooltips.localizeTooltip("sledge", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSickleWood, 1, 0), ArtificeTooltips.localizeTooltip("sickle", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSickleWood, 1, 0), FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("sickle.radius", false) + FormatCodes.Reset.code + FormatCodes.Aqua.code + " 1");
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSickleWood, 1, 0), ArtificeTooltips.localizeTooltip("sickle.wood", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSickleStone, 1, 0), ArtificeTooltips.localizeTooltip("sickle", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSickleStone, 1, 0), FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("sickle.radius", false) + FormatCodes.Reset.code + FormatCodes.Aqua.code + " 2");
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSickleStone, 1, 0), ArtificeTooltips.localizeTooltip("sickle.stone", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSickleIron, 1, 0), ArtificeTooltips.localizeTooltip("sickle", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSickleIron, 1, 0), FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("sickle.radius", false) + FormatCodes.Reset.code + FormatCodes.Aqua.code + " 3");
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSickleIron, 1, 0), ArtificeTooltips.localizeTooltip("sickle.iron", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSickleGold, 1, 0), ArtificeTooltips.localizeTooltip("sickle", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSickleGold, 1, 0), FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("sickle.radius", false) + FormatCodes.Reset.code + FormatCodes.Aqua.code + " 4");
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSickleGold, 1, 0), ArtificeTooltips.localizeTooltip("sickle.gold", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSickleDiamond, 1, 0), ArtificeTooltips.localizeTooltip("sickle", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSickleDiamond, 1, 0), FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("sickle.radius", false) + FormatCodes.Reset.code + FormatCodes.Aqua.code + " 5");
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSickleDiamond, 1, 0), ArtificeTooltips.localizeTooltip("sickle.diamond", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSteelIngot, 1, 0), ArtificeTooltips.localizeTooltip("steel.ingot", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSteelIngot, 1, 0), ArtificeTooltips.localizeTooltip("steel.ingot", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSteelIngot, 1, 1), ArtificeTooltips.localizeTooltip("steel.dust", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemSteelIngot, 1, 1), ArtificeTooltips.localizeTooltip("steel.dust", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemNugget, 1, 0), ArtificeTooltips.localizeTooltip("nugget.copper", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemNugget, 1, 1), ArtificeTooltips.localizeTooltip("nugget.silver", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemNugget, 1, 2), ArtificeTooltips.localizeTooltip("nugget.platinum", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemCoin, 1, 0), ArtificeTooltips.localizeTooltip("coin.copper", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemCoin, 1, 0), ArtificeTooltips.localizeTooltip("coin.copper", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemCoin, 1, 1), ArtificeTooltips.localizeTooltip("coin.silver", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemCoin, 1, 1), ArtificeTooltips.localizeTooltip("coin.silver", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemCoin, 1, 2), ArtificeTooltips.localizeTooltip("coin.gold", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemCoin, 1, 2), ArtificeTooltips.localizeTooltip("coin.gold", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemCoin, 1, 3), ArtificeTooltips.localizeTooltip("coin.platinum", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemCoin, 1, 3), ArtificeTooltips.localizeTooltip("coin.platinum", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemBox, 1, 0), ArtificeTooltips.localizeTooltip("box", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemBox, 1, 0), ArtificeTooltips.localizeTooltip("box", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 0), ArtificeTooltips.localizeTooltip("upgrade.type.toolweapon", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 0), FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_77349_p.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades ? RomanUtil.convertToRoman(EnumUpgrades.SharpeningKitS.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_77338_j.func_77325_b())) + ")");
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 0), FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_77338_j.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades ? RomanUtil.convertToRoman(EnumUpgrades.SharpeningKitE.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_77349_p.func_77325_b())) + ")");
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 0), ArtificeTooltips.localizeTooltip("upgrade.sharpener", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 1), ArtificeTooltips.localizeTooltip("upgrade.type.universal", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 1), FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_77347_r.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades ? RomanUtil.convertToRoman(EnumUpgrades.Reinforcement.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_77347_r.func_77325_b())) + ")");
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 1), ArtificeTooltips.localizeTooltip("upgrade.reinforcement", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 2), ArtificeTooltips.localizeTooltip("upgrade.type.bow", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 2), FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_77344_u.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades ? RomanUtil.convertToRoman(EnumUpgrades.ReinforcedLimbs.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_77344_u.func_77325_b())) + ")");
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 2), ArtificeTooltips.localizeTooltip("upgrade.reinforcedlimbs", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 3), ArtificeTooltips.localizeTooltip("upgrade.type.bow", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 3), FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_77345_t.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades ? RomanUtil.convertToRoman(EnumUpgrades.PlaitedString.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_77345_t.func_77325_b())) + ")");
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 3), ArtificeTooltips.localizeTooltip("upgrade.plaited", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 4), ArtificeTooltips.localizeTooltip("upgrade.type.weapon", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 4), FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_77337_m.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades ? RomanUtil.convertToRoman(EnumUpgrades.Counterweight.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_77337_m.func_77325_b())) + ")");
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 4), ArtificeTooltips.localizeTooltip("upgrade.counterweight", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 5), ArtificeTooltips.localizeTooltip("upgrade.type.armor", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 5), FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_92091_k.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades ? RomanUtil.convertToRoman(EnumUpgrades.ArmorSpikes.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_92091_k.func_77325_b())) + ")");
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 5), ArtificeTooltips.localizeTooltip("upgrade.spikes", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 6), ArtificeTooltips.localizeTooltip("upgrade.type.armor", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 6), FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_77332_c.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades ? RomanUtil.convertToRoman(EnumUpgrades.LaminatedPadding.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_77332_c.func_77325_b())) + ")");
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 6), ArtificeTooltips.localizeTooltip("upgrade.lamination", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 7), ArtificeTooltips.localizeTooltip("upgrade.type.armor", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 7), FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_77328_g.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades ? RomanUtil.convertToRoman(EnumUpgrades.QuiltedCover.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_77328_g.func_77325_b())) + ")");
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 7), ArtificeTooltips.localizeTooltip("upgrade.cover", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 8), ArtificeTooltips.localizeTooltip("upgrade.type.boot", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 8), FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_77330_e.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades ? RomanUtil.convertToRoman(EnumUpgrades.ElasticSoles.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_77330_e.func_77325_b())) + ")");
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 8), ArtificeTooltips.localizeTooltip("upgrade.soles", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 9), ArtificeTooltips.localizeTooltip("upgrade.type.armor", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 9), FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_77329_d.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades ? RomanUtil.convertToRoman(EnumUpgrades.Firedamp.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_77329_d.func_77325_b())) + ")");
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 9), ArtificeTooltips.localizeTooltip("upgrade.firedamp", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 10), ArtificeTooltips.localizeTooltip("upgrade.type.armor", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 10), FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_77327_f.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades ? RomanUtil.convertToRoman(EnumUpgrades.ElasticLayering.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_77327_f.func_77325_b())) + ")");
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 10), ArtificeTooltips.localizeTooltip("upgrade.layering", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 11), ArtificeTooltips.localizeTooltip("upgrade.type.helmet", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 11), FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_77340_h.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades ? RomanUtil.convertToRoman(EnumUpgrades.ScubaTank.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_77340_h.func_77325_b())) + ")");
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 11), ArtificeTooltips.localizeTooltip("upgrade.tank", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 12), ArtificeTooltips.localizeTooltip("upgrade.type.helmet", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 12), FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_77341_i.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades ? RomanUtil.convertToRoman(EnumUpgrades.DiveKit.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_77341_i.func_77325_b())) + ")");
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 12), ArtificeTooltips.localizeTooltip("upgrade.divekit", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemBucket, 1, 0), ArtificeTooltips.localizeTooltip("flammable", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemBucket, 1, 0), ArtificeTooltips.localizeTooltip("bucket.oil", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemBucket, 1, 1), ArtificeTooltips.localizeTooltip("explosive", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemBucket, 1, 1), ArtificeTooltips.localizeTooltip("bucket.fuel", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemBucket, 1, 2), ArtificeTooltips.localizeTooltip("flammable", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemBucket, 1, 2), ArtificeTooltips.localizeTooltip("bucket.creosote", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemBucket, 1, 3), ArtificeTooltips.localizeTooltip("flammable", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemBucket, 1, 3), ArtificeTooltips.localizeTooltip("bucket.bitumen", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemCraftKit, 1, 0), ArtificeTooltips.localizeTooltip("craftkit", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemCraftKit, 1, 0), ArtificeTooltips.localizeTooltip("craftkit", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Item)ArtificeItems.itemResource, 1, 3), ArtificeTooltips.localizeTooltip("radioactive", false));
    }

    private static void initBlockTooltips() {
        int i;
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockSulfur, 1, 1), ArtificeTooltips.localizeTooltip("sulfur", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockNiter, 1, 1), ArtificeTooltips.localizeTooltip("niter", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockFlora, 1, 3), ArtificeTooltips.localizeTooltip("lotus", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockFlora, 1, 3), ArtificeTooltips.localizeTooltip("lotus.close", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockFlora, 1, 3), ArtificeTooltips.localizeTooltip("lotus", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockLotus, 1, 0), ArtificeTooltips.localizeTooltip("lotus.close", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockLotus, 1, 0), ArtificeTooltips.localizeTooltip("lily", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockFlora, 1, 0), ArtificeTooltips.localizeTooltip("bluebell", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockFlora, 1, 0), ArtificeTooltips.localizeTooltip("bluebell", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockFlora, 1, 1), ArtificeTooltips.localizeTooltip("orchid", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockFlora, 1, 1), ArtificeTooltips.localizeTooltip("orchid", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockFlora, 1, 2), ArtificeTooltips.localizeTooltip("iris", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockFlora, 1, 2), ArtificeTooltips.localizeTooltip("iris", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockBasalt, 1, 3), ArtificeTooltips.localizeTooltip("connected", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockMarble, 1, 3), ArtificeTooltips.localizeTooltip("connected", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockBasalt, 1, 4), ArtificeTooltips.localizeTooltip("connected", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockMarble, 1, 4), ArtificeTooltips.localizeTooltip("connected", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockBasaltSlab, 1, 2), ArtificeTooltips.localizeTooltip("connected", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockMarbleSlab, 1, 2), ArtificeTooltips.localizeTooltip("connected", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockBasaltSlab, 1, 3), ArtificeTooltips.localizeTooltip("connected", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockMarbleSlab, 1, 3), ArtificeTooltips.localizeTooltip("connected", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockBasalt, 1, 0), ArtificeTooltips.localizeTooltip("volcanic", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockBasalt, 1, 1), ArtificeTooltips.localizeTooltip("volcanic", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockMarble, 1, 0), ArtificeTooltips.localizeTooltip("metamorphic", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockMarble, 1, 1), ArtificeTooltips.localizeTooltip("metamorphic", false));
        for (i = 0; i < ArtificeBlocks.blockLimestones.length; ++i) {
            ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockLimestones[i], 1, 0), ArtificeTooltips.localizeTooltip("sedimentary", false));
            ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockLimestones[i], 1, 1), ArtificeTooltips.localizeTooltip("sedimentary", false));
            ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockLimestones[i], 1, 3), ArtificeTooltips.localizeTooltip("connected", false));
            ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockLimestones[i], 1, 4), ArtificeTooltips.localizeTooltip("connected", false));
            ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockLimestoneSlabs[i], 1, 2), ArtificeTooltips.localizeTooltip("connected", false));
            ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockLimestoneSlabs[i], 1, 3), ArtificeTooltips.localizeTooltip("connected", false));
        }
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockDetector, 1, 0), ArtificeTooltips.localizeTooltip("detector", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockDetector, 1, 0), ArtificeTooltips.localizeTooltip("detector", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockFrame, 1, 0), ArtificeTooltips.localizeTooltip("frame.basic", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockFrame, 1, 0), ArtificeTooltips.localizeTooltip("frame.basic", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockFrame, 1, 1), ArtificeTooltips.localizeTooltip("frame.reinforced", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockFrame, 1, 1), ArtificeTooltips.localizeTooltip("frame.reinforced", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockFrame, 1, 2), ArtificeTooltips.localizeTooltip("frame.industrial", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockFrame, 1, 2), ArtificeTooltips.localizeTooltip("frame.industrial", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockFrame, 1, 3), ArtificeTooltips.localizeTooltip("frame.advanced", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockFrame, 1, 3), ArtificeTooltips.localizeTooltip("frame.advanced", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockGlassWall, 1, 0), ArtificeTooltips.localizeTooltip("glasswall.basic", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockGlassWall, 1, 0), FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("resistance", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + (int)ArtificeBlocks.blockGlassWall.getResistance(0));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockGlassWall, 1, 0), ArtificeTooltips.localizeTooltip("glasswall.basic", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockGlassWall, 1, 1), ArtificeTooltips.localizeTooltip("glasswall.reinforced", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockGlassWall, 1, 1), FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("resistance", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + (int)ArtificeBlocks.blockGlassWall.getResistance(1));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockGlassWall, 1, 1), ArtificeTooltips.localizeTooltip("glasswall.reinforced", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockGlassWall, 1, 2), ArtificeTooltips.localizeTooltip("glasswall.industrial", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockGlassWall, 1, 2), FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("resistance", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + (int)ArtificeBlocks.blockGlassWall.getResistance(2));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockGlassWall, 1, 2), ArtificeTooltips.localizeTooltip("glasswall.industrial", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockGlassWall, 1, 3), ArtificeTooltips.localizeTooltip("glasswall.advanced", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockGlassWall, 1, 3), FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("resistance", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + (int)ArtificeBlocks.blockGlassWall.getResistance(3));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockGlassWall, 1, 3), ArtificeTooltips.localizeTooltip("glasswall.advanced", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockGlassWallDark, 1, 0), ArtificeTooltips.localizeTooltip("glasswall.basic", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockGlassWallDark, 1, 0), FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("resistance", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + (int)ArtificeBlocks.blockGlassWall.getResistance(0));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockGlassWallDark, 1, 0), ArtificeTooltips.localizeTooltip("glasswall.basic", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockGlassWallDark, 1, 1), ArtificeTooltips.localizeTooltip("glasswall.reinforced", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockGlassWallDark, 1, 1), FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("resistance", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + (int)ArtificeBlocks.blockGlassWall.getResistance(1));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockGlassWallDark, 1, 1), ArtificeTooltips.localizeTooltip("glasswall.reinforced", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockGlassWallDark, 1, 2), ArtificeTooltips.localizeTooltip("glasswall.industrial", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockGlassWallDark, 1, 2), FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("resistance", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + (int)ArtificeBlocks.blockGlassWall.getResistance(2));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockGlassWallDark, 1, 2), ArtificeTooltips.localizeTooltip("glasswall.industrial", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockGlassWallDark, 1, 3), ArtificeTooltips.localizeTooltip("glasswall.advanced", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockGlassWallDark, 1, 3), FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("resistance", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + (int)ArtificeBlocks.blockGlassWall.getResistance(3));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockGlassWallDark, 1, 3), ArtificeTooltips.localizeTooltip("glasswall.advanced", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockReinforced, 1, 0), ArtificeTooltips.localizeTooltip("blastwall.basic", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockReinforced, 1, 0), FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("resistance", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + (int)ArtificeBlocks.blockReinforced.getResistance(0));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockReinforced, 1, 0), ArtificeTooltips.localizeTooltip("blastwall.basic", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockReinforced, 1, 1), ArtificeTooltips.localizeTooltip("blastwall.reinforced", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockReinforced, 1, 1), FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("resistance", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + (int)ArtificeBlocks.blockReinforced.getResistance(1));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockReinforced, 1, 1), ArtificeTooltips.localizeTooltip("blastwall.reinforced", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockReinforced, 1, 2), ArtificeTooltips.localizeTooltip("blastwall.industrial", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockReinforced, 1, 2), FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("resistance", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + (int)ArtificeBlocks.blockReinforced.getResistance(2));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockReinforced, 1, 2), ArtificeTooltips.localizeTooltip("blastwall.industrial", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockReinforced, 1, 3), ArtificeTooltips.localizeTooltip("blastwall.advanced", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockReinforced, 1, 3), FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("resistance", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + (int)ArtificeBlocks.blockReinforced.getResistance(3));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockReinforced, 1, 3), ArtificeTooltips.localizeTooltip("blastwall.advanced", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockScaffold, 1, 0), ArtificeTooltips.localizeTooltip("scaffold.basic", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockScaffold, 1, 0), FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("overhang", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + ArtificeBlocks.blockScaffold.getOverhang(0));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockScaffold, 1, 0), ArtificeTooltips.localizeTooltip("scaffold.basic", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockScaffold, 1, 1), ArtificeTooltips.localizeTooltip("scaffold.reinforced", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockScaffold, 1, 1), FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("overhang", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + ArtificeBlocks.blockScaffold.getOverhang(1));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockScaffold, 1, 1), ArtificeTooltips.localizeTooltip("scaffold.reinforced", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockScaffold, 1, 2), ArtificeTooltips.localizeTooltip("scaffold.industrial", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockScaffold, 1, 2), FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("overhang", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + ArtificeBlocks.blockScaffold.getOverhang(2));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockScaffold, 1, 2), ArtificeTooltips.localizeTooltip("scaffold.industrial", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockScaffold, 1, 3), ArtificeTooltips.localizeTooltip("scaffold.advanced", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockScaffold, 1, 3), FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("overhang", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + ArtificeBlocks.blockScaffold.getOverhang(3));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockScaffold, 1, 3), ArtificeTooltips.localizeTooltip("scaffold.advanced", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockSteel, 1, 0), ArtificeTooltips.localizeTooltip("steel.ingot", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockSteel, 1, 0), ArtificeTooltips.localizeTooltip("steel.ingot", true));
        for (i = 0; i < 16; ++i) {
            ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockLamps[i], 1, 0), ArtificeTooltips.localizeTooltip("lamp", false));
            ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockLamps[i], 1, 0), ArtificeTooltips.localizeTooltip("lamp", true));
            ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockLampsInverted[i], 1, 0), ArtificeTooltips.localizeTooltip("lamp", false));
            ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockLampsInverted[i], 1, 0), ArtificeTooltips.localizeTooltip("lamp", true));
        }
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockGlowSand, 1, 0), ArtificeTooltips.localizeTooltip("glowsand", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockGlowSand, 1, 1), ArtificeTooltips.localizeTooltip("glowsand", true));
        for (i = 0; i < 16; ++i) {
            ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockColoredTorches[i], 1, 0), ArtificeTooltips.localizeTooltip("coloredtorch", true));
        }
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockCharredLog, 1, 0), ArtificeTooltips.localizeTooltip("charredlog", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockAttunedRedstoneTransmitter, 1, 0), ArtificeTooltips.localizeTooltip("attunedredstone", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockAttunedRedstoneReceiver, 1, 0), ArtificeTooltips.localizeTooltip("attunedredstone", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockLogicRedstone, 1, 0), ArtificeTooltips.localizeTooltip("digital", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockLogicRedstone, 1, 1), ArtificeTooltips.localizeTooltip("analog", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockLogicRedstone, 1, 0), ArtificeTooltips.localizeTooltip("logicredstone", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockLogicRedstone, 1, 1), ArtificeTooltips.localizeTooltip("logicredstone", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockUranium, 1, 0), ArtificeTooltips.localizeTooltip("radioactive", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockUranium, 1, 1), ArtificeTooltips.localizeTooltip("radioactive", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockNuclearBattery, 1, 0), ArtificeTooltips.localizeTooltip("battery.full", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockNuclearBattery, 1, 1), ArtificeTooltips.localizeTooltip("battery.partial", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockNuclearBattery, 1, 2), ArtificeTooltips.localizeTooltip("battery.drained", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockNuclearBattery, 1, 3), ArtificeTooltips.localizeTooltip("battery.empty", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockNuclearBattery, 1, 0), ArtificeTooltips.localizeTooltip("battery", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockNuclearBattery, 1, 1), ArtificeTooltips.localizeTooltip("battery", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockNuclearBattery, 1, 2), ArtificeTooltips.localizeTooltip("battery", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockNuclearBattery, 1, 3), ArtificeTooltips.localizeTooltip("battery", true));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockHeatingCoil, 1, 0), ArtificeTooltips.localizeTooltip("heatingcoil", false));
        ArtificeRegistry.registerTooltip(new ItemStack((Block)ArtificeBlocks.blockHeatingCoil, 1, 0), ArtificeTooltips.localizeTooltip("heatingcoil", true));
    }
}

