/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.ArtificeCore;
import shukaro.artifice.util.NameMetaPair;

public abstract class ArtificeRegistry {
    private static final List<Integer> dimensionBlacklist = new ArrayList<Integer>();
    private static final Set<NameMetaPair> stoneTypes = new HashSet<NameMetaPair>();
    private static final List<String> worldTypeBlacklist = new ArrayList<String>();
    private static final Map<NameMetaPair, List<String>> tooltipMap = new HashMap<NameMetaPair, List<String>>();
    private static final List<ItemStack> marbleTypes = new ArrayList<ItemStack>();
    private static final List<ItemStack> basaltTypes = new ArrayList<ItemStack>();

    public static void registerMarbleType(ItemStack stack) {
        ArtificeCore.logger.info("Registering marble type " + stack.toString());
        if (marbleTypes.isEmpty()) {
            marbleTypes.add(stack);
        } else if (!marbleTypes.contains(stack)) {
            marbleTypes.add(stack);
            if (!ArtificeConfig.stoneCycleRecipes) {
                return;
            }
            if (marbleTypes.size() < 3) {
                ShapelessOreRecipe inner = new ShapelessOreRecipe(marbleTypes.get(1), new Object[]{marbleTypes.get(0)});
                ShapelessOreRecipe wrap = new ShapelessOreRecipe(marbleTypes.get(0), new Object[]{marbleTypes.get(1)});
                CraftingManager.func_77594_a().func_77592_b().add(inner);
                CraftingManager.func_77594_a().func_77592_b().add(wrap);
            } else {
                ShapelessOreRecipe inner = new ShapelessOreRecipe(marbleTypes.get(marbleTypes.size() - 1), new Object[]{marbleTypes.get(marbleTypes.size() - 2)});
                ShapelessOreRecipe wrap = new ShapelessOreRecipe(marbleTypes.get(0), new Object[]{marbleTypes.get(marbleTypes.size() - 1)});
                for (Object o : CraftingManager.func_77594_a().func_77592_b().toArray()) {
                    ArrayList input;
                    ItemStack output;
                    if (!(o instanceof ShapelessOreRecipe) || !(output = ((ShapelessOreRecipe)o).func_77571_b()).func_77969_a(marbleTypes.get(0)) || (input = ((ShapelessOreRecipe)o).getInput()).size() > 1 || !(input.get(0) instanceof ItemStack) || !((ItemStack)input.get(0)).func_77969_a(marbleTypes.get(marbleTypes.size() - 2))) continue;
                    CraftingManager.func_77594_a().func_77592_b().remove(o);
                }
                CraftingManager.func_77594_a().func_77592_b().add(inner);
                CraftingManager.func_77594_a().func_77592_b().add(wrap);
            }
        }
    }

    public static List<ItemStack> getMarbleTypes() {
        return marbleTypes;
    }

    public static void registerBasaltType(ItemStack stack) {
        ArtificeCore.logger.info("Registering basalt type " + stack.toString());
        if (basaltTypes.isEmpty()) {
            basaltTypes.add(stack);
        } else if (!basaltTypes.contains(stack)) {
            basaltTypes.add(stack);
            if (!ArtificeConfig.stoneCycleRecipes) {
                return;
            }
            if (basaltTypes.size() < 3) {
                ShapelessOreRecipe inner = new ShapelessOreRecipe(basaltTypes.get(1), new Object[]{basaltTypes.get(0)});
                ShapelessOreRecipe wrap = new ShapelessOreRecipe(basaltTypes.get(0), new Object[]{basaltTypes.get(1)});
                CraftingManager.func_77594_a().func_77592_b().add(inner);
                CraftingManager.func_77594_a().func_77592_b().add(wrap);
            } else {
                ShapelessOreRecipe inner = new ShapelessOreRecipe(basaltTypes.get(basaltTypes.size() - 1), new Object[]{basaltTypes.get(basaltTypes.size() - 2)});
                ShapelessOreRecipe wrap = new ShapelessOreRecipe(basaltTypes.get(0), new Object[]{basaltTypes.get(basaltTypes.size() - 1)});
                for (Object o : CraftingManager.func_77594_a().func_77592_b().toArray()) {
                    ArrayList input;
                    ItemStack output;
                    if (!(o instanceof ShapelessOreRecipe) || !(output = ((ShapelessOreRecipe)o).func_77571_b()).func_77969_a(basaltTypes.get(0)) || (input = ((ShapelessOreRecipe)o).getInput()).size() > 1 || !(input.get(0) instanceof ItemStack) || !((ItemStack)input.get(0)).func_77969_a(basaltTypes.get(basaltTypes.size() - 2))) continue;
                    CraftingManager.func_77594_a().func_77592_b().remove(o);
                }
                CraftingManager.func_77594_a().func_77592_b().add(inner);
                CraftingManager.func_77594_a().func_77592_b().add(wrap);
            }
        }
    }

    public static List<ItemStack> getBasaltTypes() {
        return basaltTypes;
    }

    public static void registerTooltip(ItemStack stack, String line) {
        NameMetaPair pair = new NameMetaPair(stack.func_77973_b(), stack.func_77960_j());
        if (tooltipMap.get(pair) == null) {
            ArrayList<String> temp = new ArrayList<String>();
            temp.add(line);
            tooltipMap.put(pair, temp);
        } else {
            tooltipMap.get(pair).add(line);
        }
    }

    public static Map<NameMetaPair, List<String>> getTooltipMap() {
        return tooltipMap;
    }

    public static void registerDimensionBlacklist(int dimID) {
        if (!dimensionBlacklist.contains(dimID)) {
            ArtificeCore.logger.info("Registering " + dimID + " to dimension blacklist");
            dimensionBlacklist.add(dimID);
        }
    }

    public static List<Integer> getDimensionBlacklist() {
        return dimensionBlacklist;
    }

    public static void registerStoneType(Block stone, int meta) {
        NameMetaPair pair = new NameMetaPair(stone, meta);
        if (!stoneTypes.contains(pair)) {
            ArtificeCore.logger.info("Registering stone type " + pair.toString());
            stoneTypes.add(pair);
        }
    }

    public static Set<NameMetaPair> getStoneTypes() {
        return stoneTypes;
    }

    public static void registerWorldTypeBlacklist(String type) {
        if (!worldTypeBlacklist.contains(type)) {
            ArtificeCore.logger.info("Registering " + type + " to world type blacklist");
            worldTypeBlacklist.add(type);
        }
    }

    public static List<String> getWorldTypeBlacklist() {
        return worldTypeBlacklist;
    }
}

