/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.init;

import growthcraft.core.common.GrcModuleBlocks;
import growthcraft.core.common.definition.BlockDefinition;
import growthcraft.milk.GrowthCraftMilk;
import growthcraft.milk.common.block.BlockButterChurn;
import growthcraft.milk.common.block.BlockCheeseBlock;
import growthcraft.milk.common.block.BlockCheesePress;
import growthcraft.milk.common.block.BlockCheeseVat;
import growthcraft.milk.common.block.BlockHangingCurds;
import growthcraft.milk.common.block.BlockPancheon;
import growthcraft.milk.common.block.BlockThistle;
import growthcraft.milk.common.item.EnumCheeseType;
import growthcraft.milk.common.item.ItemBlockCheeseBlock;
import growthcraft.milk.common.item.ItemBlockHangingCurds;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class GrcMilkBlocks
extends GrcModuleBlocks {
    public BlockDefinition butterChurn;
    public BlockDefinition cheeseBlock;
    public BlockDefinition cheesePress;
    public BlockDefinition cheeseVat;
    public BlockDefinition hangingCurds;
    public BlockDefinition pancheon;
    public BlockDefinition thistle;

    @Override
    public void preInit() {
        this.butterChurn = this.newDefinition(new BlockButterChurn());
        this.cheeseBlock = this.newDefinition(new BlockCheeseBlock());
        this.cheesePress = this.newDefinition(new BlockCheesePress());
        this.cheeseVat = this.newDefinition(new BlockCheeseVat());
        this.hangingCurds = this.newDefinition(new BlockHangingCurds());
        this.pancheon = this.newDefinition(new BlockPancheon());
        if (GrowthCraftMilk.getConfig().thistleEnabled) {
            this.thistle = this.newDefinition((Block)new BlockThistle());
        }
    }

    private void registerOres() {
        for (EnumCheeseType type : EnumCheeseType.VALUES) {
            OreDictionary.registerOre((String)"blockCheese", (ItemStack)type.asBlockItemStack());
        }
        if (this.thistle != null) {
            OreDictionary.registerOre((String)"flowerThistle", (Item)this.thistle.getItem());
            OreDictionary.registerOre((String)"rennetSource", (Item)this.thistle.getItem());
        }
    }

    @Override
    public void register() {
        this.butterChurn.register("grcmilk.ButterChurn");
        this.cheeseBlock.register("grcmilk.CheeseBlock", ItemBlockCheeseBlock.class);
        this.cheesePress.register("grcmilk.CheesePress");
        this.cheeseVat.register("grcmilk.CheeseVat");
        this.hangingCurds.register("grcmilk.HangingCurds", ItemBlockHangingCurds.class);
        this.pancheon.register("grcmilk.Pancheon");
        if (this.thistle != null) {
            this.thistle.register("grcmilk.Thistle");
        }
        this.registerOres();
    }
}

