/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.api.core.fluids.FluidTest;
import growthcraft.api.milk.MilkRegistry;
import growthcraft.api.milk.churn.IChurnRecipe;
import growthcraft.core.common.inventory.AccesibleSlots;
import growthcraft.core.common.inventory.GrcInternalInventory;
import growthcraft.core.common.tileentity.GrcTileDeviceBase;
import growthcraft.core.common.tileentity.device.DeviceFluidSlot;
import growthcraft.core.common.tileentity.device.DeviceInventorySlot;
import growthcraft.core.common.tileentity.event.TileEventHandler;
import growthcraft.core.common.tileentity.feature.IItemHandler;
import growthcraft.core.util.ItemUtils;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TileEntityButterChurn
extends GrcTileDeviceBase
implements IItemHandler {
    private static AccesibleSlots accessibleSlots = new AccesibleSlots(new int[][]{{0}, new int[0], {0}, {0}, {0}, {0}});
    @SideOnly(value=Side.CLIENT)
    public float animProgress;
    @SideOnly(value=Side.CLIENT)
    public int animDir;
    private int shaftState;
    private int churns;
    private DeviceFluidSlot inputFluidSlot = new DeviceFluidSlot(this, 0);
    private DeviceFluidSlot outputFluidSlot = new DeviceFluidSlot(this, 1);
    private DeviceInventorySlot outputInventorySlot = new DeviceInventorySlot((IInventory)this, 0);

    @Override
    protected FluidTank[] createTanks() {
        return new FluidTank[]{new FluidTank(1000), new FluidTank(1000)};
    }

    @Override
    public GrcInternalInventory createInventory() {
        return new GrcInternalInventory(this, 1);
    }

    @Override
    public String getDefaultInventoryName() {
        return "container.grcmilk.ButterChurn";
    }

    @Override
    public boolean func_94041_b(int index, ItemStack itemstack) {
        return true;
    }

    @Override
    public int[] func_94128_d(int side) {
        return accessibleSlots.slotsAt(side);
    }

    @Override
    public boolean func_102008_b(int index, ItemStack stack, int side) {
        return accessibleSlots.sideContains(side, index);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            float step = 0.2f;
            this.animDir = this.shaftState == 0 ? -1 : 1;
            if (this.animDir > 0 && this.animProgress < 1.0f || this.animDir < 0 && this.animProgress > 0.0f) {
                this.animProgress = MathHelper.func_76131_a((float)(this.animProgress + 0.2f * (float)this.animDir), (float)0.0f, (float)1.0f);
            }
        }
    }

    private IChurnRecipe getWorkingRecipe() {
        FluidStack stack = this.inputFluidSlot.get();
        if (stack != null) {
            IChurnRecipe recipe = MilkRegistry.instance().churn().getRecipe(stack);
            return recipe;
        }
        return null;
    }

    public WorkState doWork() {
        WorkState state = WorkState.NONE;
        IChurnRecipe recipe = this.getWorkingRecipe();
        if (recipe != null) {
            state = WorkState.CHURN;
            ++this.churns;
            if (this.churns >= recipe.getChurns()) {
                this.churns = 0;
                this.inputFluidSlot.consume(recipe.getInputFluidStack(), true);
                this.outputFluidSlot.fill(recipe.getOutputFluidStack(), true);
                this.outputInventorySlot.increaseStack(recipe.getOutputItemStack());
                state = WorkState.PRODUCE;
            }
            this.shaftState = this.shaftState == 0 ? 1 : 0;
            this.markForUpdate();
        } else {
            if (this.shaftState != 0) {
                this.shaftState = 0;
                this.markForUpdate();
            }
            this.churns = 0;
        }
        return state;
    }

    private DeviceFluidSlot getActiveFluidSlot() {
        if (this.outputFluidSlot.hasContent()) {
            return this.outputFluidSlot;
        }
        return this.inputFluidSlot;
    }

    @Override
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return MilkRegistry.instance().churn().isFluidIngredient(fluid);
    }

    @Override
    protected FluidStack doDrain(ForgeDirection dir, int amount, boolean doDrain) {
        if (dir == ForgeDirection.UP) {
            return null;
        }
        return this.getActiveFluidSlot().consume(amount, doDrain);
    }

    @Override
    protected FluidStack doDrain(ForgeDirection dir, FluidStack stack, boolean doDrain) {
        if (dir == ForgeDirection.UP) {
            return null;
        }
        DeviceFluidSlot fluidSlot = this.getActiveFluidSlot();
        if (FluidTest.areStacksEqual(fluidSlot.get(), stack)) {
            return fluidSlot.consume(stack, doDrain);
        }
        return null;
    }

    @Override
    protected int doFill(ForgeDirection dir, FluidStack stack, boolean doFill) {
        if (dir == ForgeDirection.UP) {
            return 0;
        }
        int result = 0;
        if (MilkRegistry.instance().churn().isFluidIngredient(stack)) {
            result = this.inputFluidSlot.fill(stack, doFill);
        }
        return result;
    }

    @Override
    public boolean tryPlaceItem(IItemHandler.Action action, EntityPlayer player, ItemStack stack) {
        return false;
    }

    @Override
    public boolean tryTakeItem(IItemHandler.Action action, EntityPlayer player, ItemStack onHand) {
        if (IItemHandler.Action.RIGHT != action) {
            return false;
        }
        ItemStack stack = this.outputInventorySlot.yank();
        if (stack != null) {
            ItemUtils.addStackToPlayer(stack, player, false);
            return true;
        }
        return false;
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_READ)
    public void readFromNBT_ButterChurn(NBTTagCompound nbt) {
        this.shaftState = nbt.func_74762_e("shaft_state");
        this.churns = nbt.func_74762_e("churns");
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_WRITE)
    public void writeToNBT_ButterChurn(NBTTagCompound nbt) {
        nbt.func_74768_a("shaft_state", this.shaftState);
        nbt.func_74768_a("churns", this.churns);
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_READ)
    public boolean readFromStream_ButterChurn(ByteBuf stream) throws IOException {
        this.shaftState = stream.readInt();
        this.churns = stream.readInt();
        return false;
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_WRITE)
    public boolean writeToStream_ButterChurn(ByteBuf stream) throws IOException {
        stream.writeInt(this.shaftState);
        stream.writeInt(this.churns);
        return false;
    }

    public static enum WorkState {
        NONE,
        CHURN,
        PRODUCE;

    }
}

