/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.block;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.api.core.util.BBox;
import growthcraft.api.core.util.CuboidI;
import growthcraft.core.integration.AppleCore;
import growthcraft.core.logic.FlowerSpread;
import growthcraft.core.logic.ISpreadablePlant;
import growthcraft.milk.GrowthCraftMilk;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class BlockThistle
extends BlockBush
implements ISpreadablePlant,
IGrowable {
    private FlowerSpread spreadLogic;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public BlockThistle() {
        super(Material.field_151585_k);
        this.func_149675_a(true);
        this.func_149663_c("grcmilk.Thistle");
        this.func_149672_a(field_149779_h);
        this.func_149647_a(GrowthCraftMilk.creativeTab);
        BBox bb = BBox.newCube(2.0f, 0.0f, 2.0f, 12.0f, 16.0f, 12.0f).scale(0.0625f);
        this.func_149676_a(bb.x0(), bb.y0(), bb.z0(), bb.x1(), bb.y1(), bb.z1());
        this.spreadLogic = new FlowerSpread(new CuboidI(-1, -1, -1, 2, 2, 2));
    }

    @Override
    public boolean canSpreadTo(World world, int x, int y, int z) {
        return world.func_147437_c(x, y, z) && this.func_149718_j(world, x, y, z);
    }

    private void runSpread(World world, int x, int y, int z, Random random) {
        this.spreadLogic.run((Block)this, 0, world, x, y, z, random);
    }

    private void incrementGrowth(World world, int x, int y, int z, int meta) {
        world.func_72921_c(x, y, z, meta + 1, 2);
        AppleCore.announceGrowthTick((Block)this, world, x, y, z, meta);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        super.func_149674_a(world, x, y, z, random);
        if (!world.field_72995_K) {
            int meta = world.func_72805_g(x, y, z);
            if (meta >= 3) {
                int spreadChance = GrowthCraftMilk.getConfig().thistleSpreadChance;
                if (spreadChance > 0 && random.nextInt(spreadChance) == 0) {
                    this.runSpread(world, x, y, z, random);
                }
            } else {
                int growthChance = GrowthCraftMilk.getConfig().thistleGrowthChance;
                Event.Result allowGrowthResult = AppleCore.validateGrowthTick((Block)this, world, x, y, z, random);
                if (allowGrowthResult == Event.Result.DENY) {
                    return;
                }
                if ((allowGrowthResult == Event.Result.ALLOW || growthChance > 0 && random.nextInt(growthChance) == 0) && meta < 3) {
                    this.incrementGrowth(world, x, y, z, meta);
                }
            }
        }
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Plains;
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean isClient) {
        return true;
    }

    public boolean func_149852_a(World world, Random random, int x, int y, int z) {
        return true;
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        if (meta < 3) {
            if (GrowthCraftMilk.items.seedThistle != null) {
                return GrowthCraftMilk.items.seedThistle.getItem();
            }
            return null;
        }
        return super.func_149650_a(meta, random, fortune);
    }

    public void func_149853_b(World world, Random random, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta < 3) {
            int growthChance = GrowthCraftMilk.getConfig().thistleGrowthChance;
            if (growthChance > 0 && random.nextInt(growthChance) != 0) {
                return;
            }
            this.incrementGrowth(world, x, y, z, meta);
        } else {
            this.runSpread(world, x, y, z, random);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.icons = new IIcon[4];
        this.icons[0] = reg.func_94245_a("grcmilk:thistle/stage1");
        this.icons[1] = reg.func_94245_a("grcmilk:thistle/stage2");
        this.icons[2] = reg.func_94245_a("grcmilk:thistle/stage3");
        this.icons[3] = reg.func_94245_a("grcmilk:thistle/stage4");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta < 0 || meta >= this.icons.length) {
            return this.icons[3];
        }
        return this.icons[meta];
    }

    public static class ThistleStage {
        public static final int SEEDLING = 0;
        public static final int BUD = 1;
        public static final int GROWN = 2;
        public static final int FLOWER = 3;

        private ThistleStage() {
        }
    }
}

