/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.EventBus;
import cpw.mods.fml.common.registry.GameRegistry;
import growthcraft.api.core.log.GrcLogger;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.module.ModuleContainer;
import growthcraft.api.milk.MilkRegistry;
import growthcraft.milk.GrcMilkConfig;
import growthcraft.milk.client.handler.GrcMilkHandleTextureStitch;
import growthcraft.milk.common.CommonProxy;
import growthcraft.milk.common.tileentity.TileEntityButterChurn;
import growthcraft.milk.common.tileentity.TileEntityCheeseBlock;
import growthcraft.milk.common.tileentity.TileEntityCheesePress;
import growthcraft.milk.common.tileentity.TileEntityCheeseVat;
import growthcraft.milk.common.tileentity.TileEntityHangingCurds;
import growthcraft.milk.common.tileentity.TileEntityPancheon;
import growthcraft.milk.creativetab.GrcMilkCreativeTabs;
import growthcraft.milk.eventhandler.EventHandlerOnBabyCowDeath;
import growthcraft.milk.init.GrcMilkBlocks;
import growthcraft.milk.init.GrcMilkEffects;
import growthcraft.milk.init.GrcMilkFluids;
import growthcraft.milk.init.GrcMilkItems;
import growthcraft.milk.init.GrcMilkRecipes;
import growthcraft.milk.init.GrcMilkUserApis;
import growthcraft.milk.integration.MFRModule;
import growthcraft.milk.integration.ThaumcraftModule;
import growthcraft.milk.integration.Waila;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="Growthcraft|Milk", name="Growthcraft Milk", version="1.7.10-2.7.2", dependencies="required-after:Growthcraft;required-after:Growthcraft|Cellar")
public class GrowthCraftMilk {
    public static final String MOD_ID = "Growthcraft|Milk";
    public static final String MOD_NAME = "Growthcraft Milk";
    public static final String MOD_VERSION = "1.7.10-2.7.2";
    public static final String MOD_DEPENDENCIES = "required-after:Growthcraft;required-after:Growthcraft|Cellar";
    @Mod.Instance(value="Growthcraft|Milk")
    public static GrowthCraftMilk instance;
    public static CreativeTabs creativeTab;
    public static final GrcMilkBlocks blocks;
    public static final GrcMilkFluids fluids;
    public static final GrcMilkItems items;
    public static final GrcMilkRecipes recipes;
    public static final GrcMilkUserApis userApis;
    public static final EventBus MILK_BUS;
    private final ILogger logger = new GrcLogger("Growthcraft|Milk");
    private final GrcMilkConfig config = new GrcMilkConfig();
    private final ModuleContainer modules = new ModuleContainer();

    public static GrcMilkConfig getConfig() {
        return GrowthCraftMilk.instance.config;
    }

    public static ILogger getLogger() {
        return GrowthCraftMilk.instance.logger;
    }

    @Mod.EventHandler
    public void preload(FMLPreInitializationEvent event) {
        this.config.setLogger(this.logger);
        this.config.load(event.getModConfigurationDirectory(), "growthcraft/milk.conf");
        if (this.config.debugEnabled) {
            this.modules.setLogger(this.logger);
            MilkRegistry.instance().setLogger(this.logger);
        }
        this.modules.add(blocks);
        this.modules.add(items);
        this.modules.add(fluids);
        this.modules.add(recipes);
        if (this.config.enableMFRIntegration) {
            this.modules.add(new MFRModule());
        }
        if (this.config.enableThaumcraftIntegration) {
            this.modules.add(new ThaumcraftModule());
        }
        if (this.config.enableWailaIntegration) {
            this.modules.add(new Waila());
        }
        this.modules.add(userApis);
        this.modules.add(CommonProxy.instance);
        this.modules.freeze();
        GrcMilkEffects.init();
        userApis.setConfigDirectory(event.getModConfigurationDirectory());
        creativeTab = new GrcMilkCreativeTabs("creative_tab_grcmilk");
        this.modules.preInit();
        MinecraftForge.EVENT_BUS.register((Object)new GrcMilkHandleTextureStitch());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerOnBabyCowDeath());
        this.register();
    }

    private void register() {
        this.modules.register();
        if (GrowthCraftMilk.items.seedThistle != null && this.config.thistleSeedWeight > 0) {
            MinecraftForge.addGrassSeed((ItemStack)GrowthCraftMilk.items.seedThistle.asStack(), (int)this.config.thistleSeedWeight);
        }
        GameRegistry.registerTileEntity(TileEntityButterChurn.class, (String)"grcmilk.tileentity.ButterChurn");
        GameRegistry.registerTileEntity(TileEntityCheeseBlock.class, (String)"grcmilk.tileentity.CheeseBlock");
        GameRegistry.registerTileEntity(TileEntityCheesePress.class, (String)"grcmilk.tileentity.CheesePress");
        GameRegistry.registerTileEntity(TileEntityCheeseVat.class, (String)"grcmilk.tileentity.CheeseVat");
        GameRegistry.registerTileEntity(TileEntityHangingCurds.class, (String)"grcmilk.tileentity.HangingCurds");
        GameRegistry.registerTileEntity(TileEntityPancheon.class, (String)"grcmilk.tileentity.Pancheon");
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        this.modules.init();
        userApis.loadConfigs();
    }

    @Mod.EventHandler
    public void postload(FMLPostInitializationEvent event) {
        this.modules.postInit();
    }

    static {
        blocks = new GrcMilkBlocks();
        fluids = new GrcMilkFluids();
        items = new GrcMilkItems();
        recipes = new GrcMilkRecipes();
        userApis = new GrcMilkUserApis();
        MILK_BUS = new EventBus();
    }
}

