/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.integration.nei;

import codechicken.core.ReflectionManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.DefaultOverlayRenderer;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import growthcraft.api.core.definition.IItemStackListProvider;
import growthcraft.api.core.item.recipes.ShapedMultiRecipe;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;

public class RecipeHandlerShapedMulti
extends TemplateRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(84, 23, 24, 18), "crafting", new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCrafting.class;
    }

    public String getRecipeName() {
        return NEIClientUtils.translate((String)"recipe.shaped", (Object[])new Object[0]);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("crafting") && ((Object)((Object)this)).getClass() == RecipeHandlerShapedMulti.class) {
            for (IRecipe irecipe : CraftingManager.func_77594_a().func_77592_b()) {
                CachedShapedRecipe recipe = null;
                if (irecipe instanceof ShapedMultiRecipe) {
                    recipe = this.forgeShapedRecipe((ShapedMultiRecipe)irecipe);
                }
                if (recipe == null) continue;
                recipe.computeVisuals();
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (IRecipe irecipe : CraftingManager.func_77594_a().func_77592_b()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.func_77571_b(), (ItemStack)result)) continue;
            CachedShapedRecipe recipe = null;
            if (irecipe instanceof ShapedMultiRecipe) {
                recipe = this.forgeShapedRecipe((ShapedMultiRecipe)irecipe);
            }
            if (recipe == null) continue;
            recipe.computeVisuals();
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (IRecipe irecipe : CraftingManager.func_77594_a().func_77592_b()) {
            CachedShapedRecipe recipe = null;
            if (irecipe instanceof ShapedMultiRecipe) {
                recipe = this.forgeShapedRecipe((ShapedMultiRecipe)irecipe);
            }
            if (recipe == null || !recipe.contains(recipe.ingredients, ingredient.func_77973_b())) continue;
            recipe.computeVisuals();
            if (!recipe.contains(recipe.ingredients, ingredient)) continue;
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public CachedShapedRecipe forgeShapedRecipe(ShapedMultiRecipe recipe) {
        int height;
        int width;
        try {
            width = (Integer)ReflectionManager.getField(ShapedMultiRecipe.class, Integer.class, (Object)recipe, (int)4);
            height = (Integer)ReflectionManager.getField(ShapedMultiRecipe.class, Integer.class, (Object)recipe, (int)5);
        }
        catch (Exception e) {
            NEIClientConfig.logger.error("Error loading recipe", (Throwable)e);
            return null;
        }
        ArrayList<Object> items = new ArrayList<Object>();
        for (IItemStackListProvider item : recipe.getInput()) {
            List<ItemStack> stacks = item.getItemStacks();
            if (stacks.isEmpty()) {
                return null;
            }
            items.add(stacks);
        }
        return new CachedShapedRecipe(width, height, items, recipe.func_77571_b());
    }

    public String getGuiTexture() {
        return "textures/gui/container/crafting_table.png";
    }

    public String getOverlayIdentifier() {
        return "crafting";
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return super.hasOverlay(gui, container, recipe) || this.isRecipe2x2(recipe) && RecipeInfo.hasDefaultOverlay((GuiContainer)gui, (String)"crafting2x2");
    }

    public IRecipeOverlayRenderer getOverlayRenderer(GuiContainer gui, int recipe) {
        IRecipeOverlayRenderer renderer = super.getOverlayRenderer(gui, recipe);
        if (renderer != null) {
            return renderer;
        }
        IStackPositioner positioner = RecipeInfo.getStackPositioner((GuiContainer)gui, (String)"crafting2x2");
        if (positioner == null) {
            return null;
        }
        return new DefaultOverlayRenderer(this.getIngredientStacks(recipe), positioner);
    }

    public IOverlayHandler getOverlayHandler(GuiContainer gui, int recipe) {
        IOverlayHandler handler = super.getOverlayHandler(gui, recipe);
        if (handler != null) {
            return handler;
        }
        return RecipeInfo.getOverlayHandler((GuiContainer)gui, (String)"crafting2x2");
    }

    public boolean isRecipe2x2(int recipe) {
        for (PositionedStack stack : this.getIngredientStacks(recipe)) {
            if (stack.relx <= 43 && stack.rely <= 24) continue;
            return false;
        }
        return true;
    }

    public class CachedShapedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        public PositionedStack result;

        public CachedShapedRecipe(int width, int height, ArrayList<Object> items, ItemStack out) {
            super((TemplateRecipeHandler)RecipeHandlerShapedMulti.this);
            this.result = new PositionedStack((Object)out, 119, 24);
            this.ingredients = new ArrayList();
            this.setIngredients(width, height, items);
        }

        public void setIngredients(int width, int height, ArrayList<Object> items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (items.get(y * width + x) == null) continue;
                    PositionedStack stack = new PositionedStack(items.get(y * width + x), 25 + x * 18, 6 + y * 18, false);
                    stack.setMaxSize(1);
                    this.ingredients.add(stack);
                }
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(RecipeHandlerShapedMulti.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public void computeVisuals() {
            for (PositionedStack p : this.ingredients) {
                p.generatePermutations();
            }
        }
    }
}

