/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.integration.forestry;

import growthcraft.api.core.util.Point3;
import growthcraft.core.integration.forestry.AbstractForestryCrop;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class CropBasicGrowthCraft
extends AbstractForestryCrop {
    private final Block block;
    private final int meta;
    private final boolean isRice;
    private final boolean isGrape;

    public CropBasicGrowthCraft(World pworld, Block pblock, int pmeta, Point3 pos, boolean pisRice, boolean pisGrape) {
        super(pworld, pos);
        this.block = pblock;
        this.meta = pmeta;
        this.isRice = pisRice;
        this.isGrape = pisGrape;
    }

    @Override
    protected boolean isCrop(Point3 pos) {
        return this.getBlock(pos) == this.block && this.getBlockMeta(pos) == this.meta;
    }

    @Override
    protected Collection<ItemStack> harvestBlock(Point3 pos) {
        ArrayList harvest = this.block.getDrops(this.world, pos.x, pos.y, pos.z, this.meta, 0);
        if (harvest.size() > 1) {
            harvest.remove(0);
        }
        if (this.isGrape) {
            this.world.func_147468_f(pos.x, pos.y, pos.z);
        } else {
            this.world.func_72921_c(pos.x, pos.y, pos.z, 0, 2);
        }
        if (this.isRice) {
            this.world.func_72921_c(pos.x, pos.y - 1, pos.z, 7, 2);
        }
        return harvest;
    }

    public String toString() {
        return String.format("CropBasicGrowthCraft [ position: [ %s ]; block: %s; meta: %s ]", this.position.toString(), this.block.func_149739_a(), this.meta);
    }
}

