/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.common.tileentity;

import growthcraft.api.core.nbt.INBTSerializable;
import growthcraft.api.core.stream.IStreamable;
import growthcraft.core.common.tileentity.event.TileEventFunction;
import growthcraft.core.common.tileentity.event.TileEventHandler;
import growthcraft.core.common.tileentity.event.TileEventHandlerMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public abstract class GrcTileBase
extends TileEntity
implements IStreamable,
INBTSerializable {
    protected static TileEventHandlerMap<GrcTileBase> HANDLERS = new TileEventHandlerMap();

    public void markForUpdate() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void markDirtyAndUpdate() {
        this.func_70296_d();
        this.markForUpdate();
    }

    protected List<TileEventFunction> getHandlersFor(@Nonnull TileEventHandler.EventType event) {
        return HANDLERS.getEventFunctionsForClass(this.getClass(), event);
    }

    @Override
    public final boolean writeToStream(ByteBuf stream) {
        List<TileEventFunction> handlers = this.getHandlersFor(TileEventHandler.EventType.NETWORK_WRITE);
        if (handlers != null) {
            for (TileEventFunction func : handlers) {
                func.writeToStream(this, stream);
            }
        }
        return false;
    }

    public Packet func_145844_m() {
        NBTTagCompound data = new NBTTagCompound();
        ByteBuf stream = Unpooled.buffer();
        try {
            this.writeToStream(stream);
            if (stream.readableBytes() == 0) {
                return null;
            }
        }
        catch (Throwable t) {
            System.err.println(t);
        }
        data.func_74773_a("P", stream.array());
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 127, data);
    }

    @Override
    public final boolean readFromStream(ByteBuf stream) {
        boolean shouldUpdate = false;
        List<TileEventFunction> handlers = this.getHandlersFor(TileEventHandler.EventType.NETWORK_READ);
        if (handlers != null) {
            for (TileEventFunction func : handlers) {
                if (!func.readFromStream(this, stream)) continue;
                shouldUpdate = true;
            }
        }
        return shouldUpdate;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        if (packet.func_148853_f() == 127) {
            ByteBuf stream;
            NBTTagCompound tag = packet.func_148857_g();
            boolean dirty = false;
            if (tag != null && this.readFromStream(stream = Unpooled.copiedBuffer((byte[])tag.func_74770_j("P")))) {
                dirty = true;
            }
            if (dirty) {
                this.markForUpdate();
            }
        }
    }

    public void readFromNBTForItem(NBTTagCompound tag) {
    }

    public void writeToNBTForItem(NBTTagCompound tag) {
    }

    public final void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        List<TileEventFunction> handlers = this.getHandlersFor(TileEventHandler.EventType.NBT_READ);
        if (handlers != null) {
            for (TileEventFunction func : handlers) {
                func.readFromNBT(this, nbt);
            }
        }
    }

    public final void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        List<TileEventFunction> handlers = this.getHandlersFor(TileEventHandler.EventType.NBT_WRITE);
        if (handlers != null) {
            for (TileEventFunction func : handlers) {
                func.writeToNBT(this, nbt);
            }
        }
    }
}

