/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bees.integration;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import growthcraft.bees.GrowthCraftBees;
import growthcraft.bees.common.block.BlockBeeBox;
import growthcraft.bees.common.block.BlockBeeBoxThaumcraft;
import growthcraft.bees.common.block.EnumBeeBoxThaumcraft;
import growthcraft.bees.common.item.ItemBlockBeeBox;
import growthcraft.cellar.integration.ThaumcraftBoozeHelper;
import growthcraft.core.common.definition.BlockTypeDefinition;
import growthcraft.core.integration.ThaumcraftModuleBase;
import growthcraft.core.integration.thaumcraft.AspectsHelper;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

public class ThaumcraftModule
extends ThaumcraftModuleBase {
    public ThaumcraftModule() {
        super("Growthcraft|Bees");
    }

    @Override
    protected void doPreInit() {
        GrowthCraftBees.blocks.beeBoxThaumcraft = GrowthCraftBees.blocks.newTypedDefinition(new BlockBeeBoxThaumcraft());
        GrowthCraftBees.blocks.beeBoxThaumcraft.getBlock().setFlammability(20).setFireSpreadSpeed(5).setHarvestLevel("axe", 0);
    }

    @Override
    protected void doRegister() {
        if (GrowthCraftBees.blocks.beeBoxThaumcraft != null) {
            GameRegistry.registerBlock((Block)GrowthCraftBees.blocks.beeBoxThaumcraft.getBlock(), ItemBlockBeeBox.class, (String)"grc.BeeBox.Thaumcraft");
        }
    }

    @Override
    protected void doLateRegister() {
        if (GrowthCraftBees.blocks.beeBoxThaumcraft != null) {
            Block blockWoodenDevice = GameRegistry.findBlock((String)this.modID, (String)"blockWoodenDevice");
            if (blockWoodenDevice != null) {
                GameRegistry.addShapedRecipe((ItemStack)EnumBeeBoxThaumcraft.GREATWOOD.asStack(), (Object[])new Object[]{" A ", "A A", "AAA", Character.valueOf('A'), new ItemStack(blockWoodenDevice, 1, 6)});
                GameRegistry.addShapedRecipe((ItemStack)EnumBeeBoxThaumcraft.SILVERWOOD.asStack(), (Object[])new Object[]{" A ", "A A", "AAA", Character.valueOf('A'), new ItemStack(blockWoodenDevice, 1, 7)});
            } else {
                this.logger.warn("Could not find blockWoodenDevice from Thaumcraft, skipping recipes for Thaumcraft Bee Boxes", new Object[0]);
            }
        }
    }

    @Override
    @Optional.Method(modid="Thaumcraft")
    protected void integrate() {
        ThaumcraftApi.registerObjectTag((ItemStack)GrowthCraftBees.items.honeyCombEmpty.asStack(), (AspectList)new AspectList().add(Aspect.ORDER, 1).add(Aspect.VOID, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)GrowthCraftBees.items.honeyCombFilled.asStack(), (AspectList)new AspectList().add(Aspect.ORDER, 1).add(Aspect.SLIME, 1).add(Aspect.GREED, 1).add(Aspect.HUNGER, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)GrowthCraftBees.items.honeyJar.asStack(), (AspectList)new AspectList().add(Aspect.SLIME, 1).add(Aspect.EARTH, 1).add(Aspect.FIRE, 1).add(Aspect.VOID, 1).add(Aspect.GREED, 3).add(Aspect.HUNGER, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)GrowthCraftBees.items.bee.asStack(), (AspectList)new AspectList().add(Aspect.BEAST, 1).add(Aspect.AIR, 1).add(Aspect.FLIGHT, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)GrowthCraftBees.blocks.beeHive.asStack(), (AspectList)new AspectList().add(Aspect.SLIME, 1).add(Aspect.BEAST, 1).add(Aspect.ORDER, 1).add(Aspect.VOID, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)GrowthCraftBees.blocks.beeBox.asStack(), (int[])new int[]{0, 1, 2, 3, 4, 5}, (AspectList)new AspectList().add(Aspect.TREE, 4).add(Aspect.VOID, 1));
        AspectList[] common = new AspectList[]{new AspectList(), new AspectList().add(Aspect.HEAL, 1), new AspectList().add(Aspect.HEAL, 2), new AspectList().add(Aspect.HEAL, 1), new AspectList().add(Aspect.HEAL, 2), new AspectList().add(Aspect.HEAL, 1).add(Aspect.POISON, 1), new AspectList().add(Aspect.POISON, 1)};
        for (int i = 0; i < common.length; ++i) {
            AspectList list = common[i];
            ThaumcraftBoozeHelper.instance().registerAspectsForBottleStack(GrowthCraftBees.fluids.honeyMeadBottle.asStack(1, i), list.copy());
            ThaumcraftBoozeHelper.instance().registerAspectsForBucket(GrowthCraftBees.fluids.honeyMeadBuckets[i], AspectsHelper.scaleAspects(list.copy(), 3, Aspect.HEAL));
            ThaumcraftBoozeHelper.instance().registerAspectsForFluidBlock(GrowthCraftBees.fluids.honeyMeadFluids[i], AspectsHelper.scaleAspects(list.copy(), 3, Aspect.HEAL));
        }
        if (GrowthCraftBees.fluids.honey != null) {
            ItemStack fluidBlock;
            ItemStack bucketStack;
            ItemStack bottleStack = GrowthCraftBees.fluids.honey.asBottleItemStack();
            if (bottleStack != null) {
                ThaumcraftApi.registerObjectTag((ItemStack)bottleStack, (AspectList)new AspectList().add(Aspect.ORDER, 1).add(Aspect.SLIME, 2).add(Aspect.GREED, 1).add(Aspect.HUNGER, 1));
            }
            if ((bucketStack = GrowthCraftBees.fluids.honey.asBottleItemStack()) != null) {
                ThaumcraftApi.registerObjectTag((ItemStack)bucketStack, (AspectList)new AspectList().add(Aspect.ORDER, 1).add(Aspect.SLIME, 6).add(Aspect.GREED, 2).add(Aspect.HUNGER, 2));
            }
            if ((fluidBlock = GrowthCraftBees.fluids.honey.asFluidBlockItemStack()) != null) {
                ThaumcraftApi.registerObjectTag((ItemStack)fluidBlock, (AspectList)new AspectList().add(Aspect.ORDER, 1).add(Aspect.SLIME, 2).add(Aspect.GREED, 1).add(Aspect.HUNGER, 1));
            }
        }
        if (GrowthCraftBees.blocks.beeBoxNether != null) {
            ThaumcraftApi.registerObjectTag((ItemStack)GrowthCraftBees.blocks.beeBoxNether.asStack(1, Short.MAX_VALUE), (AspectList)new AspectList().add(Aspect.TREE, 4).add(Aspect.ENTROPY, 1).add(Aspect.VOID, 1));
        }
        if (GrowthCraftBees.blocks.beeBoxBamboo != null) {
            ThaumcraftApi.registerObjectTag((ItemStack)GrowthCraftBees.blocks.beeBoxBamboo.asStack(1, Short.MAX_VALUE), (AspectList)new AspectList().add(Aspect.TREE, 4).add(Aspect.VOID, 1));
        }
        if (GrowthCraftBees.blocks.beeBoxThaumcraft != null) {
            ThaumcraftApi.registerObjectTag((ItemStack)GrowthCraftBees.blocks.beeBoxThaumcraft.asStack(1, Short.MAX_VALUE), (AspectList)new AspectList().add(Aspect.TREE, 4).add(Aspect.VOID, 1).add(Aspect.MAGIC, 1));
        }
        if (GrowthCraftBees.blocks.beeBoxNatura != null) {
            ThaumcraftApi.registerObjectTag((ItemStack)GrowthCraftBees.blocks.beeBoxNatura.asStack(1, Short.MAX_VALUE), (AspectList)new AspectList().add(Aspect.TREE, 4).add(Aspect.VOID, 1));
        }
        if (GrowthCraftBees.blocks.beeBoxBiomesOPlenty != null) {
            ThaumcraftApi.registerObjectTag((ItemStack)GrowthCraftBees.blocks.beeBoxBiomesOPlenty.asStack(1, Short.MAX_VALUE), (AspectList)new AspectList().add(Aspect.TREE, 4).add(Aspect.VOID, 1));
        }
        if (GrowthCraftBees.blocks.beeBoxBotania != null) {
            ThaumcraftApi.registerObjectTag((ItemStack)GrowthCraftBees.blocks.beeBoxBotania.asStack(1, Short.MAX_VALUE), (AspectList)new AspectList().add(Aspect.TREE, 4).add(Aspect.VOID, 1).add(Aspect.MAGIC, 1));
        }
        if (GrowthCraftBees.blocks.beeBoxesForestry != null) {
            for (BlockTypeDefinition<? extends BlockBeeBox> bdef : GrowthCraftBees.blocks.beeBoxesForestry) {
                if (bdef == null) continue;
                ThaumcraftApi.registerObjectTag((ItemStack)bdef.asStack(1, Short.MAX_VALUE), (AspectList)new AspectList().add(Aspect.TREE, 4).add(Aspect.VOID, 1));
            }
        }
        if (GrowthCraftBees.blocks.beeBoxesForestryFireproof != null) {
            for (BlockTypeDefinition<? extends BlockBeeBox> bdef : GrowthCraftBees.blocks.beeBoxesForestryFireproof) {
                if (bdef == null) continue;
                ThaumcraftApi.registerObjectTag((ItemStack)bdef.asStack(1, Short.MAX_VALUE), (AspectList)new AspectList().add(Aspect.TREE, 4).add(Aspect.VOID, 1));
            }
        }
    }
}

