/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bees.init;

import cpw.mods.fml.common.registry.GameRegistry;
import growthcraft.api.bees.BeesFluidTag;
import growthcraft.api.cellar.booze.Booze;
import growthcraft.api.core.CoreRegistry;
import growthcraft.api.core.GrcFluid;
import growthcraft.bees.GrowthCraftBees;
import growthcraft.cellar.common.definition.BlockBoozeDefinition;
import growthcraft.cellar.common.definition.ItemBucketBoozeDefinition;
import growthcraft.cellar.common.item.ItemBoozeBottle;
import growthcraft.cellar.util.BoozeRegistryHelper;
import growthcraft.core.common.GrcModuleBase;
import growthcraft.core.common.block.GrcBlockFluid;
import growthcraft.core.common.definition.ItemDefinition;
import growthcraft.core.common.definition.ItemTypeDefinition;
import growthcraft.core.common.item.ItemFoodBottleFluid;
import growthcraft.core.integration.forestry.ForestryFluids;
import growthcraft.core.util.FluidFactory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.oredict.OreDictionary;

public class GrcBeesFluids
extends GrcModuleBase {
    public FluidFactory.FluidDetails honey;
    public Booze[] honeyMeadBooze;
    public ItemDefinition honeyMeadBottle;
    public ItemBucketBoozeDefinition[] honeyMeadBuckets;
    public BlockBoozeDefinition[] honeyMeadFluids;

    @Override
    public void preInit() {
        if (GrowthCraftBees.getConfig().honeyEnabled) {
            Fluid honeyFluid = new GrcFluid("grc.honey").setColor(16755713).setDensity(1420).setViscosity(73600);
            this.honey = FluidFactory.instance().create(honeyFluid, 13);
            this.honey.foodBottle = new ItemTypeDefinition<ItemFoodBottleFluid>(new ItemFoodBottleFluid(this.honey.getFluid(), 2, 0.2f, false));
            this.honey.refreshItemColor();
        }
        this.honeyMeadBooze = new Booze[7];
        this.honeyMeadFluids = new BlockBoozeDefinition[this.honeyMeadBooze.length];
        this.honeyMeadBuckets = new ItemBucketBoozeDefinition[this.honeyMeadBooze.length];
        BoozeRegistryHelper.initializeBoozeFluids("grc.honeyMead", this.honeyMeadBooze);
        for (Booze booze : this.honeyMeadBooze) {
            booze.setColor(GrowthCraftBees.getConfig().honeyMeadColor).setDensity(1000).setViscosity(1200);
        }
        BoozeRegistryHelper.initializeBooze(this.honeyMeadBooze, this.honeyMeadFluids, this.honeyMeadBuckets);
        BoozeRegistryHelper.setBoozeFoodStats(this.honeyMeadBooze, 1, -0.45f);
        BoozeRegistryHelper.setBoozeFoodStats(this.honeyMeadBooze[0], 1, 0.45f);
        this.honeyMeadBottle = new ItemDefinition((Item)new ItemBoozeBottle(this.honeyMeadBooze));
        if (this.honey != null) {
            this.honey.setCreativeTab(GrowthCraftBees.tab);
            ((GrcBlockFluid)((Object)this.honey.block.getBlock())).func_149658_d("grcbees:fluids/honey");
            this.honey.refreshItemColor();
        }
    }

    @Override
    public void register() {
        GameRegistry.registerItem(this.honeyMeadBottle.getItem(), (String)"grc.honeyMead");
        BoozeRegistryHelper.registerBooze(this.honeyMeadBooze, this.honeyMeadFluids, this.honeyMeadBuckets, this.honeyMeadBottle, "grc.honeyMead", null);
        if (this.honey != null) {
            this.honey.registerObjects("grc", "Honey");
            CoreRegistry.instance().fluidDictionary().addFluidTags(this.honey.getFluid(), BeesFluidTag.HONEY);
        }
        if (ForestryFluids.HONEY.exists()) {
            CoreRegistry.instance().fluidDictionary().addFluidTags(ForestryFluids.HONEY.getFluid(), BeesFluidTag.HONEY);
        }
    }

    @Override
    public void init() {
        if (this.honey != null) {
            OreDictionary.registerOre((String)"bottleHoney", (ItemStack)this.honey.asBottleItemStack());
            OreDictionary.registerOre((String)"bucketHoney", (ItemStack)this.honey.asBucketItemStack());
            OreDictionary.registerOre((String)"honeyDrop", (ItemStack)this.honey.asBucketItemStack());
            OreDictionary.registerOre((String)"dropHoney", (ItemStack)this.honey.asBucketItemStack());
        }
    }
}

