/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.milk.pancheon;

import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.log.NullLogger;
import growthcraft.api.milk.pancheon.IPancheonRecipe;
import growthcraft.api.milk.pancheon.IPancheonRegistry;
import growthcraft.api.milk.pancheon.PancheonRecipe;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class PancheonRegistry
implements IPancheonRegistry {
    protected ILogger logger = NullLogger.INSTANCE;
    private Map<Fluid, IPancheonRecipe> recipes = new HashMap<Fluid, IPancheonRecipe>();

    @Override
    public void setLogger(@Nonnull ILogger l) {
        this.logger = l;
    }

    @Override
    public void addRecipe(@Nonnull IPancheonRecipe recipe) {
        Fluid fluid = recipe.getInputFluid().getFluid();
        if (this.recipes.containsKey(fluid)) {
            this.logger.warn("Overwriting existing pancheon recipe for {%s} with {%s}", recipe.getInputFluid(), recipe);
        } else {
            this.logger.debug("Adding new pancheon recipe {%s}", recipe);
        }
        this.recipes.put(fluid, recipe);
    }

    @Override
    public void addRecipe(@Nonnull FluidStack inputStack, @Nonnull FluidStack topOutput, @Nullable FluidStack bottomOutput, int time) {
        Fluid fluid = inputStack.getFluid();
        if (fluid == null) {
            throw new IllegalArgumentException("The provided input fluid is invalid.");
        }
        PancheonRecipe recipe = new PancheonRecipe(inputStack, topOutput, bottomOutput, time);
        this.addRecipe(recipe);
    }

    @Override
    @Nullable
    public IPancheonRecipe getRecipe(FluidStack stack) {
        if (stack == null) {
            return null;
        }
        Fluid fluid = stack.getFluid();
        if (fluid == null) {
            return null;
        }
        IPancheonRecipe recipe = this.recipes.get(fluid);
        if (recipe != null && recipe.isValidForRecipe(stack)) {
            return recipe;
        }
        return null;
    }
}

