/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.util;

import javax.annotation.Nonnull;
import net.minecraft.util.MathHelper;

public class GrcColor {
    public float r;
    public float g;
    public float b;
    public float a;

    public GrcColor(float pr, float pg, float pb, float pa) {
        this.set(pr, pg, pb, pa);
    }

    public int hexRGB() {
        return (int)(this.r * 255.0f) << 16 & 0xFF | (int)(this.g * 255.0f) << 8 & 0xFF | (int)(this.b * 255.0f) & 0xFF;
    }

    public int hexRGBA() {
        return (int)(this.a * 255.0f) << 24 & 0xFF | (int)(this.r * 255.0f) << 16 & 0xFF | (int)(this.g * 255.0f) << 8 & 0xFF | (int)(this.b * 255.0f) & 0xFF;
    }

    public GrcColor set(float pr, float pg, float pb, float pa) {
        this.r = MathHelper.func_76131_a((float)pr, (float)0.0f, (float)1.0f);
        this.g = MathHelper.func_76131_a((float)pg, (float)0.0f, (float)1.0f);
        this.b = MathHelper.func_76131_a((float)pb, (float)0.0f, (float)1.0f);
        this.a = MathHelper.func_76131_a((float)pa, (float)0.0f, (float)1.0f);
        return this;
    }

    public GrcColor copy() {
        return new GrcColor(this.r, this.g, this.b, this.a);
    }

    public GrcColor add(@Nonnull GrcColor other) {
        return new GrcColor(this.r + other.r * other.a, this.g + other.g * other.a, this.b + other.b * other.a, this.a);
    }

    public GrcColor sub(@Nonnull GrcColor other) {
        return new GrcColor(this.r - other.r * other.a, this.g - other.g * other.a, this.b - other.b * other.a, this.a);
    }

    public GrcColor mul(@Nonnull GrcColor other) {
        return new GrcColor(this.r * other.r * other.a, this.g * other.g * other.a, this.b * other.b * other.a, this.a);
    }

    public GrcColor mul(@Nonnull float other) {
        return new GrcColor(this.r * other, this.g * other, this.b * other, this.a);
    }

    public GrcColor div(@Nonnull GrcColor other) {
        return new GrcColor(this.r / other.r * other.a, this.g / other.g * other.a, this.b / other.b * other.a, this.a);
    }

    public GrcColor alphaBlend(@Nonnull GrcColor other) {
        float alpha = other.a;
        return new GrcColor(alpha >= 1.0f || this.a <= 0.0f ? other.r : (alpha > 0.0f ? other.r * alpha + this.r * (1.0f - alpha) : this.r), alpha >= 1.0f || this.a <= 0.0f ? other.g : (alpha > 0.0f ? other.g * alpha + this.g * (1.0f - alpha) : this.g), alpha >= 1.0f || this.a <= 0.0f ? other.b : (alpha > 0.0f ? other.b * alpha + this.b * (1.0f - alpha) : this.b), this.a < alpha ? alpha : this.a);
    }

    public GrcColor setRGBA(int pr, int pg, int pb, int pa) {
        return this.set((float)pr / 255.0f, (float)pg / 255.0f, (float)pb / 255.0f, (float)pa / 255.0f);
    }

    public GrcColor setRGB(int pr, int pg, int pb) {
        return this.setRGBA(pr, pg, pb, (int)(this.a * 255.0f));
    }

    public GrcColor setHexRGBA(int hex) {
        return this.setRGBA(hex >> 16 & 0xFF, hex >> 8 & 0xFF, hex & 0xFF, hex >> 24 & 0xFF);
    }

    public GrcColor setHexRGB(int hex) {
        return this.setRGB(hex >> 16 & 0xFF, hex >> 8 & 0xFF, hex & 0xFF);
    }

    public static GrcColor newWhite() {
        return new GrcColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static GrcColor newBlack() {
        return new GrcColor(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public static GrcColor newTransparent() {
        return new GrcColor(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static GrcColor newRGBA(int pr, int pg, int pb, int pa) {
        return GrcColor.newWhite().setRGBA(pr, pg, pb, pa);
    }

    public static GrcColor newRGB(int pr, int pg, int pb) {
        return GrcColor.newWhite().setRGB(pr, pg, pb);
    }

    public static GrcColor newHexRGBA(int hex) {
        return GrcColor.newWhite().setHexRGBA(hex);
    }

    public static GrcColor newHexRGB(int hex) {
        return GrcColor.newWhite().setHexRGB(hex);
    }

    public static GrcColor lerp(GrcColor a, GrcColor b, float f) {
        return new GrcColor(a.r + (b.r - a.r) * f, a.g + (b.g - a.g) * f, a.b + (b.b - a.b) * f, a.a + (b.a - a.a) * f);
    }
}

