/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.schema;

import growthcraft.api.core.definition.IItemStackListProvider;
import growthcraft.api.core.schema.ICommentable;
import growthcraft.api.core.schema.IValidatable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreItemSchema
implements IItemStackListProvider,
IValidatable,
ICommentable {
    public String comment = "";
    public String name;
    public int amount;

    public OreItemSchema(String n, int a) {
        this.name = n;
        this.amount = a;
    }

    public OreItemSchema() {
    }

    @Override
    public void setComment(String comm) {
        this.comment = comm;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public List<ItemStack> getOres() {
        if (this.name != null) {
            return OreDictionary.getOres((String)this.name);
        }
        return null;
    }

    @Override
    public List<ItemStack> getItemStacks() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        List<ItemStack> ores = this.getOres();
        if (ores != null) {
            for (ItemStack stack : ores) {
                ItemStack newStack = stack.func_77946_l();
                newStack.field_77994_a = this.amount;
                result.add(newStack);
            }
        }
        return result;
    }

    public String toString() {
        return String.format("Schema<OreItem>(name: '%s', amount: %s)", this.name, this.amount);
    }

    @Override
    public boolean isValid() {
        return this.name != null;
    }

    @Override
    public boolean isInvalid() {
        return !this.isValid();
    }
}

