/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.schema;

import cpw.mods.fml.common.registry.GameRegistry;
import growthcraft.api.core.schema.ICommentable;
import growthcraft.api.core.schema.IValidatable;
import growthcraft.api.core.util.BlockKey;
import net.minecraft.block.Block;

public class BlockKeySchema
implements ICommentable,
IValidatable {
    public String comment;
    public String mod_id;
    public String name;
    public int meta;

    public BlockKeySchema(String pmod_id, String pname, int pmeta) {
        this.mod_id = pmod_id;
        this.name = pname;
        this.meta = pmeta;
        this.comment = "";
    }

    public BlockKeySchema(Block block, int pmeta) {
        GameRegistry.UniqueIdentifier uuid = GameRegistry.findUniqueIdentifierFor((Block)block);
        this.mod_id = uuid.modId;
        this.name = uuid.name;
        this.meta = pmeta;
        this.comment = block.func_149732_F();
    }

    public BlockKeySchema(BlockKey blockKey) {
        this(blockKey.block, blockKey.meta);
    }

    public BlockKeySchema() {
        this.comment = "";
    }

    public Block getBlock() {
        if (this.mod_id != null && this.name != null) {
            return GameRegistry.findBlock((String)this.mod_id, (String)this.name);
        }
        return null;
    }

    public BlockKey toBlockKey() {
        Block block = this.getBlock();
        if (block != null) {
            return new BlockKey(block, this.meta);
        }
        return null;
    }

    @Override
    public void setComment(String comm) {
        this.comment = comm;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public boolean isValid() {
        return this.getBlock() != null;
    }

    @Override
    public boolean isInvalid() {
        return !this.isValid();
    }

    public String toString() {
        return String.format("Schema<BlockKey>(mod_id: '%s', name: '%s', meta: %d)", this.mod_id, this.name, this.meta);
    }
}

