/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.effect;

import growthcraft.api.core.CoreRegistry;
import growthcraft.api.core.description.Describer;
import growthcraft.api.core.effect.AbstractEffect;
import growthcraft.api.core.effect.IEffect;
import growthcraft.api.core.i18n.GrcI18n;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EffectChance
extends AbstractEffect {
    private float chance;
    private IEffect effect;

    public EffectChance(IEffect effekt) {
        this.effect = effekt;
    }

    public EffectChance() {
    }

    public EffectChance setChance(float chan) {
        this.chance = chan;
        return this;
    }

    public float getChance() {
        return this.chance;
    }

    public IEffect getEffect() {
        return this.effect;
    }

    public EffectChance setEffect(IEffect effekt) {
        this.effect = effekt;
        return this;
    }

    @Override
    public void apply(World world, Entity entity, Random random, Object data) {
        if (this.effect != null && (float)random.nextInt(2000) / 2000.0f < this.chance) {
            this.effect.apply(world, entity, random, data);
        }
    }

    @Override
    protected void getActualDescription(List<String> list) {
        if (this.effect != null) {
            ArrayList<String> tempList = new ArrayList<String>();
            this.effect.getDescription(tempList);
            if (tempList.size() > 0) {
                String str = GrcI18n.translate("grc.effect.chance.format", (int)(this.chance * 100.0f));
                Describer.compactDescription(str, list, tempList);
            }
        }
    }

    @Override
    protected void readFromNBT(NBTTagCompound data) {
        this.chance = data.func_74760_g("chance");
        if (data.func_74764_b("effect")) {
            this.effect = CoreRegistry.instance().getEffectsRegistry().loadEffectFromNBT(data, "effect");
        }
    }

    @Override
    protected void writeToNBT(NBTTagCompound data) {
        data.func_74776_a("chance", this.chance);
        if (this.effect != null) {
            this.effect.writeToNBT(data, "effect");
        }
    }
}

