/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.cellar.util;

import growthcraft.api.cellar.CellarRegistry;
import growthcraft.api.cellar.booze.BoozeEffect;
import growthcraft.api.cellar.common.Residue;
import growthcraft.api.cellar.util.ICellarBoozeBuilder;
import growthcraft.api.core.CoreRegistry;
import growthcraft.api.core.definition.IMultiFluidStacks;
import growthcraft.api.core.fluids.FluidTag;
import growthcraft.api.core.util.MultiStacksUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class CellarBoozeBuilder
implements ICellarBoozeBuilder {
    protected Fluid fluid;

    public CellarBoozeBuilder(@Nonnull Fluid f) {
        this.fluid = f;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    @Override
    public ICellarBoozeBuilder tags(FluidTag ... tags) {
        CoreRegistry.instance().fluidDictionary().addFluidTags(this.fluid, tags);
        return this;
    }

    @Override
    public ICellarBoozeBuilder brewsTo(@Nonnull FluidStack result, @Nonnull Object stack, int time, @Nullable Residue residue) {
        CellarRegistry.instance().brewing().addRecipe(new FluidStack(this.fluid, result.amount), stack, result, time, residue);
        return this;
    }

    @Override
    public ICellarBoozeBuilder brewsFrom(@Nonnull FluidStack src, @Nonnull Object stack, int time, @Nullable Residue residue) {
        CellarRegistry.instance().brewing().addRecipe(src, stack, new FluidStack(this.fluid, src.amount), time, residue);
        return this;
    }

    @Override
    public ICellarBoozeBuilder fermentsTo(@Nonnull FluidStack result, @Nonnull Object stack, int time) {
        CellarRegistry.instance().fermenting().addRecipe(result, new FluidStack(this.fluid, result.amount), stack, time);
        return this;
    }

    @Override
    public ICellarBoozeBuilder fermentsFrom(@Nonnull Object srcFluid, @Nonnull Object stack, int time) {
        IMultiFluidStacks src = MultiStacksUtil.toMultiFluidStacks(srcFluid);
        CellarRegistry.instance().fermenting().addRecipe(new FluidStack(this.fluid, src.getAmount()), src, stack, time);
        return this;
    }

    @Override
    public ICellarBoozeBuilder pressesFrom(@Nonnull Object stack, int time, int amount, @Nullable Residue residue) {
        CellarRegistry.instance().pressing().addRecipe(stack, new FluidStack(this.fluid, amount), time, residue);
        return this;
    }

    @Override
    public ICellarBoozeBuilder culturesTo(int amount, @Nonnull ItemStack stack, float heat, int time) {
        CellarRegistry.instance().culturing().addRecipe(new FluidStack(this.fluid, amount), stack, heat, time);
        return this;
    }

    @Override
    public BoozeEffect getEffect() {
        return CellarRegistry.instance().booze().getEffect(this.fluid);
    }

    public static CellarBoozeBuilder create(Fluid f) {
        return new CellarBoozeBuilder(f);
    }
}

