/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.cellar.brewing;

import growthcraft.api.cellar.brewing.BrewingRecipe;
import growthcraft.api.cellar.brewing.IBrewingRegistry;
import growthcraft.api.cellar.common.Residue;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.log.NullLogger;
import growthcraft.api.core.util.MultiStacksUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class BrewingRegistry
implements IBrewingRegistry {
    private List<BrewingRecipe> recipes = new ArrayList<BrewingRecipe>();
    private ILogger logger = NullLogger.INSTANCE;

    @Override
    public void setLogger(@Nonnull ILogger l) {
        this.logger = l;
    }

    @Override
    public void addRecipe(@Nonnull BrewingRecipe recipe) {
        this.recipes.add(recipe);
        this.logger.debug("Added Brewing Recipe recipe={%s}", recipe);
    }

    @Override
    public void addRecipe(@Nonnull FluidStack sourceFluid, @Nonnull Object raw, @Nonnull FluidStack resultFluid, int time, @Nullable Residue residue) {
        this.addRecipe(new BrewingRecipe(sourceFluid, MultiStacksUtil.toMultiItemStacks(raw), resultFluid, time, residue));
    }

    @Override
    public BrewingRecipe findRecipe(@Nullable FluidStack fluidstack, @Nullable ItemStack itemstack) {
        if (itemstack == null || fluidstack == null) {
            return null;
        }
        for (BrewingRecipe recipe : this.recipes) {
            if (!recipe.matchesRecipe(fluidstack, itemstack)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public List<BrewingRecipe> findRecipes(@Nullable FluidStack fluid) {
        ArrayList<BrewingRecipe> result = new ArrayList<BrewingRecipe>();
        if (fluid != null) {
            for (BrewingRecipe recipe : this.recipes) {
                if (!recipe.matchesIngredient(fluid)) continue;
                result.add(recipe);
            }
        }
        return result;
    }

    @Override
    public List<BrewingRecipe> findRecipes(@Nullable ItemStack fermenter) {
        ArrayList<BrewingRecipe> result = new ArrayList<BrewingRecipe>();
        if (fermenter != null) {
            for (BrewingRecipe recipe : this.recipes) {
                if (!recipe.matchesIngredient(fermenter)) continue;
                result.add(recipe);
            }
        }
        return result;
    }

    @Override
    public boolean isBrewingRecipe(@Nullable FluidStack fluidstack, @Nullable ItemStack itemstack) {
        return this.findRecipe(fluidstack, itemstack) != null;
    }

    @Override
    public boolean isItemBrewingIngredient(@Nullable ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        for (BrewingRecipe recipe : this.recipes) {
            if (!recipe.isItemIngredient(itemstack)) continue;
            return true;
        }
        return false;
    }
}

