/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.cellar.brewing;

import growthcraft.api.cellar.common.ProcessingRecipe;
import growthcraft.api.cellar.common.Residue;
import growthcraft.api.core.definition.IMultiItemStacks;
import growthcraft.api.core.fluids.FluidTest;
import growthcraft.api.core.item.ItemTest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class BrewingRecipe
extends ProcessingRecipe {
    private IMultiItemStacks inputItemStack;
    private FluidStack inputFluidStack;

    public BrewingRecipe(@Nonnull FluidStack pInputFluid, @Nonnull IMultiItemStacks pInputItem, @Nonnull FluidStack pOutputFluid, int pTime, @Nullable Residue pResidue) {
        super(pOutputFluid, pTime, pResidue);
        this.inputItemStack = pInputItem;
        this.inputFluidStack = pInputFluid;
    }

    public IMultiItemStacks getInputItemStack() {
        return this.inputItemStack;
    }

    public FluidStack getInputFluidStack() {
        return this.inputFluidStack;
    }

    public boolean matchesRecipe(@Nullable FluidStack fluidStack, @Nullable ItemStack itemStack) {
        if (fluidStack != null && itemStack != null) {
            if (!FluidTest.hasEnough(this.inputFluidStack, fluidStack)) {
                return false;
            }
            return ItemTest.hasEnough(this.inputItemStack, itemStack);
        }
        return false;
    }

    public boolean matchesIngredient(@Nullable FluidStack fluidStack) {
        return FluidTest.fluidMatches(this.inputFluidStack, fluidStack);
    }

    public boolean matchesIngredient(@Nullable ItemStack stack) {
        return ItemTest.itemMatches(this.inputItemStack, stack);
    }

    public boolean isItemIngredient(@Nullable ItemStack stack) {
        return stack != null && this.inputItemStack.containsItemStack(stack);
    }
}

