/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.bees;

import growthcraft.api.bees.GenericFlowerBlockEntry;
import growthcraft.api.bees.IBeesRegistry;
import growthcraft.api.bees.IFlowerBlockEntry;
import growthcraft.api.core.item.ItemKey;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.log.NullLogger;
import growthcraft.api.core.util.BlockKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BeesRegistry
implements IBeesRegistry {
    private static final BeesRegistry INSTANCE = new BeesRegistry();
    private final List<ItemKey> beesList = new ArrayList<ItemKey>();
    private final Map<ItemKey, ItemStack> emptyToFullHoneyComb = new HashMap<ItemKey, ItemStack>();
    private final Map<ItemKey, ItemStack> fullToEmptyHoneyComb = new HashMap<ItemKey, ItemStack>();
    private final Map<BlockKey, IFlowerBlockEntry> flowerEntries = new HashMap<BlockKey, IFlowerBlockEntry>();
    private ILogger logger = NullLogger.INSTANCE;

    public static final BeesRegistry instance() {
        return INSTANCE;
    }

    @Override
    public void setLogger(@Nonnull ILogger l) {
        this.logger = l;
    }

    private ItemKey stackToKey(@Nonnull ItemStack itemstack) {
        return new ItemKey(itemstack);
    }

    public void addBee(@Nonnull Item bee, int meta) {
        this.logger.debug("Adding Bee {%s}:%d", bee, meta);
        this.beesList.add(new ItemKey(bee, meta));
    }

    public void addBee(@Nonnull Block bee, int meta) {
        this.addBee(Item.func_150898_a((Block)bee), meta);
    }

    public void addBee(@Nonnull ItemStack stack) {
        ItemKey key = this.stackToKey(stack);
        this.logger.debug("Adding Bee {%s}", key);
        this.beesList.add(key);
    }

    public void addBee(@Nonnull Item bee) {
        this.addBee(bee, Short.MAX_VALUE);
    }

    public void addBee(@Nonnull Block bee) {
        this.addBee(Item.func_150898_a((Block)bee), Short.MAX_VALUE);
    }

    protected void addHoneyCombMapping(@Nonnull ItemStack empty, @Nonnull ItemStack full) {
        this.logger.debug("Adding Honey Comb mapping {%s} - {%s}", empty, full);
        this.emptyToFullHoneyComb.put(this.stackToKey(empty), full);
        this.fullToEmptyHoneyComb.put(this.stackToKey(full), empty);
    }

    public void addHoneyComb(@Nonnull ItemStack empty, @Nonnull ItemStack full) {
        this.addHoneyCombMapping(empty, full);
    }

    public ItemStack getFilledHoneyComb(@Nonnull ItemStack itemstack) {
        return this.emptyToFullHoneyComb.get(this.stackToKey(itemstack));
    }

    public ItemStack getEmptyHoneyComb(@Nonnull ItemStack itemstack) {
        return this.fullToEmptyHoneyComb.get(this.stackToKey(itemstack));
    }

    protected boolean isItemFilledHoneyComb(@Nonnull ItemKey key) {
        return this.fullToEmptyHoneyComb.containsKey(key);
    }

    public boolean isItemFilledHoneyComb(@Nonnull ItemStack itemstack) {
        return this.isItemFilledHoneyComb(this.stackToKey(itemstack));
    }

    protected boolean isItemEmptyHoneyComb(@Nonnull ItemKey key) {
        return this.emptyToFullHoneyComb.containsKey(key);
    }

    public boolean isItemEmptyHoneyComb(@Nonnull ItemStack itemstack) {
        return this.isItemEmptyHoneyComb(this.stackToKey(itemstack));
    }

    public boolean isItemHoneyComb(@Nonnull ItemStack itemstack) {
        ItemKey key = this.stackToKey(itemstack);
        return this.isItemFilledHoneyComb(key) || this.isItemEmptyHoneyComb(key);
    }

    public void addFlower(@Nonnull BlockKey key, @Nonnull IFlowerBlockEntry entry) {
        this.logger.debug("Adding Flower {%s}:{%s}", key, entry);
        this.flowerEntries.put(key, entry);
    }

    public void addFlower(@Nonnull IFlowerBlockEntry entry) {
        this.addFlower(new BlockKey(entry.getBlock(), entry.getMetadata()), entry);
    }

    public void addFlower(@Nonnull Block flower, int meta) {
        this.addFlower(new BlockKey(flower, meta), new GenericFlowerBlockEntry(flower, meta));
    }

    public void addFlower(@Nonnull Block flower) {
        this.addFlower(flower, Short.MAX_VALUE);
    }

    public boolean isItemBee(@Nullable ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        Item item = itemstack.func_77973_b();
        int meta = itemstack.func_77960_j();
        for (ItemKey key : this.beesList) {
            if (item != key.item || key.meta != Short.MAX_VALUE && key.meta != meta) continue;
            return true;
        }
        return false;
    }

    public IFlowerBlockEntry getFlowerBlockEntry(@Nonnull BlockKey key) {
        return this.flowerEntries.get(key);
    }

    public IFlowerBlockEntry getFlowerBlockEntry(@Nullable Block block, int meta) {
        if (block == null) {
            return null;
        }
        IFlowerBlockEntry entry = this.getFlowerBlockEntry(new BlockKey(block, meta));
        if (entry != null) {
            return entry;
        }
        return this.getFlowerBlockEntry(new BlockKey(block, Short.MAX_VALUE));
    }

    public boolean isBlockFlower(@Nullable Block block, int meta) {
        return this.flowerEntries.containsKey(new BlockKey(block, meta)) || this.flowerEntries.containsKey(new BlockKey(block, Short.MAX_VALUE));
    }
}

