/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.util;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import de.ellpeck.actuallyadditions.api.Position;
import de.ellpeck.actuallyadditions.mod.util.FakePlayerUtil;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C07PacketPlayerDigging;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;

public class WorldUtil {
    public static final ForgeDirection[] VERTICAL_DIRECTIONS_ORDER = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
    public static final ForgeDirection[] CARDINAL_DIRECTIONS_ORDER = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST};

    public static void breakBlockAtSide(ForgeDirection side, World world, int x, int y, int z) {
        WorldUtil.breakBlockAtSide(side, world, x, y, z, 0);
    }

    public static void breakBlockAtSide(ForgeDirection side, World world, int x, int y, int z, int offset) {
        if (side == ForgeDirection.UNKNOWN) {
            world.func_147468_f(x, y, z);
            return;
        }
        Position c = WorldUtil.getCoordsFromSide(side, x, y, z, offset);
        if (c != null) {
            world.func_147468_f(c.getX(), c.getY(), c.getZ());
        }
    }

    public static Position getCoordsFromSide(ForgeDirection side, int x, int y, int z, int offset) {
        if (side == ForgeDirection.UNKNOWN) {
            return null;
        }
        return new Position(x + side.offsetX * (offset + 1), y + side.offsetY * (offset + 1), z + side.offsetZ * (offset + 1));
    }

    public static void pushEnergy(World world, int x, int y, int z, ForgeDirection side, EnergyStorage storage) {
        TileEntity tile = WorldUtil.getTileEntityFromSide(side, world, x, y, z);
        if (tile != null && tile instanceof IEnergyReceiver && storage.getEnergyStored() > 0 && ((IEnergyReceiver)tile).canConnectEnergy(side.getOpposite())) {
            int receive = ((IEnergyReceiver)tile).receiveEnergy(side.getOpposite(), Math.min(storage.getMaxExtract(), storage.getEnergyStored()), false);
            storage.extractEnergy(receive, false);
        }
    }

    public static TileEntity getTileEntityFromSide(ForgeDirection side, World world, int x, int y, int z) {
        Position c = WorldUtil.getCoordsFromSide(side, x, y, z, 0);
        if (c != null) {
            return world.func_147438_o(c.getX(), c.getY(), c.getZ());
        }
        return null;
    }

    public static boolean hasBlocksInPlacesGiven(int[][] positions, Block block, int meta, World world, int x, int y, int z) {
        for (int[] xYZ : positions) {
            if (world.func_147439_a(x + xYZ[0], y + xYZ[1], z + xYZ[2]) == block && world.func_72805_g(x + xYZ[0], y + xYZ[1], z + xYZ[2]) == meta) continue;
            return false;
        }
        return true;
    }

    public static void pushFluid(World world, int x, int y, int z, ForgeDirection side, FluidTank tank) {
        TileEntity tile = WorldUtil.getTileEntityFromSide(side, world, x, y, z);
        if (tile != null && tank.getFluid() != null && tile instanceof IFluidHandler && ((IFluidHandler)tile).canFill(side.getOpposite(), tank.getFluid().getFluid())) {
            int receive = ((IFluidHandler)tile).fill(side.getOpposite(), tank.getFluid(), true);
            tank.drain(receive, true);
        }
    }

    public static ItemStack placeBlockAtSide(ForgeDirection side, World world, int x, int y, int z, ItemStack stack) {
        if (world instanceof WorldServer && stack != null && stack.func_77973_b() != null) {
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
            if (fluid != null && fluid.getFluid().getBlock() != null && fluid.getFluid().getBlock().func_149742_c(world, x + side.offsetX, y + side.offsetY, z + side.offsetZ)) {
                Block block = world.func_147439_a(x + side.offsetX, y + side.offsetY, z + side.offsetZ);
                if (!(block instanceof IFluidBlock) && block != Blocks.field_150353_l && block != Blocks.field_150355_j && block != Blocks.field_150356_k && block != Blocks.field_150358_i && world.func_147449_b(x + side.offsetX, y + side.offsetY, z + side.offsetZ, fluid.getFluid().getBlock())) {
                    return stack.func_77973_b().getContainerItem(stack);
                }
            } else if (stack.func_77973_b() == Items.field_151137_ax) {
                world.func_147449_b(x + side.offsetX, y + side.offsetY, z + side.offsetZ, (Block)Blocks.field_150488_af);
                --stack.field_77994_a;
            } else if (stack.func_77973_b() instanceof IPlantable) {
                if (((IPlantable)stack.func_77973_b()).getPlant((IBlockAccess)world, x, y, z).func_149742_c(world, x + side.offsetX, y + side.offsetY, z + side.offsetZ) && world.func_147449_b(x + side.offsetX, y + side.offsetY, z + side.offsetZ, ((IPlantable)stack.func_77973_b()).getPlant((IBlockAccess)world, x, y, z))) {
                    --stack.field_77994_a;
                }
            } else {
                try {
                    stack.func_77943_a((EntityPlayer)FakePlayerUtil.getFakePlayer(world), world, x, y, z, side == ForgeDirection.UNKNOWN ? 0 : side.ordinal(), 0.0f, 0.0f, 0.0f);
                    return stack;
                }
                catch (Exception e) {
                    ModUtil.LOGGER.error("Something that places Blocks at " + x + ", " + y + ", " + z + " in World " + world.field_73011_w.field_76574_g + " threw an Exception! Don't let that happen again!");
                }
            }
        }
        return stack;
    }

    public static boolean dropItemAtSide(ForgeDirection side, World world, int x, int y, int z, ItemStack stack) {
        Position coords;
        if (side != ForgeDirection.UNKNOWN && (coords = WorldUtil.getCoordsFromSide(side, x, y, z, 0)) != null) {
            EntityItem item = new EntityItem(world, (double)coords.getX() + 0.5, (double)coords.getY() + 0.5, (double)coords.getZ() + 0.5, stack);
            item.field_70159_w = 0.0;
            item.field_70181_x = 0.0;
            item.field_70179_y = 0.0;
            world.func_72838_d((Entity)item);
        }
        return false;
    }

    public static void fillBucket(FluidTank tank, ItemStack[] slots, int inputSlot, int outputSlot) {
        int cap;
        ItemStack filled;
        if (slots[inputSlot] != null && tank.getFluid() != null && (filled = FluidContainerRegistry.fillFluidContainer((FluidStack)tank.getFluid(), (ItemStack)slots[inputSlot].func_77946_l())) != null && FluidContainerRegistry.isEmptyContainer((ItemStack)slots[inputSlot]) && (slots[outputSlot] == null || slots[outputSlot].func_77969_a(filled) && slots[outputSlot].field_77994_a < slots[outputSlot].func_77976_d()) && (cap = FluidContainerRegistry.getContainerCapacity((FluidStack)tank.getFluid(), (ItemStack)slots[inputSlot])) > 0 && cap <= tank.getFluidAmount()) {
            if (slots[outputSlot] == null) {
                slots[outputSlot] = FluidContainerRegistry.fillFluidContainer((FluidStack)tank.getFluid(), (ItemStack)slots[inputSlot].func_77946_l());
            } else {
                ++slots[outputSlot].field_77994_a;
            }
            if (slots[outputSlot] != null) {
                tank.drain(cap, true);
                --slots[inputSlot].field_77994_a;
                if (slots[inputSlot].field_77994_a <= 0) {
                    slots[inputSlot] = null;
                }
            }
        }
    }

    public static void emptyBucket(FluidTank tank, ItemStack[] slots, int inputSlot, int outputSlot) {
        WorldUtil.emptyBucket(tank, slots, inputSlot, outputSlot, null);
    }

    public static void emptyBucket(FluidTank tank, ItemStack[] slots, int inputSlot, int outputSlot, Fluid containedFluid) {
        if (slots[inputSlot] != null && FluidContainerRegistry.isFilledContainer((ItemStack)slots[inputSlot]) && (slots[outputSlot] == null || slots[outputSlot].func_77969_a(FluidContainerRegistry.drainFluidContainer((ItemStack)slots[inputSlot].func_77946_l())) && slots[outputSlot].field_77994_a < slots[outputSlot].func_77976_d()) && (containedFluid == null || FluidContainerRegistry.containsFluid((ItemStack)slots[inputSlot], (FluidStack)new FluidStack(containedFluid, 0))) && (tank.getFluid() == null || FluidContainerRegistry.getFluidForFilledItem((ItemStack)slots[inputSlot]).isFluidEqual(tank.getFluid())) && tank.getCapacity() - tank.getFluidAmount() >= FluidContainerRegistry.getContainerCapacity((ItemStack)slots[inputSlot])) {
            if (slots[outputSlot] == null) {
                slots[outputSlot] = FluidContainerRegistry.drainFluidContainer((ItemStack)slots[inputSlot].func_77946_l());
            } else {
                ++slots[outputSlot].field_77994_a;
            }
            tank.fill(FluidContainerRegistry.getFluidForFilledItem((ItemStack)slots[inputSlot]), true);
            --slots[inputSlot].field_77994_a;
            if (slots[inputSlot].field_77994_a <= 0) {
                slots[inputSlot] = null;
            }
        }
    }

    public static ForgeDirection getDirectionBySidesInOrder(int side) {
        if (side >= 0 && side < VERTICAL_DIRECTIONS_ORDER.length + CARDINAL_DIRECTIONS_ORDER.length) {
            if (side < VERTICAL_DIRECTIONS_ORDER.length) {
                return VERTICAL_DIRECTIONS_ORDER[side];
            }
            return CARDINAL_DIRECTIONS_ORDER[side - VERTICAL_DIRECTIONS_ORDER.length];
        }
        return ForgeDirection.UNKNOWN;
    }

    public static ArrayList<Material> getMaterialsAround(World world, int x, int y, int z) {
        ArrayList<Material> blocks = new ArrayList<Material>();
        blocks.add(world.func_147439_a(x + 1, y, z).func_149688_o());
        blocks.add(world.func_147439_a(x - 1, y, z).func_149688_o());
        blocks.add(world.func_147439_a(x, y, z + 1).func_149688_o());
        blocks.add(world.func_147439_a(x, y, z - 1).func_149688_o());
        return blocks;
    }

    public static boolean addToInventory(IInventory inventory, int start, int end, ArrayList<ItemStack> stacks, boolean actuallyDo) {
        return WorldUtil.addToInventory(inventory, start, end, stacks, ForgeDirection.UNKNOWN, actuallyDo);
    }

    public static boolean addToInventory(IInventory inventory, int start, int end, ArrayList<ItemStack> stacks, ForgeDirection side, boolean actuallyDo) {
        ItemStack[] backupSlots = null;
        if (!actuallyDo) {
            backupSlots = new ItemStack[inventory.func_70302_i_()];
            for (int i = 0; i < backupSlots.length; ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                if (stack == null) continue;
                backupSlots[i] = stack.func_77946_l();
            }
        }
        int working = 0;
        block1: for (ItemStack stackToPutIn : stacks) {
            for (int i = start; i < end; ++i) {
                if (side != ForgeDirection.UNKNOWN && (inventory instanceof ISidedInventory && !((ISidedInventory)inventory).func_102007_a(i, stackToPutIn, side.ordinal()) || !inventory.func_94041_b(i, stackToPutIn))) continue;
                ItemStack stackInQuestion = inventory.func_70301_a(i);
                if (stackToPutIn == null || stackInQuestion != null && (!stackInQuestion.func_77969_a(stackToPutIn) || stackInQuestion.func_77976_d() < stackInQuestion.field_77994_a + stackToPutIn.field_77994_a)) continue;
                if (stackInQuestion == null) {
                    inventory.func_70299_a(i, stackToPutIn.func_77946_l());
                } else {
                    stackInQuestion.field_77994_a += stackToPutIn.field_77994_a;
                }
                ++working;
                continue block1;
            }
        }
        if (!actuallyDo && backupSlots != null) {
            for (int i = 0; i < backupSlots.length; ++i) {
                inventory.func_70299_a(i, backupSlots[i]);
            }
        }
        return working >= stacks.size();
    }

    public static boolean addToInventory(IInventory inventory, ArrayList<ItemStack> stacks, boolean actuallyDo) {
        return WorldUtil.addToInventory(inventory, stacks, ForgeDirection.UNKNOWN, actuallyDo);
    }

    public static boolean addToInventory(IInventory inventory, ArrayList<ItemStack> stacks, ForgeDirection side, boolean actuallyDo) {
        return WorldUtil.addToInventory(inventory, 0, inventory.func_70302_i_(), stacks, side, actuallyDo);
    }

    public static int findFirstFilledSlot(ItemStack[] slots) {
        for (int i = 0; i < slots.length; ++i) {
            if (slots[i] == null) continue;
            return i;
        }
        return 0;
    }

    public static MovingObjectPosition getNearestPositionWithAir(World world, EntityPlayer player, int reach) {
        return WorldUtil.getMovingObjectPosWithReachDistance(world, player, reach, false, false, true);
    }

    private static MovingObjectPosition getMovingObjectPosWithReachDistance(World world, EntityPlayer player, double distance, boolean p1, boolean p2, boolean p3) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f + (double)(world.field_72995_K ? player.func_70047_e() - player.getDefaultEyeHeight() : player.func_70047_e());
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        Vec3 vec31 = vec3.func_72441_c((double)f7 * distance, (double)f6 * distance, (double)f8 * distance);
        return world.func_147447_a(vec3, vec31, p1, p2, p3);
    }

    public static MovingObjectPosition getNearestBlockWithDefaultReachDistance(World world, EntityPlayer player) {
        return WorldUtil.getMovingObjectPosWithReachDistance(world, player, player instanceof EntityPlayerMP ? ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance() : 5.0, false, true, false);
    }

    public static boolean playerHarvestBlock(World world, int xPos, int yPos, int zPos, EntityPlayer player) {
        BlockEvent.BreakEvent event;
        Block block = world.func_147439_a(xPos, yPos, zPos);
        int meta = world.func_72805_g(xPos, yPos, zPos);
        boolean canHarvest = block.canHarvestBlock(player, meta);
        if (player instanceof EntityPlayerMP && (event = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)((EntityPlayerMP)player).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)player), (int)xPos, (int)yPos, (int)zPos)).isCanceled()) {
            return false;
        }
        if (!world.field_72995_K) {
            block.func_149681_a(world, xPos, yPos, zPos, meta, player);
        } else {
            world.func_72926_e(2001, xPos, yPos, zPos, Block.func_149682_b((Block)block) + (meta << 12));
        }
        boolean removed = block.removedByPlayer(world, player, xPos, yPos, zPos, canHarvest);
        if (removed) {
            block.func_149664_b(world, xPos, yPos, zPos, meta);
            if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d) {
                if (canHarvest) {
                    block.func_149636_a(world, player, xPos, yPos, zPos, meta);
                }
                if (!EnchantmentHelper.func_77502_d((EntityLivingBase)player)) {
                    block.func_149657_c(world, xPos, yPos, zPos, block.getExpDrop((IBlockAccess)world, meta, EnchantmentHelper.func_77517_e((EntityLivingBase)player)));
                }
            }
        }
        if (!world.field_72995_K) {
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(xPos, yPos, zPos, world));
            }
        } else {
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C07PacketPlayerDigging(2, xPos, yPos, zPos, Minecraft.func_71410_x().field_71476_x.field_72310_e));
        }
        return removed;
    }
}

