/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.tile.IFluidSaver;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityFermentingBarrel
extends TileEntityInventoryBase
implements IFluidHandler,
IFluidSaver {
    private static final int PROCESS_TIME = 100;
    public FluidTank canolaTank = new FluidTank(2000);
    public FluidTank oilTank = new FluidTank(2000);
    public int currentProcessTime;
    private int lastCanola;
    private int lastOil;
    private int lastProcessTime;

    public TileEntityFermentingBarrel() {
        super(4, "fermentingBarrel");
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            int produce = 80;
            if (this.canolaTank.getFluidAmount() >= produce && produce <= this.oilTank.getCapacity() - this.oilTank.getFluidAmount()) {
                ++this.currentProcessTime;
                if (this.currentProcessTime >= 100) {
                    this.currentProcessTime = 0;
                    this.oilTank.fill(new FluidStack(InitBlocks.fluidOil, produce), true);
                    this.canolaTank.drain(produce, true);
                    this.func_70296_d();
                }
            } else {
                this.currentProcessTime = 0;
            }
            WorldUtil.emptyBucket(this.canolaTank, this.slots, 0, 1, InitBlocks.fluidCanolaOil);
            WorldUtil.fillBucket(this.oilTank, this.slots, 2, 3);
            if (this.oilTank.getFluidAmount() > 0) {
                WorldUtil.pushFluid(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.DOWN, this.oilTank);
                if (!this.isRedstonePowered) {
                    WorldUtil.pushFluid(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.NORTH, this.oilTank);
                    WorldUtil.pushFluid(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.EAST, this.oilTank);
                    WorldUtil.pushFluid(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.SOUTH, this.oilTank);
                    WorldUtil.pushFluid(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.WEST, this.oilTank);
                }
            }
            if ((this.canolaTank.getFluidAmount() != this.lastCanola || this.oilTank.getFluidAmount() != this.lastOil || this.currentProcessTime != this.lastProcessTime) && this.sendUpdateWithInterval()) {
                this.lastProcessTime = this.currentProcessTime;
                this.lastCanola = this.canolaTank.getFluidAmount();
                this.lastOil = this.oilTank.getFluidAmount();
            }
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, boolean sync) {
        compound.func_74768_a("ProcessTime", this.currentProcessTime);
        this.canolaTank.writeToNBT(compound);
        NBTTagCompound tag = new NBTTagCompound();
        this.oilTank.writeToNBT(tag);
        compound.func_74782_a("OilTank", (NBTBase)tag);
        super.writeSyncableNBT(compound, sync);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, boolean sync) {
        this.currentProcessTime = compound.func_74762_e("ProcessTime");
        this.canolaTank.readFromNBT(compound);
        this.oilTank.readFromNBT((NBTTagCompound)compound.func_74781_a("OilTank"));
        super.readSyncableNBT(compound, sync);
    }

    @SideOnly(value=Side.CLIENT)
    public int getProcessScaled(int i) {
        return this.currentProcessTime * i / 100;
    }

    @SideOnly(value=Side.CLIENT)
    public int getOilTankScaled(int i) {
        return this.oilTank.getFluidAmount() * i / this.oilTank.getCapacity();
    }

    @SideOnly(value=Side.CLIENT)
    public int getCanolaTankScaled(int i) {
        return this.canolaTank.getFluidAmount() * i / this.canolaTank.getCapacity();
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return i == 0 && FluidContainerRegistry.containsFluid((ItemStack)stack, (FluidStack)new FluidStack(InitBlocks.fluidCanolaOil, 1000)) || i == 2 && stack.func_77973_b() == Items.field_151133_ar;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1 && stack.func_77973_b() == Items.field_151133_ar || slot == 3 && FluidContainerRegistry.containsFluid((ItemStack)stack, (FluidStack)new FluidStack(InitBlocks.fluidOil, 1000));
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (from != ForgeDirection.DOWN && resource.getFluid() == InitBlocks.fluidCanolaOil) {
            return this.canolaTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource.getFluid() == InitBlocks.fluidOil) {
            return this.oilTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.oilTank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from != ForgeDirection.DOWN && fluid == InitBlocks.fluidCanolaOil;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from != ForgeDirection.UP && fluid == InitBlocks.fluidOil;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.canolaTank.getInfo(), this.oilTank.getInfo()};
    }

    @Override
    public FluidStack[] getFluids() {
        return new FluidStack[]{this.oilTank.getFluid(), this.canolaTank.getFluid()};
    }

    @Override
    public void setFluids(FluidStack[] fluids) {
        this.oilTank.setFluid(fluids[0]);
        this.canolaTank.setFluid(fluids[1]);
    }
}

