/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks.base;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.mod.blocks.base.ItemBlockBase;
import de.ellpeck.actuallyadditions.mod.creative.CreativeTab;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class BlockPlant
extends BlockCrops {
    public Item seedItem;
    public Item returnItem;
    public int returnMeta;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] textures;
    private int stages;
    private String name;
    private int minDropAmount;
    private int addDropAmount;

    public BlockPlant(String name, int stages, int minDropAmount, int addDropAmount) {
        this.name = name;
        this.stages = stages;
        this.minDropAmount = minDropAmount;
        this.addDropAmount = addDropAmount;
        this.register();
    }

    private void register() {
        this.func_149663_c(ModUtil.MOD_ID_LOWER + "." + this.getBaseName());
        GameRegistry.registerBlock((Block)this, this.getItemBlock(), (String)this.getBaseName());
        if (this.shouldAddCreative()) {
            this.func_149647_a(CreativeTab.instance);
        } else {
            this.func_149647_a(null);
        }
    }

    protected String getBaseName() {
        return this.name;
    }

    protected Class<? extends ItemBlockBase> getItemBlock() {
        return ItemBlockBase.class;
    }

    public boolean shouldAddCreative() {
        return true;
    }

    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.rare;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Crop;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta < 7) {
            if (meta == 6) {
                meta = 5;
            }
            return this.textures[meta >> 1];
        }
        return this.textures[this.textures.length - 1];
    }

    public Item func_149866_i() {
        return this.seedItem;
    }

    public Item func_149865_P() {
        return this.returnItem;
    }

    public Item func_149650_a(int meta, Random rand, int par3) {
        return meta >= 7 ? this.func_149865_P() : this.func_149866_i();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconReg) {
        this.textures = new IIcon[this.stages];
        for (int i = 0; i < this.textures.length; ++i) {
            this.textures[i] = iconReg.func_94245_a(ModUtil.MOD_ID_LOWER + ":" + this.getBaseName() + "Stage" + (i + 1));
        }
    }

    public int func_149692_a(int meta) {
        return meta >= 7 ? this.returnMeta : 0;
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return 0;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return meta >= 7 ? random.nextInt(this.addDropAmount) + this.minDropAmount : super.quantityDropped(meta, fortune, random);
    }
}

