/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import forestry.core.config.Config;
import forestry.core.proxy.Proxies;
import forestry.core.render.ForestryResource;
import forestry.mail.POBoxInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiMailboxInfo
extends Gui {
    public static final GuiMailboxInfo instance = new GuiMailboxInfo();
    private static final int WIDTH = 98;
    private static final int HEIGHT = 17;
    private final FontRenderer fontRendererObj;
    private POBoxInfo poInfo;
    private final ResourceLocation textureAlert = new ForestryResource("textures/gui/mailalert.png");

    private GuiMailboxInfo() {
        this.fontRendererObj = Proxies.common.getClientInstance().field_71466_p;
    }

    public void render() {
        if (this.poInfo == null || !Config.mailAlertEnabled || !this.poInfo.hasMail()) {
            return;
        }
        int x = 0;
        int y = 0;
        Minecraft minecraft = Minecraft.func_71410_x();
        ScaledResolution scaledresolution = new ScaledResolution(minecraft, minecraft.field_71443_c, minecraft.field_71440_d);
        if (Config.mailAlertXPosition == XPosition.RIGHT) {
            x = scaledresolution.func_78326_a() - 98;
        }
        if (Config.mailAlertYPosition == YPosition.BOTTOM) {
            y = scaledresolution.func_78328_b() - 17;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Proxies.render.bindTexture(this.textureAlert);
        this.func_73729_b(x, y, 0, 0, 98, 17);
        this.fontRendererObj.func_78276_b(Integer.toString(this.poInfo.playerLetters), x + 27 + this.getCenteredOffset(Integer.toString(this.poInfo.playerLetters), 22), y + 5, 0xFFFFFF);
        this.fontRendererObj.func_78276_b(Integer.toString(this.poInfo.tradeLetters), x + 75 + this.getCenteredOffset(Integer.toString(this.poInfo.tradeLetters), 22), y + 5, 0xFFFFFF);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.fontRendererObj.func_78256_a(string)) / 2;
    }

    public boolean hasPOBoxInfo() {
        return this.poInfo != null;
    }

    public void setPOBoxInfo(POBoxInfo info) {
        boolean playJingle = false;
        if (info.hasMail()) {
            if (this.poInfo == null) {
                playJingle = true;
            } else if (this.poInfo.playerLetters != info.playerLetters || this.poInfo.tradeLetters != info.tradeLetters) {
                playJingle = true;
            }
        }
        if (playJingle) {
            Proxies.common.getRenderWorld().func_72956_a((Entity)Proxies.common.getClientInstance().field_71439_g, "random.levelup", 1.0f, 1.0f);
        }
        this.poInfo = info;
    }

    public static enum YPosition {
        TOP,
        BOTTOM;

    }

    public static enum XPosition {
        LEFT,
        RIGHT;

    }
}

