/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.compactsolars;

import cpw.mods.compactsolars.BlockCompactSolar;
import cpw.mods.compactsolars.CommonProxy;
import cpw.mods.compactsolars.CompactSolarType;
import cpw.mods.compactsolars.ItemCompactSolar;
import cpw.mods.compactsolars.ItemSolarHat;
import cpw.mods.compactsolars.Version;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;

@Mod(modid="CompactSolars", name="Compact Solar Arrays", dependencies="required-after:Forge@[10.12,);required-after:IC2@[2.1,)")
public class CompactSolars {
    @SidedProxy(clientSide="cpw.mods.compactsolars.client.ClientProxy", serverSide="cpw.mods.compactsolars.CommonProxy")
    public static CommonProxy proxy;
    public static BlockCompactSolar compactSolarBlock;
    public static int productionRate;
    @Mod.Instance(value="CompactSolars")
    public static CompactSolars instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent preinit) {
        Version.init(preinit.getVersionProperties());
        preinit.getModMetadata().version = Version.version();
        Configuration cfg = new Configuration(preinit.getSuggestedConfigurationFile());
        try {
            cfg.load();
            compactSolarBlock = new BlockCompactSolar();
            CompactSolarType.buildHats();
            Property scale = cfg.get("general", "scaleFactor", 1);
            scale.comment = "The EU generation scaling factor. The average number of ticks needed to generate one EU packet.1 is every tick, 2 is every other tick etc. Each Solar will still generate a whole packet (8, 64, 512 EU).";
            productionRate = scale.getInt(1);
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"CompactSolars was unable to load it's configuration successfully", (Object[])new Object[0]);
            throw new RuntimeException(e);
        }
        finally {
            cfg.save();
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent init) {
        GameRegistry.registerBlock((Block)compactSolarBlock, ItemCompactSolar.class, (String)"CompactSolarBlock");
        for (CompactSolarType typ : CompactSolarType.values()) {
            GameRegistry.registerTileEntity(typ.clazz, (String)typ.tileEntityName());
        }
        proxy.registerTileEntityRenderers();
        proxy.registerRenderInformation();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
    }

    @Mod.EventHandler
    public void modsLoaded(FMLPostInitializationEvent postinit) {
        CompactSolarType.generateRecipes(compactSolarBlock);
        CompactSolarType.generateHatRecipes(compactSolarBlock);
    }

    @Mod.EventHandler
    public void resetMap(FMLServerStoppingEvent evt) {
        ItemSolarHat.clearRaining();
    }

    static {
        productionRate = 1;
    }
}

